/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.internal.Keep;
import java.nio.ByteBuffer;
import java.util.Date;

@Keep
public enum RealmFieldType {
    INTEGER(0),
    BOOLEAN(1),
    STRING(2),
    BINARY(4),
    DATE(8),
    FLOAT(9),
    DOUBLE(10),
    OBJECT(12),
    LIST(13),
    LINKING_OBJECTS(14),
    INTEGER_LIST(128),
    BOOLEAN_LIST(129),
    STRING_LIST(130),
    BINARY_LIST(132),
    DATE_LIST(136),
    FLOAT_LIST(137),
    DOUBLE_LIST(138);

    private static final RealmFieldType[] basicTypes;
    private static final RealmFieldType[] listTypes;
    private final int nativeValue;

    private RealmFieldType(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getNativeValue() {
        return this.nativeValue;
    }

    public boolean isValid(Object obj) {
        switch (this.nativeValue) {
            case 0: {
                return obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte;
            }
            case 1: {
                return obj instanceof Boolean;
            }
            case 2: {
                return obj instanceof String;
            }
            case 4: {
                return obj instanceof byte[] || obj instanceof ByteBuffer;
            }
            case 8: {
                return obj instanceof Date;
            }
            case 9: {
                return obj instanceof Float;
            }
            case 10: {
                return obj instanceof Double;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 128: {
                return false;
            }
            case 129: {
                return false;
            }
            case 130: {
                return false;
            }
            case 132: {
                return false;
            }
            case 136: {
                return false;
            }
            case 137: {
                return false;
            }
            case 138: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported Realm type:  " + (Object)((Object)this));
    }

    public static RealmFieldType fromNativeValue(int value) {
        RealmFieldType e;
        int elementValue;
        RealmFieldType e2;
        if (0 <= value && value < basicTypes.length && (e2 = basicTypes[value]) != null) {
            return e2;
        }
        if (128 <= value && (elementValue = value - 128) < listTypes.length && (e = listTypes[elementValue]) != null) {
            return e;
        }
        throw new IllegalArgumentException("Invalid native Realm type: " + value);
    }

    static {
        basicTypes = new RealmFieldType[15];
        listTypes = new RealmFieldType[15];
        for (RealmFieldType columnType : RealmFieldType.values()) {
            int nativeValue = columnType.nativeValue;
            if (nativeValue < 128) {
                RealmFieldType.basicTypes[nativeValue] = columnType;
                continue;
            }
            RealmFieldType.listTypes[nativeValue - 128] = columnType;
        }
    }
}

