/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.ImportFlag;
import io.realm.ManagedListOperator;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.internal.OsList;
import io.realm.internal.OsObjectStore;
import io.realm.internal.RealmObjectProxy;
import java.util.Locale;
import javax.annotation.Nullable;

final class RealmModelListOperator<T>
extends ManagedListOperator<T> {
    @Nullable
    private final String className;

    RealmModelListOperator(BaseRealm realm, OsList osList, @Nullable Class<T> clazz, @Nullable String className) {
        super(realm, osList, clazz);
        this.className = className;
    }

    @Override
    public boolean forRealmModel() {
        return true;
    }

    @Override
    public T get(int index) {
        return (T)this.realm.get(this.clazz, this.className, this.osList.getUncheckedRow(index));
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("RealmList does not accept null values.");
        }
        if (!(value instanceof RealmModel)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.String", value.getClass().getName()));
        }
    }

    private void checkInsertIndex(int index) {
        int size = this.size();
        if (index < 0 || size < index) {
            throw new IndexOutOfBoundsException("Invalid index " + index + ", size is " + this.osList.size());
        }
    }

    @Override
    public void appendValue(Object value) {
        RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded((RealmModel)value);
        this.osList.addRow(proxy.realmGet$proxyState().getRow$realm().getIndex());
    }

    @Override
    protected void insertNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    public void insertValue(int index, Object value) {
        this.checkInsertIndex(index);
        RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded((RealmModel)value);
        this.osList.insertRow(index, proxy.realmGet$proxyState().getRow$realm().getIndex());
    }

    @Override
    protected void setNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    protected void setValue(int index, Object value) {
        RealmObjectProxy proxy = (RealmObjectProxy)this.copyToRealmIfNeeded((RealmModel)value);
        this.osList.setRow(index, proxy.realmGet$proxyState().getRow$realm().getIndex());
    }

    private <E extends RealmModel> E copyToRealmIfNeeded(E object) {
        Realm realm;
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            if (proxy instanceof DynamicRealmObject) {
                String listClassName = this.className;
                if (proxy.realmGet$proxyState().getRealm$realm() == this.realm) {
                    String objectClassName = ((DynamicRealmObject)object).getType();
                    if (listClassName.equals(objectClassName)) {
                        return object;
                    }
                    throw new IllegalArgumentException(String.format(Locale.US, "The object has a different type from list's. Type of the list is '%s', type of object is '%s'.", listClassName, objectClassName));
                }
                if (this.realm.threadId == proxy.realmGet$proxyState().getRealm$realm().threadId) {
                    throw new IllegalArgumentException("Cannot copy DynamicRealmObject between Realm instances.");
                }
                throw new IllegalStateException("Cannot copy an object to a Realm instance created in another thread.");
            }
            if (proxy.realmGet$proxyState().getRow$realm() != null && proxy.realmGet$proxyState().getRealm$realm().getPath().equals(this.realm.getPath())) {
                if (this.realm != proxy.realmGet$proxyState().getRealm$realm()) {
                    throw new IllegalArgumentException("Cannot copy an object from another Realm instance.");
                }
                return object;
            }
        }
        if (OsObjectStore.getPrimaryKeyForObject((realm = (Realm)this.realm).getSharedRealm(), realm.getConfiguration().getSchemaMediator().getSimpleClassName(object.getClass())) != null) {
            return realm.copyToRealmOrUpdate(object, new ImportFlag[0]);
        }
        return realm.copyToRealm(object, new ImportFlag[0]);
    }
}

