/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.Property;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ColumnInfo {
    private final Map<String, ColumnDetails> indicesFromJavaFieldNames;
    private final Map<String, ColumnDetails> indicesFromColumnNames;
    private final Map<String, String> javaFieldNameToInternalNames;
    private final boolean mutable;

    protected ColumnInfo(int mapSize) {
        this(mapSize, true);
    }

    protected ColumnInfo(@Nullable ColumnInfo src, boolean mutable) {
        this(src == null ? 0 : src.indicesFromJavaFieldNames.size(), mutable);
        if (src != null) {
            this.indicesFromJavaFieldNames.putAll(src.indicesFromJavaFieldNames);
        }
    }

    private ColumnInfo(int mapSize, boolean mutable) {
        this.indicesFromJavaFieldNames = new HashMap<String, ColumnDetails>(mapSize);
        this.indicesFromColumnNames = new HashMap<String, ColumnDetails>(mapSize);
        this.javaFieldNameToInternalNames = new HashMap<String, String>(mapSize);
        this.mutable = mutable;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public long getColumnIndex(String javaFieldName) {
        ColumnDetails details = this.indicesFromJavaFieldNames.get(javaFieldName);
        return details == null ? -1L : details.columnIndex;
    }

    @Nullable
    public ColumnDetails getColumnDetails(String javaFieldName) {
        return this.indicesFromJavaFieldNames.get(javaFieldName);
    }

    @Nullable
    public String getInternalFieldName(String javaFieldName) {
        return this.javaFieldNameToInternalNames.get(javaFieldName);
    }

    public void copyFrom(ColumnInfo src) {
        if (!this.mutable) {
            throw new UnsupportedOperationException("Attempt to modify an immutable ColumnInfo");
        }
        if (null == src) {
            throw new NullPointerException("Attempt to copy null ColumnInfo");
        }
        this.indicesFromJavaFieldNames.clear();
        this.indicesFromJavaFieldNames.putAll(src.indicesFromJavaFieldNames);
        this.indicesFromColumnNames.clear();
        this.indicesFromColumnNames.putAll(src.indicesFromColumnNames);
        this.javaFieldNameToInternalNames.clear();
        this.javaFieldNameToInternalNames.putAll(src.javaFieldNameToInternalNames);
        this.copy(src, this);
    }

    public String toString() {
        boolean commaNeeded;
        StringBuilder buf = new StringBuilder("ColumnInfo[");
        buf.append("mutable=" + this.mutable).append(",");
        if (this.indicesFromJavaFieldNames != null) {
            buf.append("JavaFieldNames=[");
            commaNeeded = false;
            for (Map.Entry<String, ColumnDetails> entry : this.indicesFromJavaFieldNames.entrySet()) {
                if (commaNeeded) {
                    buf.append(",");
                }
                buf.append(entry.getKey()).append("->").append(entry.getValue());
                commaNeeded = true;
            }
            buf.append("]");
        }
        if (this.indicesFromColumnNames != null) {
            buf.append(", InternalFieldNames=[");
            commaNeeded = false;
            for (Map.Entry<String, ColumnDetails> entry : this.indicesFromColumnNames.entrySet()) {
                if (commaNeeded) {
                    buf.append(",");
                }
                buf.append(entry.getKey()).append("->").append(entry.getValue());
                commaNeeded = true;
            }
            buf.append("]");
        }
        return buf.append("]").toString();
    }

    protected abstract ColumnInfo copy(boolean var1);

    protected abstract void copy(ColumnInfo var1, ColumnInfo var2);

    protected final long addColumnDetails(String javaFieldName, String internalColumnName, OsObjectSchemaInfo objectSchemaInfo) {
        Property property = objectSchemaInfo.getProperty(internalColumnName);
        ColumnDetails cd = new ColumnDetails(property);
        this.indicesFromJavaFieldNames.put(javaFieldName, cd);
        this.indicesFromColumnNames.put(internalColumnName, cd);
        this.javaFieldNameToInternalNames.put(javaFieldName, internalColumnName);
        return property.getColumnIndex();
    }

    protected final void addBacklinkDetails(OsSchemaInfo schemaInfo, String javaFieldName, String sourceTableName, String sourceJavaFieldName) {
        long columnIndex = schemaInfo.getObjectSchemaInfo(sourceTableName).getProperty(sourceJavaFieldName).getColumnIndex();
        this.indicesFromJavaFieldNames.put(javaFieldName, new ColumnDetails(columnIndex, RealmFieldType.LINKING_OBJECTS, sourceTableName));
    }

    public Map<String, ColumnDetails> getIndicesMap() {
        return this.indicesFromJavaFieldNames;
    }

    public static final class ColumnDetails {
        public final long columnIndex;
        public final RealmFieldType columnType;
        public final String linkedClassName;

        private ColumnDetails(long columnIndex, RealmFieldType columnType, @Nullable String linkedClassName) {
            this.columnIndex = columnIndex;
            this.columnType = columnType;
            this.linkedClassName = linkedClassName;
        }

        ColumnDetails(Property property) {
            this(property.getColumnIndex(), property.getType(), property.getLinkedObjectName());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("ColumnDetails[");
            buf.append(this.columnIndex);
            buf.append(", ").append((Object)this.columnType);
            buf.append(", ").append(this.linkedClassName);
            return buf.append("]").toString();
        }
    }
}

