/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedCollectionChangeSet;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.sync.OsSubscription;
import java.util.Arrays;
import javax.annotation.Nullable;

public class OsCollectionChangeSet
implements OrderedCollectionChangeSet,
NativeObject {
    public static final int TYPE_DELETION = 0;
    public static final int TYPE_INSERTION = 1;
    public static final int TYPE_MODIFICATION = 2;
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static long finalizerPtr = OsCollectionChangeSet.nativeGetFinalizerPtr();
    private final long nativePtr;
    private final boolean firstAsyncCallback;
    protected final OsSubscription subscription;
    protected final boolean isPartialRealm;

    public OsCollectionChangeSet(long nativePtr, boolean firstAsyncCallback) {
        this(nativePtr, firstAsyncCallback, null, false);
    }

    public OsCollectionChangeSet(long nativePtr, boolean firstAsyncCallback, @Nullable OsSubscription subscription, boolean isPartialRealm) {
        this.nativePtr = nativePtr;
        this.firstAsyncCallback = firstAsyncCallback;
        this.subscription = subscription;
        this.isPartialRealm = isPartialRealm;
        NativeContext.dummyContext.addReference(this);
    }

    @Override
    public OrderedCollectionChangeSet.State getState() {
        throw new UnsupportedOperationException("This method should be overridden in a subclass");
    }

    @Override
    public int[] getDeletions() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 0);
    }

    @Override
    public int[] getInsertions() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 1);
    }

    @Override
    public int[] getChanges() {
        return OsCollectionChangeSet.nativeGetIndices(this.nativePtr, 2);
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getDeletionRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 0));
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getInsertionRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 1));
    }

    @Override
    public OrderedCollectionChangeSet.Range[] getChangeRanges() {
        return this.longArrayToRangeArray(OsCollectionChangeSet.nativeGetRanges(this.nativePtr, 2));
    }

    @Override
    public Throwable getError() {
        if (this.subscription != null && this.subscription.getState() == OsSubscription.SubscriptionState.ERROR) {
            return this.subscription.getError();
        }
        return null;
    }

    @Override
    public boolean isCompleteResult() {
        throw new UnsupportedOperationException("This method should be overridden in a subclass");
    }

    public boolean isRemoteDataLoaded() {
        if (!this.isPartialRealm) {
            return true;
        }
        if (this.subscription == null) {
            return false;
        }
        return this.subscription.getState() == OsSubscription.SubscriptionState.COMPLETE;
    }

    public boolean isFirstAsyncCallback() {
        return this.firstAsyncCallback;
    }

    public boolean isEmpty() {
        return this.nativePtr == 0L;
    }

    private OrderedCollectionChangeSet.Range[] longArrayToRangeArray(int[] longArray) {
        if (longArray == null) {
            return new OrderedCollectionChangeSet.Range[0];
        }
        OrderedCollectionChangeSet.Range[] ranges = new OrderedCollectionChangeSet.Range[longArray.length / 2];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = new OrderedCollectionChangeSet.Range(longArray[i * 2], longArray[i * 2 + 1]);
        }
        return ranges;
    }

    public String toString() {
        if (this.nativePtr == 0L) {
            return "Change set is empty.";
        }
        String string = "Deletion Ranges: " + Arrays.toString(this.getDeletionRanges()) + "\nInsertion Ranges: " + Arrays.toString(this.getInsertionRanges()) + "\nChange Ranges: " + Arrays.toString(this.getChangeRanges());
        return string;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return finalizerPtr;
    }

    private static native long nativeGetFinalizerPtr();

    private static native int[] nativeGetRanges(long var0, int var2);

    private static native int[] nativeGetIndices(long var0, int var2);
}

