/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import io.realm.internal.CheckedRow;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.TableQuery;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import java.util.Date;
import javax.annotation.Nullable;

public class Table
implements NativeObject {
    private static final String TABLE_PREFIX = Util.getTablePrefix();
    private static final int TABLE_NAME_MAX_LENGTH = 63;
    public static final int CLASS_NAME_MAX_LENGTH = 63 - TABLE_PREFIX.length();
    public static final long INFINITE = -1L;
    public static final boolean NULLABLE = true;
    public static final boolean NOT_NULLABLE = false;
    public static final int NO_MATCH = -1;
    public static final int MAX_BINARY_SIZE = 0xFFFFF0;
    public static final int MAX_STRING_SIZE = 0xFFFFEF;
    private static final long nativeFinalizerPtr = Table.nativeGetFinalizerPtr();
    private final long nativePtr;
    private final NativeContext context;
    private final OsSharedRealm sharedRealm;

    Table(Table parent, long nativePointer) {
        this(parent.sharedRealm, nativePointer);
    }

    Table(OsSharedRealm sharedRealm, long nativePointer) {
        this.context = sharedRealm.context;
        this.sharedRealm = sharedRealm;
        this.nativePtr = nativePointer;
        this.context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Table getTable() {
        return this;
    }

    public boolean isValid() {
        return this.nativePtr != 0L && this.nativeIsValid(this.nativePtr);
    }

    private void verifyColumnName(String name) {
        if (name.length() > 63) {
            throw new IllegalArgumentException("Column names are currently limited to max 63 characters.");
        }
    }

    public long addColumn(RealmFieldType type, String name, boolean isNullable) {
        this.verifyColumnName(name);
        switch (type) {
            case INTEGER: 
            case BOOLEAN: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case FLOAT: 
            case DOUBLE: {
                return this.nativeAddColumn(this.nativePtr, type.getNativeValue(), name, isNullable);
            }
            case INTEGER_LIST: 
            case BOOLEAN_LIST: 
            case STRING_LIST: 
            case BINARY_LIST: 
            case DATE_LIST: 
            case FLOAT_LIST: 
            case DOUBLE_LIST: {
                return this.nativeAddPrimitiveListColumn(this.nativePtr, type.getNativeValue() - 128, name, isNullable);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public long addColumn(RealmFieldType type, String name) {
        return this.addColumn(type, name, false);
    }

    public long addColumnLink(RealmFieldType type, String name, Table table) {
        this.verifyColumnName(name);
        return this.nativeAddColumnLink(this.nativePtr, type.getNativeValue(), name, table.nativePtr);
    }

    public void removeColumn(long columnIndex) {
        String className = this.getClassName();
        String columnName = this.getColumnName(columnIndex);
        String pkName = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName());
        this.nativeRemoveColumn(this.nativePtr, columnIndex);
        if (columnName.equals(pkName)) {
            OsObjectStore.setPrimaryKeyForObject(this.sharedRealm, className, null);
        }
    }

    public void renameColumn(long columnIndex, String newName) {
        this.verifyColumnName(newName);
        String oldName = this.nativeGetColumnName(this.nativePtr, columnIndex);
        String pkName = OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName());
        this.nativeRenameColumn(this.nativePtr, columnIndex, newName);
        if (oldName.equals(pkName)) {
            try {
                OsObjectStore.setPrimaryKeyForObject(this.sharedRealm, this.getClassName(), newName);
            }
            catch (Exception e) {
                this.nativeRenameColumn(this.nativePtr, columnIndex, oldName);
                throw new RuntimeException(e);
            }
        }
    }

    public void insertColumn(long columnIndex, RealmFieldType type, String name) {
        this.verifyColumnName(name);
        Table.nativeInsertColumn(this.nativePtr, columnIndex, type.getNativeValue(), name);
    }

    public boolean isColumnNullable(long columnIndex) {
        return this.nativeIsColumnNullable(this.nativePtr, columnIndex);
    }

    public void convertColumnToNullable(long columnIndex) {
        if (this.sharedRealm.isSyncRealm()) {
            throw new IllegalStateException("This method is only available for non-synchronized Realms");
        }
        this.nativeConvertColumnToNullable(this.nativePtr, columnIndex, this.isPrimaryKey(columnIndex));
    }

    public void convertColumnToNotNullable(long columnIndex) {
        if (this.sharedRealm.isSyncRealm()) {
            throw new IllegalStateException("This method is only available for non-synchronized Realms");
        }
        this.nativeConvertColumnToNotNullable(this.nativePtr, columnIndex, this.isPrimaryKey(columnIndex));
    }

    public long size() {
        return this.nativeSize(this.nativePtr);
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void clear(boolean partialRealm) {
        this.checkImmutable();
        this.nativeClear(this.nativePtr, partialRealm);
    }

    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    public String getColumnName(long columnIndex) {
        return this.nativeGetColumnName(this.nativePtr, columnIndex);
    }

    public long getColumnIndex(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnIndex(this.nativePtr, columnName);
    }

    public RealmFieldType getColumnType(long columnIndex) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnIndex));
    }

    public void moveLastOver(long rowIndex) {
        this.checkImmutable();
        this.nativeMoveLastOver(this.nativePtr, rowIndex);
    }

    private boolean isPrimaryKey(long columnIndex) {
        return this.getColumnName(columnIndex).equals(OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.getClassName()));
    }

    public static void throwDuplicatePrimaryKeyException(Object value) {
        throw new RealmPrimaryKeyConstraintException("Value already exists: " + value);
    }

    public OsSharedRealm getSharedRealm() {
        return this.sharedRealm;
    }

    public long getLong(long columnIndex, long rowIndex) {
        return this.nativeGetLong(this.nativePtr, columnIndex, rowIndex);
    }

    public boolean getBoolean(long columnIndex, long rowIndex) {
        return this.nativeGetBoolean(this.nativePtr, columnIndex, rowIndex);
    }

    public float getFloat(long columnIndex, long rowIndex) {
        return this.nativeGetFloat(this.nativePtr, columnIndex, rowIndex);
    }

    public double getDouble(long columnIndex, long rowIndex) {
        return this.nativeGetDouble(this.nativePtr, columnIndex, rowIndex);
    }

    public Date getDate(long columnIndex, long rowIndex) {
        return new Date(this.nativeGetTimestamp(this.nativePtr, columnIndex, rowIndex));
    }

    public String getString(long columnIndex, long rowIndex) {
        return this.nativeGetString(this.nativePtr, columnIndex, rowIndex);
    }

    public byte[] getBinaryByteArray(long columnIndex, long rowIndex) {
        return this.nativeGetByteArray(this.nativePtr, columnIndex, rowIndex);
    }

    public long getLink(long columnIndex, long rowIndex) {
        return this.nativeGetLink(this.nativePtr, columnIndex, rowIndex);
    }

    public Table getLinkTarget(long columnIndex) {
        long nativeTablePointer = this.nativeGetLinkTarget(this.nativePtr, columnIndex);
        return new Table(this.sharedRealm, nativeTablePointer);
    }

    public boolean isNull(long columnIndex, long rowIndex) {
        return this.nativeIsNull(this.nativePtr, columnIndex, rowIndex);
    }

    public UncheckedRow getUncheckedRow(long index) {
        return UncheckedRow.getByRowIndex(this.context, this, index);
    }

    public UncheckedRow getUncheckedRowByPointer(long nativeRowPointer) {
        return UncheckedRow.getByRowPointer(this.context, this, nativeRowPointer);
    }

    public CheckedRow getCheckedRow(long index) {
        return CheckedRow.get(this.context, this, index);
    }

    public void setLong(long columnIndex, long rowIndex, long value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetLong(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    public void incrementLong(long columnIndex, long rowIndex, long value) {
        this.checkImmutable();
        Table.nativeIncrementLong(this.nativePtr, columnIndex, rowIndex, value);
    }

    public void setBoolean(long columnIndex, long rowIndex, boolean value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetBoolean(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    public void setFloat(long columnIndex, long rowIndex, float value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetFloat(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    public void setDouble(long columnIndex, long rowIndex, double value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetDouble(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    public void setDate(long columnIndex, long rowIndex, Date date, boolean isDefault) {
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        this.checkImmutable();
        Table.nativeSetTimestamp(this.nativePtr, columnIndex, rowIndex, date.getTime(), isDefault);
    }

    public void setString(long columnIndex, long rowIndex, @Nullable String value, boolean isDefault) {
        this.checkImmutable();
        if (value == null) {
            Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, isDefault);
        } else {
            Table.nativeSetString(this.nativePtr, columnIndex, rowIndex, value, isDefault);
        }
    }

    public void setBinaryByteArray(long columnIndex, long rowIndex, byte[] data, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetByteArray(this.nativePtr, columnIndex, rowIndex, data, isDefault);
    }

    public void setLink(long columnIndex, long rowIndex, long value, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetLink(this.nativePtr, columnIndex, rowIndex, value, isDefault);
    }

    public void setNull(long columnIndex, long rowIndex, boolean isDefault) {
        this.checkImmutable();
        Table.nativeSetNull(this.nativePtr, columnIndex, rowIndex, isDefault);
    }

    public void addSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeAddSearchIndex(this.nativePtr, columnIndex);
    }

    public void removeSearchIndex(long columnIndex) {
        this.checkImmutable();
        this.nativeRemoveSearchIndex(this.nativePtr, columnIndex);
    }

    public static void migratePrimaryKeyTableIfNeeded(OsSharedRealm sharedRealm) {
        Table.nativeMigratePrimaryKeyTableIfNeeded(sharedRealm.getNativePtr());
    }

    public boolean hasSearchIndex(long columnIndex) {
        return this.nativeHasSearchIndex(this.nativePtr, columnIndex);
    }

    public boolean isNullLink(long columnIndex, long rowIndex) {
        return this.nativeIsNullLink(this.nativePtr, columnIndex, rowIndex);
    }

    public void nullifyLink(long columnIndex, long rowIndex) {
        Table.nativeNullifyLink(this.nativePtr, columnIndex, rowIndex);
    }

    boolean isImmutable() {
        return this.sharedRealm != null && !this.sharedRealm.isInTransaction();
    }

    void checkImmutable() {
        if (this.isImmutable()) {
            Table.throwImmutable();
        }
    }

    public long count(long columnIndex, long value) {
        return this.nativeCountLong(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, float value) {
        return this.nativeCountFloat(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, double value) {
        return this.nativeCountDouble(this.nativePtr, columnIndex, value);
    }

    public long count(long columnIndex, String value) {
        return this.nativeCountString(this.nativePtr, columnIndex, value);
    }

    public TableQuery where() {
        long nativeQueryPtr = this.nativeWhere(this.nativePtr);
        return new TableQuery(this.context, this, nativeQueryPtr);
    }

    public long findFirstLong(long columnIndex, long value) {
        return Table.nativeFindFirstInt(this.nativePtr, columnIndex, value);
    }

    public long findFirstBoolean(long columnIndex, boolean value) {
        return this.nativeFindFirstBool(this.nativePtr, columnIndex, value);
    }

    public long findFirstFloat(long columnIndex, float value) {
        return this.nativeFindFirstFloat(this.nativePtr, columnIndex, value);
    }

    public long findFirstDouble(long columnIndex, double value) {
        return this.nativeFindFirstDouble(this.nativePtr, columnIndex, value);
    }

    public long findFirstDate(long columnIndex, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return this.nativeFindFirstTimestamp(this.nativePtr, columnIndex, date.getTime());
    }

    public long findFirstString(long columnIndex, String value) {
        if (value == null) {
            throw new IllegalArgumentException("null is not supported");
        }
        return Table.nativeFindFirstString(this.nativePtr, columnIndex, value);
    }

    public long findFirstNull(long columnIndex) {
        return Table.nativeFindFirstNull(this.nativePtr, columnIndex);
    }

    @Nullable
    public String getName() {
        return this.nativeGetName(this.nativePtr);
    }

    @Nullable
    public String getClassName() {
        return Table.getClassNameForTable(this.getName());
    }

    public String toString() {
        long columnCount = this.getColumnCount();
        String name = this.getName();
        StringBuilder stringBuilder = new StringBuilder("The Table ");
        if (name != null && !name.isEmpty()) {
            stringBuilder.append(this.getName());
            stringBuilder.append(" ");
        }
        stringBuilder.append("contains ");
        stringBuilder.append(columnCount);
        stringBuilder.append(" columns: ");
        int i = 0;
        while ((long)i < columnCount) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.getColumnName(i));
            ++i;
        }
        stringBuilder.append(".");
        stringBuilder.append(" And ");
        stringBuilder.append(this.size());
        stringBuilder.append(" rows.");
        return stringBuilder.toString();
    }

    private static void throwImmutable() {
        throw new IllegalStateException("Cannot modify managed objects outside of a write transaction.");
    }

    public boolean hasSameSchema(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        return this.nativeHasSameSchema(this.nativePtr, table.nativePtr);
    }

    @Nullable
    public static String getClassNameForTable(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith(TABLE_PREFIX)) {
            return name;
        }
        return name.substring(TABLE_PREFIX.length());
    }

    public static String getTableNameForClass(String name) {
        if (name == null) {
            return null;
        }
        return TABLE_PREFIX + name;
    }

    private native boolean nativeIsValid(long var1);

    private native long nativeAddColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddPrimitiveListColumn(long var1, int var3, String var4, boolean var5);

    private native long nativeAddColumnLink(long var1, int var3, String var4, long var5);

    private native void nativeRenameColumn(long var1, long var3, String var5);

    private native void nativeRemoveColumn(long var1, long var3);

    private static native void nativeInsertColumn(long var0, long var2, int var4, String var5);

    private native boolean nativeIsColumnNullable(long var1, long var3);

    private native void nativeConvertColumnToNullable(long var1, long var3, boolean var5);

    private native void nativeConvertColumnToNotNullable(long var1, long var3, boolean var5);

    private native long nativeSize(long var1);

    private native void nativeClear(long var1, boolean var3);

    private native long nativeGetColumnCount(long var1);

    private native String nativeGetColumnName(long var1, long var3);

    private native long nativeGetColumnIndex(long var1, String var3);

    private native int nativeGetColumnType(long var1, long var3);

    private native void nativeMoveLastOver(long var1, long var3);

    private native long nativeGetLong(long var1, long var3, long var5);

    private native boolean nativeGetBoolean(long var1, long var3, long var5);

    private native float nativeGetFloat(long var1, long var3, long var5);

    private native double nativeGetDouble(long var1, long var3, long var5);

    private native long nativeGetTimestamp(long var1, long var3, long var5);

    private native String nativeGetString(long var1, long var3, long var5);

    private native byte[] nativeGetByteArray(long var1, long var3, long var5);

    private native long nativeGetLink(long var1, long var3, long var5);

    private native long nativeGetLinkTarget(long var1, long var3);

    private native boolean nativeIsNull(long var1, long var3, long var5);

    native long nativeGetRowPtr(long var1, long var3);

    public static native void nativeSetLong(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeIncrementLong(long var0, long var2, long var4, long var6);

    public static native void nativeSetBoolean(long var0, long var2, long var4, boolean var6, boolean var7);

    public static native void nativeSetFloat(long var0, long var2, long var4, float var6, boolean var7);

    public static native void nativeSetDouble(long var0, long var2, long var4, double var6, boolean var8);

    public static native void nativeSetTimestamp(long var0, long var2, long var4, long var6, boolean var8);

    public static native void nativeSetString(long var0, long var2, long var4, String var6, boolean var7);

    public static native void nativeSetNull(long var0, long var2, long var4, boolean var6);

    public static native void nativeSetByteArray(long var0, long var2, long var4, byte[] var6, boolean var7);

    public static native void nativeSetLink(long var0, long var2, long var4, long var6, boolean var8);

    private static native void nativeMigratePrimaryKeyTableIfNeeded(long var0);

    private native void nativeAddSearchIndex(long var1, long var3);

    private native void nativeRemoveSearchIndex(long var1, long var3);

    private native boolean nativeHasSearchIndex(long var1, long var3);

    private native boolean nativeIsNullLink(long var1, long var3, long var5);

    public static native void nativeNullifyLink(long var0, long var2, long var4);

    private native long nativeCountLong(long var1, long var3, long var5);

    private native long nativeCountFloat(long var1, long var3, float var5);

    private native long nativeCountDouble(long var1, long var3, double var5);

    private native long nativeCountString(long var1, long var3, String var5);

    private native long nativeWhere(long var1);

    public static native long nativeFindFirstInt(long var0, long var2, long var4);

    private native long nativeFindFirstBool(long var1, long var3, boolean var5);

    private native long nativeFindFirstFloat(long var1, long var3, float var5);

    private native long nativeFindFirstDouble(long var1, long var3, double var5);

    private native long nativeFindFirstTimestamp(long var1, long var3, long var5);

    public static native long nativeFindFirstString(long var0, long var2, String var4);

    public static native long nativeFindFirstNull(long var0, long var2);

    private native String nativeGetName(long var1);

    private native boolean nativeHasSameSchema(long var1, long var3);

    private static native long nativeGetFinalizerPtr();
}

