/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.sync;

import io.realm.RealmChangeListener;
import io.realm.internal.KeepMember;
import io.realm.internal.NativeObject;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsResults;
import io.realm.internal.sync.SubscriptionAction;
import javax.annotation.Nullable;

@KeepMember
public class OsSubscription
implements NativeObject {
    private static final long nativeFinalizerPtr = OsSubscription.nativeGetFinalizerPtr();
    private final long nativePtr;
    protected final ObserverPairList<SubscriptionObserverPair> observerPairs = new ObserverPairList();

    public OsSubscription(OsResults results, SubscriptionAction subscriptionInfo) {
        this.nativePtr = OsSubscription.nativeCreateOrUpdate(results.getNativePtr(), subscriptionInfo.getName(), subscriptionInfo.getTimeToLiveMs(), subscriptionInfo.isUpdate());
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public SubscriptionState getState() {
        return SubscriptionState.fromInternalValue(OsSubscription.nativeGetState(this.nativePtr));
    }

    @Nullable
    public Throwable getError() {
        return (Throwable)OsSubscription.nativeGetError(this.nativePtr);
    }

    public void addChangeListener(RealmChangeListener<OsSubscription> listener) {
        if (this.observerPairs.isEmpty()) {
            this.nativeStartListening(this.nativePtr);
        }
        this.observerPairs.add(new SubscriptionObserverPair(this, listener));
    }

    public void removeChangeListener(RealmChangeListener<OsSubscription> listener) {
        this.observerPairs.remove(this, listener);
        if (this.observerPairs.isEmpty()) {
            this.nativeStopListening(this.nativePtr);
        }
    }

    @KeepMember
    private void notifyChangeListeners() {
        this.observerPairs.foreach(new Callback());
    }

    private static native long nativeCreateOrUpdate(long var0, String var2, long var3, boolean var5);

    private static native long nativeGetFinalizerPtr();

    private static native int nativeGetState(long var0);

    private static native Object nativeGetError(long var0);

    private native void nativeStartListening(long var1);

    private native void nativeStopListening(long var1);

    private static class Callback
    implements ObserverPairList.Callback<SubscriptionObserverPair> {
        private Callback() {
        }

        @Override
        public void onCalled(SubscriptionObserverPair pair, Object observer) {
            pair.onChange((OsSubscription)observer);
        }
    }

    private static class SubscriptionObserverPair
    extends ObserverPairList.ObserverPair<OsSubscription, RealmChangeListener<OsSubscription>> {
        public SubscriptionObserverPair(OsSubscription observer, RealmChangeListener<OsSubscription> listener) {
            super(observer, listener);
        }

        public void onChange(OsSubscription observer) {
            ((RealmChangeListener)this.listener).onChange(observer);
        }
    }

    public static enum SubscriptionState {
        ERROR(-1),
        CREATING(2),
        PENDING(0),
        COMPLETE(1),
        INVALIDATED(3);

        private final int val;

        private SubscriptionState(int val) {
            this.val = val;
        }

        public static SubscriptionState fromInternalValue(int val) {
            for (SubscriptionState subscriptionState : SubscriptionState.values()) {
                if (subscriptionState.val != val) continue;
                return subscriptionState;
            }
            throw new IllegalArgumentException("Unknown value: " + val);
        }
    }
}

