/*
 * Decompiled with CFR 0.152.
 */
package io.realm.rx;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Single;
import io.reactivex.disposables.Disposables;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.ObjectChangeSet;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectChangeListener;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.rx.CollectionChange;
import io.realm.rx.ObjectChange;
import io.realm.rx.RxObservableFactory;
import java.util.IdentityHashMap;
import java.util.Map;

public class RealmObservableFactory
implements RxObservableFactory {
    private ThreadLocal<StrongReferenceCounter<RealmResults>> resultsRefs = new ThreadLocal<StrongReferenceCounter<RealmResults>>(){

        @Override
        protected StrongReferenceCounter<RealmResults> initialValue() {
            return new StrongReferenceCounter<RealmResults>();
        }
    };
    private ThreadLocal<StrongReferenceCounter<RealmList>> listRefs = new ThreadLocal<StrongReferenceCounter<RealmList>>(){

        @Override
        protected StrongReferenceCounter<RealmList> initialValue() {
            return new StrongReferenceCounter<RealmList>();
        }
    };
    private ThreadLocal<StrongReferenceCounter<RealmModel>> objectRefs = new ThreadLocal<StrongReferenceCounter<RealmModel>>(){

        @Override
        protected StrongReferenceCounter<RealmModel> initialValue() {
            return new StrongReferenceCounter<RealmModel>();
        }
    };
    private static final BackpressureStrategy BACK_PRESSURE_STRATEGY = BackpressureStrategy.LATEST;

    @Override
    public Flowable<Realm> from(Realm realm) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Realm>(){

            public void subscribe(final FlowableEmitter<Realm> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                final RealmChangeListener<Realm> listener = new RealmChangeListener<Realm>(){

                    @Override
                    public void onChange(Realm realm) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)realm);
                        }
                    }
                };
                observableRealm.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        observableRealm.removeChangeListener(listener);
                        observableRealm.close();
                    }
                }));
                emitter.onNext((Object)observableRealm);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public Flowable<DynamicRealm> from(DynamicRealm realm) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<DynamicRealm>(){

            public void subscribe(final FlowableEmitter<DynamicRealm> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                final RealmChangeListener<DynamicRealm> listener = new RealmChangeListener<DynamicRealm>(){

                    @Override
                    public void onChange(DynamicRealm realm) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)realm);
                        }
                    }
                };
                observableRealm.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        observableRealm.removeChangeListener(listener);
                        observableRealm.close();
                    }
                }));
                emitter.onNext((Object)observableRealm);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E> Flowable<RealmResults<E>> from(Realm realm, final RealmResults<E> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmResults<E>>(){

            public void subscribe(final FlowableEmitter<RealmResults<E>> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final RealmChangeListener listener = new RealmChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(results);
                        }
                    }
                };
                results.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext((Object)results);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E> Observable<CollectionChange<RealmResults<E>>> changesetsFrom(Realm realm, final RealmResults<E> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmResults<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmResults<E>>> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final OrderedRealmCollectionChangeListener listener = new OrderedRealmCollectionChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> e, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange<RealmResults>(results, changeSet));
                        }
                    }
                };
                results.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmResults>(results, null));
            }
        });
    }

    @Override
    public <E> Flowable<RealmResults<E>> from(DynamicRealm realm, final RealmResults<E> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmResults<E>>(){

            public void subscribe(final FlowableEmitter<RealmResults<E>> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final RealmChangeListener listener = new RealmChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(results);
                        }
                    }
                };
                results.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext((Object)results);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E> Observable<CollectionChange<RealmResults<E>>> changesetsFrom(DynamicRealm realm, final RealmResults<E> results) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmResults<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmResults<E>>> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final OrderedRealmCollectionChangeListener listener = new OrderedRealmCollectionChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(results, changeSet));
                        }
                    }
                };
                results.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        results.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmResults>(results, null));
            }
        });
    }

    @Override
    public <E> Flowable<RealmList<E>> from(Realm realm, final RealmList<E> list) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmList<E>>(){

            public void subscribe(final FlowableEmitter<RealmList<E>> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final RealmChangeListener listener = new RealmChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)list);
                        }
                    }
                };
                list.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        list.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext((Object)list);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E> Observable<CollectionChange<RealmList<E>>> changesetsFrom(Realm realm, final RealmList<E> list) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmList<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmList<E>>> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final OrderedRealmCollectionChangeListener listener = new OrderedRealmCollectionChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> results, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(results, changeSet));
                        }
                    }
                };
                list.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        list.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmList>(list, null));
            }
        });
    }

    @Override
    public <E> Flowable<RealmList<E>> from(DynamicRealm realm, final RealmList<E> list) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmList<E>>(){

            public void subscribe(final FlowableEmitter<RealmList<E>> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final RealmChangeListener listener = new RealmChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)list);
                        }
                    }
                };
                list.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        list.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext((Object)list);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E> Observable<CollectionChange<RealmList<E>>> changesetsFrom(DynamicRealm realm, final RealmList<E> list) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmList<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmList<E>>> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final OrderedRealmCollectionChangeListener listener = new OrderedRealmCollectionChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> results, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(results, changeSet));
                        }
                    }
                };
                list.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        list.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmList>(list, null));
            }
        });
    }

    @Override
    public <E extends RealmModel> Flowable<E> from(Realm realm, final E object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<E>(){

            public void subscribe(final FlowableEmitter<E> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmChangeListener listener = new RealmChangeListener<E>(){

                    @Override
                    public void onChange(E obj) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(obj);
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RealmObject.removeChangeListener(object, listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext((Object)object);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public <E extends RealmModel> Observable<ObjectChange<E>> changesetsFrom(Realm realm, final E object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ObjectChange<E>>(){

            public void subscribe(final ObservableEmitter<ObjectChange<E>> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmObjectChangeListener listener = new RealmObjectChangeListener<E>(){

                    @Override
                    public void onChange(E obj, ObjectChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new ObjectChange(obj, changeSet));
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RealmObject.removeChangeListener(object, listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext(new ObjectChange<RealmModel>(object, null));
            }
        });
    }

    @Override
    public Flowable<DynamicRealmObject> from(DynamicRealm realm, final DynamicRealmObject object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<DynamicRealmObject>(){

            public void subscribe(final FlowableEmitter<DynamicRealmObject> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmChangeListener<DynamicRealmObject> listener = new RealmChangeListener<DynamicRealmObject>(){

                    @Override
                    public void onChange(DynamicRealmObject obj) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)obj);
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RealmObject.removeChangeListener(object, listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext((Object)object);
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY);
    }

    @Override
    public Observable<ObjectChange<DynamicRealmObject>> changesetsFrom(DynamicRealm realm, final DynamicRealmObject object) {
        final RealmConfiguration realmConfig = realm.getConfiguration();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ObjectChange<DynamicRealmObject>>(){

            public void subscribe(final ObservableEmitter<ObjectChange<DynamicRealmObject>> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmObjectChangeListener<DynamicRealmObject> listener = new RealmObjectChangeListener<DynamicRealmObject>(){

                    @Override
                    public void onChange(DynamicRealmObject obj, ObjectChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new ObjectChange<DynamicRealmObject>(obj, changeSet));
                        }
                    }
                };
                object.addChangeListener(listener);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        object.removeChangeListener(listener);
                        observableRealm.close();
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext(new ObjectChange<DynamicRealmObject>(object, null));
            }
        });
    }

    @Override
    public <E> Single<RealmQuery<E>> from(Realm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    @Override
    public <E> Single<RealmQuery<E>> from(DynamicRealm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    public boolean equals(Object o) {
        return o instanceof RealmObservableFactory;
    }

    public int hashCode() {
        return 37;
    }

    private static class StrongReferenceCounter<K> {
        private final Map<K, Integer> references = new IdentityHashMap<K, Integer>();

        private StrongReferenceCounter() {
        }

        public void acquireReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                this.references.put(object, 1);
            } else {
                this.references.put(object, count + 1);
            }
        }

        public void releaseReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                throw new IllegalStateException("Object does not have any references: " + object);
            }
            if (count > 1) {
                this.references.put(object, count - 1);
            } else if (count == 1) {
                this.references.remove(object);
            } else {
                throw new IllegalStateException("Invalid reference count: " + count);
            }
        }
    }
}

