/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.LinkingObjects;
import io.realm.annotations.Required;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import java.util.Locale;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

final class Backlink {
    private final VariableElement backlink;
    private final String targetClass;
    private final String targetField;
    private final String sourceClass;
    private final String sourceField;

    public Backlink(ClassMetaData clazz, VariableElement backlink) {
        if (null == clazz || null == backlink) {
            throw new NullPointerException(String.format(Locale.US, "null parameter: %s, %s", clazz, backlink));
        }
        this.backlink = backlink;
        this.targetClass = clazz.getFullyQualifiedClassName();
        this.targetField = backlink.getSimpleName().toString();
        this.sourceClass = Utils.getRealmResultsType(backlink);
        this.sourceField = backlink.getAnnotation(LinkingObjects.class).value();
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getTargetFieldType() {
        return this.backlink.asType().toString();
    }

    public String getSimpleSourceClass() {
        return Utils.getFieldTypeSimpleName(Utils.getGenericTypeForContainer(this.backlink));
    }

    public boolean validateSource() {
        if (this.backlink.getAnnotation(Required.class) != null) {
            Utils.error(String.format(Locale.US, "The @LinkingObjects field \"%s.%s\" cannot be @Required.", this.targetClass, this.targetField));
            return false;
        }
        if (this.sourceField == null || this.sourceField.equals("")) {
            Utils.error(String.format(Locale.US, "The @LinkingObjects annotation for the field \"%s.%s\" must have a parameter identifying the link target.", this.targetClass, this.targetField));
            return false;
        }
        if (this.sourceField.contains(".")) {
            Utils.error(String.format(Locale.US, "The parameter to the @LinkingObjects annotation for the field \"%s.%s\" contains a '.'.  The use of '.' to specify fields in referenced classes is not supported.", this.targetClass, this.targetField));
            return false;
        }
        if (!Utils.isRealmResults(this.backlink)) {
            Utils.error(String.format(Locale.US, "The field \"%s.%s\" is a \"%s\". Fields annotated with @LinkingObjects must be RealmResults.", this.targetClass, this.targetField, this.backlink.asType()));
            return false;
        }
        if (this.sourceClass == null) {
            Utils.error(String.format(Locale.US, "\"The field \"%s.%s\", annotated with @LinkingObjects, must specify a generic type.", this.targetClass, this.targetField));
            return false;
        }
        if (!this.backlink.getModifiers().contains((Object)Modifier.FINAL)) {
            Utils.error(String.format(Locale.US, "A @LinkingObjects field \"%s.%s\" must be final.", this.targetClass, this.targetField));
            return false;
        }
        return true;
    }

    public boolean validateTarget(ClassMetaData clazz) {
        VariableElement field = clazz.getDeclaredField(this.sourceField);
        if (field == null) {
            Utils.error(String.format(Locale.US, "Field \"%s\", the target of the @LinkedObjects annotation on field \"%s.%s\", does not exist in class \"%s\".", this.sourceField, this.targetClass, this.targetField, this.sourceClass));
            return false;
        }
        String fieldType = field.asType().toString();
        if (!this.targetClass.equals(fieldType) && !this.targetClass.equals(Utils.getRealmListType(field))) {
            Utils.error(String.format(Locale.US, "Field \"%s.%s\", the target of the @LinkedObjects annotation on field \"%s.%s\", has type \"%s\" instead of \"%3$s\".", this.sourceClass, this.sourceField, this.targetClass, this.targetField, fieldType));
            return false;
        }
        return true;
    }

    public String toString() {
        return "Backlink{" + this.sourceClass + "." + this.sourceField + " ==> " + this.targetClass + "." + this.targetField + "}";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Backlink)) {
            return false;
        }
        Backlink backlink = (Backlink)o;
        return this.targetClass.equals(backlink.targetClass) && this.targetField.equals(backlink.targetField) && this.sourceClass.equals(backlink.sourceClass) && this.sourceField.equals(backlink.sourceField);
    }

    public int hashCode() {
        int result = this.targetClass.hashCode();
        result = 31 * result + this.targetField.hashCode();
        result = 31 * result + this.sourceClass.hashCode();
        result = 31 * result + this.sourceField.hashCode();
        return result;
    }
}

