/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.Ignore;
import io.realm.annotations.Index;
import io.realm.annotations.LinkingObjects;
import io.realm.annotations.PrimaryKey;
import io.realm.annotations.Required;
import io.realm.processor.Backlink;
import io.realm.processor.Constants;
import io.realm.processor.TypeMirrors;
import io.realm.processor.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ClassMetaData {
    private static final String OPTION_IGNORE_KOTLIN_NULLABILITY = "realm.ignoreKotlinNullability";
    private final TypeElement classType;
    private final String className;
    private final List<VariableElement> fields = new ArrayList<VariableElement>();
    private final List<VariableElement> indexedFields = new ArrayList<VariableElement>();
    private final Set<Backlink> backlinks = new HashSet<Backlink>();
    private final Set<VariableElement> nullableFields = new HashSet<VariableElement>();
    private final Set<VariableElement> nullableValueListFields = new HashSet<VariableElement>();
    private String packageName;
    private boolean hasDefaultConstructor;
    private VariableElement primaryKey;
    private boolean containsToString;
    private boolean containsEquals;
    private boolean containsHashCode;
    private final List<TypeMirror> validPrimaryKeyTypes;
    private final List<TypeMirror> validListValueTypes;
    private final Types typeUtils;
    private final Elements elements;
    private final boolean ignoreKotlinNullability;

    public ClassMetaData(ProcessingEnvironment env, TypeMirrors typeMirrors, TypeElement clazz) {
        this.classType = clazz;
        this.className = clazz.getSimpleName().toString();
        this.typeUtils = env.getTypeUtils();
        this.elements = env.getElementUtils();
        this.validPrimaryKeyTypes = Arrays.asList(typeMirrors.STRING_MIRROR, typeMirrors.PRIMITIVE_LONG_MIRROR, typeMirrors.PRIMITIVE_INT_MIRROR, typeMirrors.PRIMITIVE_SHORT_MIRROR, typeMirrors.PRIMITIVE_BYTE_MIRROR);
        this.validListValueTypes = Arrays.asList(typeMirrors.STRING_MIRROR, typeMirrors.BINARY_MIRROR, typeMirrors.BOOLEAN_MIRROR, typeMirrors.LONG_MIRROR, typeMirrors.INTEGER_MIRROR, typeMirrors.SHORT_MIRROR, typeMirrors.BYTE_MIRROR, typeMirrors.DOUBLE_MIRROR, typeMirrors.FLOAT_MIRROR, typeMirrors.DATE_MIRROR);
        for (Element element : this.classType.getEnclosedElements()) {
            if (!(element instanceof ExecutableElement)) continue;
            Name name = element.getSimpleName();
            if (name.contentEquals("toString")) {
                this.containsToString = true;
                continue;
            }
            if (name.contentEquals("equals")) {
                this.containsEquals = true;
                continue;
            }
            if (!name.contentEquals("hashCode")) continue;
            this.containsHashCode = true;
        }
        this.ignoreKotlinNullability = Boolean.valueOf(env.getOptions().getOrDefault(OPTION_IGNORE_KOTLIN_NULLABILITY, "false"));
    }

    public String toString() {
        return "class " + this.getFullyQualifiedClassName();
    }

    public String getSimpleClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        return this.packageName + "." + this.className;
    }

    public List<VariableElement> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Set<Backlink> getBacklinkFields() {
        return Collections.unmodifiableSet(this.backlinks);
    }

    public String getInternalGetter(String fieldName) {
        return "realmGet$" + fieldName;
    }

    public String getInternalSetter(String fieldName) {
        return "realmSet$" + fieldName;
    }

    public List<VariableElement> getIndexedFields() {
        return Collections.unmodifiableList(this.indexedFields);
    }

    public boolean hasPrimaryKey() {
        return this.primaryKey != null;
    }

    public VariableElement getPrimaryKey() {
        return this.primaryKey;
    }

    public String getPrimaryKeyGetter() {
        return this.getInternalGetter(this.primaryKey.getSimpleName().toString());
    }

    public boolean containsToString() {
        return this.containsToString;
    }

    public boolean containsEquals() {
        return this.containsEquals;
    }

    public boolean containsHashCode() {
        return this.containsHashCode;
    }

    public boolean isNullable(VariableElement variableElement) {
        return this.nullableFields.contains(variableElement);
    }

    public boolean isElementNullable(VariableElement realmListVariableElement) {
        return this.nullableValueListFields.contains(realmListVariableElement);
    }

    public boolean isIndexed(VariableElement variableElement) {
        return this.indexedFields.contains(variableElement);
    }

    public boolean isPrimaryKey(VariableElement variableElement) {
        return this.primaryKey != null && this.primaryKey.equals(variableElement);
    }

    public boolean isModelClass() {
        String type = this.classType.toString();
        return !type.equals("io.realm.DynamicRealmObject") && !type.endsWith(".RealmObject") && !type.endsWith("RealmProxy");
    }

    public VariableElement getDeclaredField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (VariableElement field : this.fields) {
            if (!field.getSimpleName().toString().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public boolean generate() {
        Element enclosingElement = this.classType.getEnclosingElement();
        if (!enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
            Utils.error("The RealmClass annotation does not support nested classes.", this.classType);
            return false;
        }
        TypeElement parentElement = (TypeElement)Utils.getSuperClass(this.classType);
        if (!parentElement.toString().equals("java.lang.Object") && !parentElement.toString().equals("io.realm.RealmObject")) {
            Utils.error("Valid model classes must either extend RealmObject or implement RealmModel.", this.classType);
            return false;
        }
        PackageElement packageElement = (PackageElement)enclosingElement;
        this.packageName = packageElement.getQualifiedName().toString();
        if (!this.categorizeClassElements()) {
            return false;
        }
        if (!this.checkCollectionTypes()) {
            return false;
        }
        if (!this.checkReferenceTypes()) {
            return false;
        }
        if (!this.checkDefaultConstructor()) {
            return false;
        }
        if (!this.checkForFinalFields()) {
            return false;
        }
        return this.checkForVolatileFields();
    }

    private boolean categorizeClassElements() {
        for (Element element : this.classType.getEnclosedElements()) {
            ElementKind elementKind = element.getKind();
            switch (elementKind) {
                case CONSTRUCTOR: {
                    if (!Utils.isDefaultConstructor(element)) break;
                    this.hasDefaultConstructor = true;
                    break;
                }
                case FIELD: {
                    if (this.categorizeField(element)) break;
                    return false;
                }
            }
        }
        if (this.fields.size() == 0) {
            Utils.error(String.format(Locale.US, "Class \"%s\" must contain at least 1 persistable field.", this.className));
        }
        return true;
    }

    private boolean checkCollectionTypes() {
        for (VariableElement field : this.fields) {
            if (!(Utils.isRealmList(field) ? !this.checkRealmListType(field) : Utils.isRealmResults(field) && !this.checkRealmResultsType(field))) continue;
            return false;
        }
        return true;
    }

    private boolean checkRealmListType(VariableElement field) {
        TypeElement elementTypeElement;
        if (Utils.getGenericTypeQualifiedName(field) == null) {
            Utils.error("No generic type supplied for field", field);
            return false;
        }
        TypeMirror fieldType = field.asType();
        TypeMirror elementTypeMirror = ((DeclaredType)fieldType).getTypeArguments().get(0);
        if (elementTypeMirror.getKind() == TypeKind.DECLARED && (elementTypeElement = (TypeElement)((DeclaredType)elementTypeMirror).asElement()).getSuperclass().getKind() == TypeKind.NONE) {
            Utils.error("Only concrete Realm classes are allowed in RealmLists. Neither interfaces nor abstract classes are allowed.", field);
            return false;
        }
        if (!this.validListValueTypes.contains(elementTypeMirror) && !Utils.isRealmModel(elementTypeMirror)) {
            StringBuilder messageBuilder = new StringBuilder("Element type of RealmList must be a class implementing 'RealmModel' or one of the ");
            String separator = ", ";
            for (TypeMirror type : this.validListValueTypes) {
                messageBuilder.append('\'').append(type.toString()).append('\'').append(", ");
            }
            messageBuilder.setLength(messageBuilder.length() - ", ".length());
            messageBuilder.append('.');
            Utils.error(messageBuilder.toString(), field);
            return false;
        }
        return true;
    }

    private boolean checkRealmResultsType(VariableElement field) {
        TypeElement elementTypeElement;
        if (Utils.getGenericTypeQualifiedName(field) == null) {
            Utils.error("No generic type supplied for field", field);
            return false;
        }
        TypeMirror fieldType = field.asType();
        TypeMirror elementTypeMirror = ((DeclaredType)fieldType).getTypeArguments().get(0);
        if (elementTypeMirror.getKind() == TypeKind.DECLARED && (elementTypeElement = (TypeElement)((DeclaredType)elementTypeMirror).asElement()).getSuperclass().getKind() == TypeKind.NONE) {
            Utils.error("Only concrete Realm classes are allowed in RealmResults. Neither interfaces nor abstract classes are allowed.", field);
            return false;
        }
        if (!Utils.isRealmModel(elementTypeMirror)) {
            Utils.error("Element type of RealmResults must be a class implementing 'RealmModel'.", field);
            return false;
        }
        return true;
    }

    private boolean checkReferenceTypes() {
        for (VariableElement field : this.fields) {
            TypeElement typeElement;
            if (!Utils.isRealmModel(field) || (typeElement = this.elements.getTypeElement(field.asType().toString())).getSuperclass().getKind() != TypeKind.NONE) continue;
            Utils.error("Only concrete Realm classes can be referenced from model classes. Neither interfaces nor abstract classes are allowed.", field);
            return false;
        }
        return true;
    }

    private boolean checkDefaultConstructor() {
        if (!this.hasDefaultConstructor) {
            Utils.error(String.format(Locale.US, "Class \"%s\" must declare a public constructor with no arguments if it contains custom constructors.", this.className));
            return false;
        }
        return true;
    }

    private boolean checkForFinalFields() {
        for (VariableElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.FINAL) || Utils.isMutableRealmInteger(field)) continue;
            Utils.error(String.format(Locale.US, "Class \"%s\" contains illegal final field \"%s\".", this.className, field.getSimpleName().toString()));
            return false;
        }
        return true;
    }

    private boolean checkForVolatileFields() {
        for (VariableElement field : this.fields) {
            if (!field.getModifiers().contains((Object)Modifier.VOLATILE)) continue;
            Utils.error(String.format(Locale.US, "Class \"%s\" contains illegal volatile field \"%s\".", this.className, field.getSimpleName().toString()));
            return false;
        }
        return true;
    }

    private boolean categorizeField(Element element) {
        VariableElement field = (VariableElement)element;
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            return true;
        }
        if (field.getAnnotation(Ignore.class) != null || field.getModifiers().contains((Object)Modifier.TRANSIENT)) {
            return true;
        }
        if (field.getAnnotation(Index.class) != null && !this.categorizeIndexField(element, field)) {
            return false;
        }
        if (Utils.isRealmList(field)) {
            List<? extends TypeMirror> fieldTypeArguments;
            if (!(this.hasRequiredAnnotation(field) || !(fieldTypeArguments = ((DeclaredType)field.asType()).getTypeArguments()).isEmpty() && Utils.isRealmModel(fieldTypeArguments.get(0)))) {
                this.nullableValueListFields.add(field);
            }
        } else if (this.isRequiredField(field)) {
            this.categorizeRequiredField(element, field);
        } else if (!Utils.isPrimitiveType(field) && !Utils.isRealmResults(field)) {
            this.nullableFields.add(field);
        }
        if (field.getAnnotation(PrimaryKey.class) != null && !this.categorizePrimaryKeyField(field)) {
            return false;
        }
        if (field.getAnnotation(LinkingObjects.class) != null) {
            return this.categorizeBacklinkField(field);
        }
        if (Utils.isMutableRealmInteger(field) && !this.categorizeMutableRealmIntegerField(field)) {
            return false;
        }
        this.fields.add(field);
        return true;
    }

    private boolean hasRequiredAnnotation(VariableElement field) {
        return field.getAnnotation(Required.class) != null;
    }

    private boolean isRequiredField(VariableElement field) {
        if (this.hasRequiredAnnotation(field)) {
            return true;
        }
        if (this.ignoreKotlinNullability) {
            return false;
        }
        for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals("org.jetbrains.annotations.NotNull")) continue;
            return true;
        }
        return false;
    }

    private boolean categorizeIndexField(Element element, VariableElement variableElement) {
        boolean indexable = false;
        if (Utils.isMutableRealmInteger(variableElement)) {
            indexable = true;
        } else {
            Constants.RealmFieldType realmType = Constants.JAVA_TO_REALM_TYPES.get(variableElement.asType().toString());
            if (realmType != null) {
                switch (realmType) {
                    case STRING: 
                    case DATE: 
                    case INTEGER: 
                    case BOOLEAN: {
                        indexable = true;
                    }
                }
            }
        }
        if (indexable) {
            this.indexedFields.add(variableElement);
            return true;
        }
        Utils.error(String.format(Locale.US, "Field \"%s\" of type \"%s\" cannot be an @Index.", element, element.asType()));
        return false;
    }

    private void categorizeRequiredField(Element element, VariableElement variableElement) {
        if (Utils.isPrimitiveType(variableElement)) {
            Utils.error(String.format(Locale.US, "@Required or @NotNull annotation is unnecessary for primitive field \"%s\".", element));
            return;
        }
        if (Utils.isRealmModel(variableElement)) {
            Utils.error(String.format(Locale.US, "Field \"%s\" with type \"%s\" cannot be @Required or @NotNull.", element, element.asType()));
            return;
        }
        if (this.nullableFields.contains(variableElement)) {
            Utils.error(String.format(Locale.US, "Field \"%s\" with type \"%s\" appears to be nullable. Consider removing @Required.", element, element.asType()));
        }
    }

    private boolean categorizePrimaryKeyField(VariableElement variableElement) {
        if (this.primaryKey != null) {
            Utils.error(String.format(Locale.US, "A class cannot have more than one @PrimaryKey. Both \"%s\" and \"%s\" are annotated as @PrimaryKey.", this.primaryKey.getSimpleName().toString(), variableElement.getSimpleName().toString()));
            return false;
        }
        TypeMirror fieldType = variableElement.asType();
        if (!this.isValidPrimaryKeyType(fieldType)) {
            Utils.error(String.format(Locale.US, "Field \"%s\" with type \"%s\" cannot be used as primary key. See @PrimaryKey for legal types.", variableElement.getSimpleName().toString(), fieldType));
            return false;
        }
        this.primaryKey = variableElement;
        if (!this.indexedFields.contains(variableElement)) {
            this.indexedFields.add(variableElement);
        }
        return true;
    }

    private boolean categorizeBacklinkField(VariableElement variableElement) {
        Backlink backlink = new Backlink(this, variableElement);
        if (!backlink.validateSource()) {
            return false;
        }
        this.backlinks.add(backlink);
        return true;
    }

    private boolean categorizeMutableRealmIntegerField(VariableElement field) {
        if (field.getModifiers().contains((Object)Modifier.FINAL)) {
            return true;
        }
        Utils.error(String.format(Locale.US, "Field \"%s\", a MutableRealmInteger, must be final.", field.getSimpleName().toString()));
        return false;
    }

    private boolean isValidPrimaryKeyType(TypeMirror type) {
        for (TypeMirror validType : this.validPrimaryKeyTypes) {
            if (!this.typeUtils.isAssignable(type, validType)) continue;
            return true;
        }
        return false;
    }
}

