/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Constants {
    public static final String REALM_PACKAGE_NAME = "io.realm";
    public static final String PROXY_SUFFIX = "RealmProxy";
    public static final String INTERFACE_SUFFIX = "RealmProxyInterface";
    public static final String INDENT = "    ";
    public static final String DEFAULT_MODULE_CLASS_NAME = "DefaultRealmModule";
    static final String STATEMENT_EXCEPTION_ILLEGAL_NULL_VALUE = "throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")";
    static final String STATEMENT_EXCEPTION_NO_PRIMARY_KEY_IN_JSON = "throw new IllegalArgumentException(\"JSON object doesn't have the primary key field '%s'.\")";
    static final String STATEMENT_EXCEPTION_PRIMARY_KEY_CANNOT_BE_CHANGED = "throw new io.realm.exceptions.RealmException(\"Primary key field '%s' cannot be changed after object was created.\")";
    static final String STATEMENT_EXCEPTION_ILLEGAL_JSON_LOAD = "throw new io.realm.exceptions.RealmException(\"\\\"%s\\\" field \\\"%s\\\" cannot be loaded from json\")";
    static final Map<String, RealmFieldType> JAVA_TO_REALM_TYPES;
    static final Map<String, RealmFieldType> LIST_ELEMENT_TYPE_TO_REALM_TYPES;

    static {
        HashMap<String, RealmFieldType> m = new HashMap<String, RealmFieldType>();
        m.put("byte", RealmFieldType.INTEGER);
        m.put("short", RealmFieldType.INTEGER);
        m.put("int", RealmFieldType.INTEGER);
        m.put("long", RealmFieldType.INTEGER);
        m.put("float", RealmFieldType.FLOAT);
        m.put("double", RealmFieldType.DOUBLE);
        m.put("boolean", RealmFieldType.BOOLEAN);
        m.put("java.lang.Byte", RealmFieldType.INTEGER);
        m.put("java.lang.Short", RealmFieldType.INTEGER);
        m.put("java.lang.Integer", RealmFieldType.INTEGER);
        m.put("java.lang.Long", RealmFieldType.INTEGER);
        m.put("java.lang.Float", RealmFieldType.FLOAT);
        m.put("java.lang.Double", RealmFieldType.DOUBLE);
        m.put("java.lang.Boolean", RealmFieldType.BOOLEAN);
        m.put("java.lang.String", RealmFieldType.STRING);
        m.put("java.util.Date", RealmFieldType.DATE);
        m.put("byte[]", RealmFieldType.BINARY);
        JAVA_TO_REALM_TYPES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("java.lang.Byte", RealmFieldType.INTEGER_LIST);
        m.put("java.lang.Short", RealmFieldType.INTEGER_LIST);
        m.put("java.lang.Integer", RealmFieldType.INTEGER_LIST);
        m.put("java.lang.Long", RealmFieldType.INTEGER_LIST);
        m.put("java.lang.Float", RealmFieldType.FLOAT_LIST);
        m.put("java.lang.Double", RealmFieldType.DOUBLE_LIST);
        m.put("java.lang.Boolean", RealmFieldType.BOOLEAN_LIST);
        m.put("java.lang.String", RealmFieldType.STRING_LIST);
        m.put("java.util.Date", RealmFieldType.DATE_LIST);
        m.put("byte[]", RealmFieldType.BINARY_LIST);
        LIST_ELEMENT_TYPE_TO_REALM_TYPES = Collections.unmodifiableMap(m);
    }

    public static enum RealmFieldType {
        NOTYPE(null, "Void"),
        INTEGER("INTEGER", "Long"),
        FLOAT("FLOAT", "Float"),
        DOUBLE("DOUBLE", "Double"),
        BOOLEAN("BOOLEAN", "Boolean"),
        STRING("STRING", "String"),
        DATE("DATE", "Date"),
        BINARY("BINARY", "BinaryByteArray"),
        REALM_INTEGER("INTEGER", "Long"),
        OBJECT("OBJECT", "Object"),
        LIST("LIST", "List"),
        BACKLINK("LINKING_OBJECTS", null),
        INTEGER_LIST("INTEGER_LIST", "List"),
        BOOLEAN_LIST("BOOLEAN_LIST", "List"),
        STRING_LIST("STRING_LIST", "List"),
        BINARY_LIST("BINARY_LIST", "List"),
        DATE_LIST("DATE_LIST", "List"),
        FLOAT_LIST("FLOAT_LIST", "List"),
        DOUBLE_LIST("DOUBLE_LIST", "List");

        private final String realmType;
        private final String javaType;

        private RealmFieldType(String realmType, String javaType) {
            this.realmType = "RealmFieldType." + realmType;
            this.javaType = javaType;
        }

        public String getRealmType() {
            return this.realmType;
        }

        public String getJavaType() {
            return this.javaType;
        }
    }
}

