/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.RealmModule;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ModuleMetaData {
    private final Set<ClassMetaData> availableClasses;
    private Map<String, Set<ClassMetaData>> modules = new HashMap<String, Set<ClassMetaData>>();
    private Map<String, Set<ClassMetaData>> libraryModules = new HashMap<String, Set<ClassMetaData>>();
    private Map<String, ClassMetaData> classMetaData = new HashMap<String, ClassMetaData>();
    private boolean shouldCreateDefaultModule;

    public ModuleMetaData(Set<ClassMetaData> availableClasses) {
        this.availableClasses = availableClasses;
        for (ClassMetaData classMetaData : availableClasses) {
            this.classMetaData.put(classMetaData.getFullyQualifiedClassName(), classMetaData);
        }
    }

    public boolean generate(Set<? extends Element> clazzes) {
        for (Element element : clazzes) {
            Set<ClassMetaData> classes;
            String classSimpleName = element.getSimpleName().toString();
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                Utils.error("The RealmModule annotation can only be applied to classes", element);
                return false;
            }
            RealmModule module = element.getAnnotation(RealmModule.class);
            Utils.note("Processing module " + classSimpleName);
            if (module.allClasses() && this.hasCustomClassList(element)) {
                Utils.error("Setting @RealmModule(allClasses=true) will override @RealmModule(classes={...}) in " + classSimpleName);
                return false;
            }
            String qualifiedName = ((TypeElement)element).getQualifiedName().toString();
            if (module.allClasses()) {
                classes = this.availableClasses;
            } else {
                classes = new HashSet<ClassMetaData>();
                Set<String> classNames = this.getClassMetaDataFromModule(element);
                for (String fullyQualifiedClassName : classNames) {
                    ClassMetaData metadata = this.classMetaData.get(fullyQualifiedClassName);
                    if (metadata == null) {
                        Utils.error(Utils.stripPackage(fullyQualifiedClassName) + " could not be added to the module. Only classes extending RealmObject, which are part of this project, can be added.");
                        return false;
                    }
                    classes.add(metadata);
                }
            }
            if (module.library()) {
                this.libraryModules.put(qualifiedName, classes);
                continue;
            }
            this.modules.put(qualifiedName, classes);
        }
        if (this.modules.size() > 0 && this.libraryModules.size() > 0) {
            Utils.error("Normal modules and library modules cannot be mixed in the same project");
            return false;
        }
        if (this.libraryModules.size() == 0 && this.availableClasses.size() > 0) {
            this.shouldCreateDefaultModule = true;
            String defaultModuleName = "io.realm.DefaultRealmModule";
            this.modules.put(defaultModuleName, this.availableClasses);
        }
        return true;
    }

    private Set<String> getClassMetaDataFromModule(Element classElement) {
        AnnotationMirror annotationMirror = this.getAnnotationMirror(classElement);
        AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror);
        HashSet<String> classes = new HashSet<String>();
        List moduleClasses = (List)annotationValue.getValue();
        for (AnnotationValue classMirror : moduleClasses) {
            String fullyQualifiedClassName = classMirror.getValue().toString();
            classes.add(fullyQualifiedClassName);
        }
        return classes;
    }

    private boolean hasCustomClassList(Element classElement) {
        AnnotationMirror annotationMirror = this.getAnnotationMirror(classElement);
        AnnotationValue annotationValue = this.getAnnotationValue(annotationMirror);
        if (annotationValue == null) {
            return false;
        }
        List moduleClasses = (List)annotationValue.getValue();
        return moduleClasses.size() > 0;
    }

    private AnnotationMirror getAnnotationMirror(Element classElement) {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : classElement.getAnnotationMirrors()) {
            if (!annotationMirror2.getAnnotationType().toString().equals(RealmModule.class.getCanonicalName())) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        return annotationMirror;
    }

    private AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror) {
        if (annotationMirror == null) {
            return null;
        }
        AnnotationValue annotationValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals("classes")) continue;
            annotationValue = entry.getValue();
            break;
        }
        return annotationValue;
    }

    public Map<String, Set<ClassMetaData>> getAllModules() {
        HashMap<String, Set<ClassMetaData>> allModules = new HashMap<String, Set<ClassMetaData>>();
        allModules.putAll(this.modules);
        allModules.putAll(this.libraryModules);
        return allModules;
    }

    public boolean shouldCreateDefaultModule() {
        return this.shouldCreateDefaultModule;
    }
}

