/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RealmJsonTypeHelper {
    private static final Map<String, JsonToRealmFieldTypeConverter> JAVA_TO_JSON_TYPES;

    private RealmJsonTypeHelper() {
    }

    public static void emitIllegalJsonValueException(String fieldType, String fieldName, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).emitStatement("throw new io.realm.exceptions.RealmException(\"\\\"%s\\\" field \\\"%s\\\" cannot be loaded from json\")", new Object[]{fieldType, fieldName}).endControlFlow();
    }

    public static void emitCreateObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String qualifiedFieldType, String fieldName, JavaWriter writer) throws IOException {
        JsonToRealmFieldTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(qualifiedFieldType);
        if (typeEmitter != null) {
            typeEmitter.emitGetObjectWithPrimaryKeyValue(qualifiedRealmObjectClass, qualifiedRealmObjectProxyClass, fieldName, writer);
        }
    }

    public static void emitFillRealmObjectWithJsonValue(String varName, String setter, String fieldName, String qualifiedFieldType, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("%s.%s(null)", new Object[]{varName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createOrUpdateUsingJsonObject(realm, json.getJSONObject(\"%s\"), update)", new Object[]{qualifiedFieldType, fieldName, proxyClass, fieldName}).emitStatement("%s.%s(%sObj)", new Object[]{varName, setter, fieldName}).endControlFlow().endControlFlow();
    }

    public static void emitFillRealmListWithJsonValue(String varName, String getter, String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("%s.%s(null)", new Object[]{varName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s.%s().clear()", new Object[]{varName, getter}).emitStatement("JSONArray array = json.getJSONArray(\"%s\")", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < array.length(); i++)", new Object[0]).emitStatement("%s item = %s.createOrUpdateUsingJsonObject(realm, array.getJSONObject(i), update)", new Object[]{fieldTypeCanonicalName, proxyClass, fieldTypeCanonicalName}).emitStatement("%s.%s().add(item)", new Object[]{varName, getter}).endControlFlow().endControlFlow().endControlFlow();
    }

    public static void emitFillJavaTypeWithJsonValue(String varName, String accessor, String fieldName, String qualifiedFieldType, JavaWriter writer) throws IOException {
        JsonToRealmFieldTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(qualifiedFieldType);
        if (typeEmitter != null) {
            typeEmitter.emitTypeConversion(varName, accessor, fieldName, qualifiedFieldType, writer);
        }
    }

    public static void emitFillRealmObjectFromStream(String varName, String setter, String fieldName, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("%s.%s(null)", new Object[]{varName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s %sObj = %s.createUsingJsonStream(realm, reader)", new Object[]{fieldTypeCanonicalName, fieldName, proxyClass}).emitStatement("%s.%s(%sObj)", new Object[]{varName, setter, fieldName}).endControlFlow();
    }

    public static void emitFillRealmListFromStream(String varName, String getter, String setter, String fieldTypeCanonicalName, String proxyClass, JavaWriter writer) throws IOException {
        writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("%s.%s(null)", new Object[]{varName, setter}).nextControlFlow("else", new Object[0]).emitStatement("%s.%s(new RealmList<%s>())", new Object[]{varName, setter, fieldTypeCanonicalName}).emitStatement("reader.beginArray()", new Object[0]).beginControlFlow("while (reader.hasNext())", new Object[0]).emitStatement("%s item = %s.createUsingJsonStream(realm, reader)", new Object[]{fieldTypeCanonicalName, proxyClass}).emitStatement("%s.%s().add(item)", new Object[]{varName, getter}).endControlFlow().emitStatement("reader.endArray()", new Object[0]).endControlFlow();
    }

    public static void emitFillJavaTypeFromStream(String varName, ClassMetaData metaData, String accessor, String fieldName, String fieldType, JavaWriter writer) throws IOException {
        boolean isPrimaryKey = metaData.hasPrimaryKey() && metaData.getPrimaryKey().getSimpleName().toString().equals(fieldName);
        JsonToRealmFieldTypeConverter typeEmitter = JAVA_TO_JSON_TYPES.get(fieldType);
        if (typeEmitter != null) {
            typeEmitter.emitStreamTypeConversion(varName, accessor, fieldName, fieldType, writer, isPrimaryKey);
        }
    }

    static {
        HashMap<String, JsonToRealmFieldTypeConverter> m = new HashMap<String, JsonToRealmFieldTypeConverter>();
        m.put("byte", new SimpleTypeConverter("byte", "Int"));
        m.put("short", new SimpleTypeConverter("short", "Int"));
        m.put("int", new SimpleTypeConverter("int", "Int"));
        m.put("long", new SimpleTypeConverter("long", "Long"));
        m.put("float", new SimpleTypeConverter("float", "Double"));
        m.put("double", new SimpleTypeConverter("double", "Double"));
        m.put("boolean", new SimpleTypeConverter("boolean", "Boolean"));
        m.put("byte[]", new ByteArrayTypeConverter());
        m.put("java.lang.Byte", (JsonToRealmFieldTypeConverter)m.get("byte"));
        m.put("java.lang.Short", (JsonToRealmFieldTypeConverter)m.get("short"));
        m.put("java.lang.Integer", (JsonToRealmFieldTypeConverter)m.get("int"));
        m.put("java.lang.Long", (JsonToRealmFieldTypeConverter)m.get("long"));
        m.put("java.lang.Float", (JsonToRealmFieldTypeConverter)m.get("float"));
        m.put("java.lang.Double", (JsonToRealmFieldTypeConverter)m.get("double"));
        m.put("java.lang.Boolean", (JsonToRealmFieldTypeConverter)m.get("boolean"));
        m.put("java.lang.String", new SimpleTypeConverter("String", "String"));
        m.put("java.util.Date", new DateTypeConverter());
        m.put("io.realm.MutableRealmInteger", new MutableRealmIntegerTypeConverter());
        JAVA_TO_JSON_TYPES = Collections.unmodifiableMap(m);
    }

    private static interface JsonToRealmFieldTypeConverter {
        public void emitTypeConversion(String var1, String var2, String var3, String var4, JavaWriter var5) throws IOException;

        public void emitStreamTypeConversion(String var1, String var2, String var3, String var4, JavaWriter var5, boolean var6) throws IOException;

        public void emitGetObjectWithPrimaryKeyValue(String var1, String var2, String var3, JavaWriter var4) throws IOException;
    }

    private static class MutableRealmIntegerTypeConverter
    implements JsonToRealmFieldTypeConverter {
        private MutableRealmIntegerTypeConverter() {
        }

        @Override
        public void emitTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).emitStatement("%1$s.%2$s().set((json.isNull(\"%3$s\")) ? null : json.getLong(\"%3$s\"))", new Object[]{varName, accessor, fieldName}).endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
            writer.emitStatement("Long val = null", new Object[0]).beginControlFlow("if (reader.peek() != JsonToken.NULL)", new Object[0]).emitStatement("val = reader.nextLong()", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).endControlFlow().emitStatement("%1$s.%2$s().set(val)", new Object[]{varName, accessor});
        }

        @Override
        public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
            throw new IllegalArgumentException("'MutableRealmInteger' is not allowed as a primary key value.");
        }
    }

    private static class DateTypeConverter
    implements JsonToRealmFieldTypeConverter {
        private DateTypeConverter() {
        }

        @Override
        public void emitTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("%s.%s(null)", new Object[]{varName, accessor}).nextControlFlow("else", new Object[0]).emitStatement("Object timestamp = json.get(\"%s\")", new Object[]{fieldName}).beginControlFlow("if (timestamp instanceof String)", new Object[0]).emitStatement("%s.%s(JsonUtils.stringToDate((String) timestamp))", new Object[]{varName, accessor}).nextControlFlow("else", new Object[0]).emitStatement("%s.%s(new Date(json.getLong(\"%s\")))", new Object[]{varName, accessor, fieldName}).endControlFlow().endControlFlow().endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
            writer.beginControlFlow("if (reader.peek() == JsonToken.NULL)", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("%s.%s(null)", new Object[]{varName, accessor}).nextControlFlow("else if (reader.peek() == JsonToken.NUMBER)", new Object[0]).emitStatement("long timestamp = reader.nextLong()", new Object[]{fieldName}).beginControlFlow("if (timestamp > -1)", new Object[0]).emitStatement("%s.%s(new Date(timestamp))", new Object[]{varName, accessor}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("%s.%s(JsonUtils.stringToDate(reader.nextString()))", new Object[]{varName, accessor}).endControlFlow();
        }

        @Override
        public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
            throw new IllegalArgumentException("'Date' is not allowed as a primary key value.");
        }
    }

    private static class ByteArrayTypeConverter
    implements JsonToRealmFieldTypeConverter {
        private ByteArrayTypeConverter() {
        }

        @Override
        public void emitTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("%s.%s(null)", new Object[]{varName, accessor}).nextControlFlow("else", new Object[0]).emitStatement("%s.%s(JsonUtils.stringToBytes(json.getString(\"%s\")))", new Object[]{varName, accessor, fieldName}).endControlFlow().endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
            writer.beginControlFlow("if (reader.peek() != JsonToken.NULL)", new Object[0]).emitStatement("%s.%s(JsonUtils.stringToBytes(reader.nextString()))", new Object[]{varName, accessor}).nextControlFlow("else", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement("%s.%s(null)", new Object[]{varName, accessor}).endControlFlow();
        }

        @Override
        public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
            throw new IllegalArgumentException("'byte[]' is not allowed as a primary key value.");
        }
    }

    private static class SimpleTypeConverter
    implements JsonToRealmFieldTypeConverter {
        private final String castType;
        private final String jsonType;

        private SimpleTypeConverter(String castType, String jsonType) {
            this.castType = castType;
            this.jsonType = jsonType;
        }

        @Override
        public void emitTypeConversion(String varName, String accessor, String fieldName, String fieldType, JavaWriter writer) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format(Locale.US, "throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", fieldName) : String.format(Locale.US, "%s.%s(null)", varName, accessor);
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement(statementSetNullOrThrow, new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("%s.%s((%s) json.get%s(\"%s\"))", new Object[]{varName, accessor, this.castType, this.jsonType, fieldName}).endControlFlow().endControlFlow();
        }

        @Override
        public void emitStreamTypeConversion(String varName, String setter, String fieldName, String fieldType, JavaWriter writer, boolean isPrimaryKey) throws IOException {
            String statementSetNullOrThrow = Utils.isPrimitiveType(fieldType) ? String.format(Locale.US, "throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", fieldName) : String.format(Locale.US, "%s.%s(null)", varName, setter);
            writer.beginControlFlow("if (reader.peek() != JsonToken.NULL)", new Object[0]).emitStatement("%s.%s((%s) reader.next%s())", new Object[]{varName, setter, this.castType, this.jsonType}).nextControlFlow("else", new Object[0]).emitStatement("reader.skipValue()", new Object[0]).emitStatement(statementSetNullOrThrow, new Object[0]).endControlFlow();
            if (isPrimaryKey) {
                writer.emitStatement("jsonHasPrimaryKey = true", new Object[0]);
            }
        }

        @Override
        public void emitGetObjectWithPrimaryKeyValue(String qualifiedRealmObjectClass, String qualifiedRealmObjectProxyClass, String fieldName, JavaWriter writer) throws IOException {
            writer.beginControlFlow("if (json.has(\"%s\"))", new Object[]{fieldName}).beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{fieldName}).emitStatement("obj = (%1$s) realm.createObjectInternal(%2$s.class, null, true, excludeFields)", new Object[]{qualifiedRealmObjectProxyClass, qualifiedRealmObjectClass}).nextControlFlow("else", new Object[0]).emitStatement("obj = (%1$s) realm.createObjectInternal(%2$s.class, json.get%3$s(\"%4$s\"), true, excludeFields)", new Object[]{qualifiedRealmObjectProxyClass, qualifiedRealmObjectClass, this.jsonType, fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("throw new IllegalArgumentException(\"JSON object doesn't have the primary key field '%s'.\")", new Object[]{fieldName}).endControlFlow();
        }
    }
}

