/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.annotations.RealmClass;
import io.realm.annotations.RealmModule;
import io.realm.processor.Backlink;
import io.realm.processor.ClassMetaData;
import io.realm.processor.DefaultModuleGenerator;
import io.realm.processor.ModuleMetaData;
import io.realm.processor.RealmProxyClassGenerator;
import io.realm.processor.RealmProxyInterfaceGenerator;
import io.realm.processor.RealmProxyMediatorGenerator;
import io.realm.processor.RealmVersionChecker;
import io.realm.processor.TypeMirrors;
import io.realm.processor.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"io.realm.annotations.RealmClass", "io.realm.annotations.Ignore", "io.realm.annotations.Index", "io.realm.annotations.PrimaryKey", "io.realm.annotations.RealmModule", "io.realm.annotations.Required"})
@SupportedOptions(value={"realm.suppressWarnings", "realm.ignoreKotlinNullability"})
public class RealmProcessor
extends AbstractProcessor {
    private static final boolean CONSUME_ANNOTATIONS = false;
    private final Set<ClassMetaData> classesToValidate = new HashSet<ClassMetaData>();
    private final Set<Backlink> backlinksToValidate = new HashSet<Backlink>();
    private boolean hasProcessedModules = false;
    private int round = -1;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ++this.round;
        if (this.round == 0) {
            RealmVersionChecker.getInstance(this.processingEnv).executeRealmVersionUpdate();
        }
        if (roundEnv.errorRaised()) {
            return true;
        }
        if (!this.hasProcessedModules) {
            Utils.initialize(this.processingEnv);
            if (!this.processAnnotations(roundEnv)) {
                return true;
            }
            this.hasProcessedModules = true;
            if (!this.processModules(roundEnv)) {
                return true;
            }
        }
        return roundEnv.processingOver() && !this.validateBacklinks();
    }

    private boolean processAnnotations(RoundEnvironment roundEnv) {
        TypeMirrors typeMirrors = new TypeMirrors(this.processingEnv);
        for (Element element : roundEnv.getElementsAnnotatedWith(RealmClass.class)) {
            if (!Utils.isImplementingMarkerInterface(element)) {
                Utils.error("A RealmClass annotated object must implement RealmModel or derive from RealmObject.", element);
                return false;
            }
            if (!element.getKind().equals((Object)ElementKind.CLASS)) {
                Utils.error("The RealmClass annotation can only be applied to classes.", element);
                return false;
            }
            ClassMetaData metadata = new ClassMetaData(this.processingEnv, typeMirrors, (TypeElement)element);
            if (!metadata.isModelClass()) continue;
            Utils.note("Processing class " + metadata.getSimpleClassName());
            if (!metadata.generate()) {
                return false;
            }
            this.classesToValidate.add(metadata);
            this.backlinksToValidate.addAll(metadata.getBacklinkFields());
            RealmProxyInterfaceGenerator interfaceGenerator = new RealmProxyInterfaceGenerator(this.processingEnv, metadata);
            try {
                interfaceGenerator.generate();
            }
            catch (IOException e) {
                Utils.error(e.getMessage(), element);
            }
            RealmProxyClassGenerator sourceCodeGenerator = new RealmProxyClassGenerator(this.processingEnv, typeMirrors, metadata);
            try {
                sourceCodeGenerator.generate();
            }
            catch (IOException e) {
                Utils.error(e.getMessage(), element);
            }
            catch (UnsupportedOperationException e) {
                Utils.error(e.getMessage(), element);
            }
        }
        return true;
    }

    private boolean processModules(RoundEnvironment roundEnv) {
        ModuleMetaData moduleMetaData = new ModuleMetaData(this.classesToValidate);
        if (!moduleMetaData.generate(roundEnv.getElementsAnnotatedWith(RealmModule.class))) {
            return false;
        }
        if (moduleMetaData.shouldCreateDefaultModule() && !this.createDefaultModule()) {
            return false;
        }
        for (Map.Entry<String, Set<ClassMetaData>> module : moduleMetaData.getAllModules().entrySet()) {
            if (this.createMediator(Utils.stripPackage(module.getKey()), module.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean createDefaultModule() {
        Utils.note("Creating DefaultRealmModule");
        DefaultModuleGenerator defaultModuleGenerator = new DefaultModuleGenerator(this.processingEnv);
        try {
            defaultModuleGenerator.generate();
        }
        catch (IOException e) {
            Utils.error(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createMediator(String simpleModuleName, Set<ClassMetaData> moduleClasses) {
        RealmProxyMediatorGenerator mediatorImplGenerator = new RealmProxyMediatorGenerator(this.processingEnv, simpleModuleName, moduleClasses);
        try {
            mediatorImplGenerator.generate();
        }
        catch (IOException e) {
            Utils.error(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean validateBacklinks() {
        boolean allValid = true;
        HashMap<String, ClassMetaData> realmClasses = new HashMap<String, ClassMetaData>(this.classesToValidate.size());
        for (ClassMetaData classData : this.classesToValidate) {
            realmClasses.put(classData.getFullyQualifiedClassName(), classData);
        }
        for (Backlink backlink : this.backlinksToValidate) {
            ClassMetaData clazz = (ClassMetaData)realmClasses.get(backlink.getSourceClass());
            if (clazz == null || backlink.validateTarget(clazz) || !allValid) continue;
            allValid = false;
        }
        return allValid;
    }
}

