/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.processor.Backlink;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Constants;
import io.realm.processor.RealmJsonTypeHelper;
import io.realm.processor.TypeMirrors;
import io.realm.processor.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class RealmProxyClassGenerator {
    private static final String OPTION_SUPPRESS_WARNINGS = "realm.suppressWarnings";
    private static final String BACKLINKS_FIELD_EXTENSION = "Backlinks";
    private static final List<String> IMPORTS;
    private final ProcessingEnvironment processingEnvironment;
    private final TypeMirrors typeMirrors;
    private final ClassMetaData metadata;
    private final String simpleClassName;
    private final String qualifiedClassName;
    private final String interfaceName;
    private final String qualifiedGeneratedClassName;
    private final boolean suppressWarnings;

    public RealmProxyClassGenerator(ProcessingEnvironment processingEnvironment, TypeMirrors typeMirrors, ClassMetaData metadata) {
        this.processingEnvironment = processingEnvironment;
        this.typeMirrors = typeMirrors;
        this.metadata = metadata;
        this.simpleClassName = metadata.getSimpleClassName();
        this.qualifiedClassName = metadata.getFullyQualifiedClassName();
        this.interfaceName = Utils.getProxyInterfaceName(this.simpleClassName);
        this.qualifiedGeneratedClassName = String.format(Locale.US, "%s.%s", "io.realm", Utils.getProxyClassName(this.simpleClassName));
        this.suppressWarnings = !"false".equalsIgnoreCase(processingEnvironment.getOptions().get(OPTION_SUPPRESS_WARNINGS));
    }

    public void generate() throws IOException, UnsupportedOperationException {
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(this.qualifiedGeneratedClassName, new Element[0]);
        JavaWriter writer = new JavaWriter((Writer)new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm").emitEmptyLine();
        ArrayList<String> imports = new ArrayList<String>(IMPORTS);
        if (!this.metadata.getBacklinkFields().isEmpty()) {
            imports.add("io.realm.internal.UncheckedRow");
        }
        writer.emitImports(imports).emitEmptyLine();
        if (this.suppressWarnings) {
            writer.emitAnnotation("SuppressWarnings(\"all\")");
        }
        writer.beginType(this.qualifiedGeneratedClassName, "class", EnumSet.of(Modifier.PUBLIC), this.qualifiedClassName, new String[]{"RealmObjectProxy", this.interfaceName}).emitEmptyLine();
        this.emitColumnInfoClass(writer);
        this.emitClassFields(writer);
        this.emitInstanceFields(writer);
        this.emitConstructor(writer);
        this.emitInjectContextMethod(writer);
        this.emitPersistedFieldAccessors(writer);
        this.emitBacklinkFieldAccessors(writer);
        this.emitCreateExpectedObjectSchemaInfo(writer);
        this.emitGetExpectedObjectSchemaInfo(writer);
        this.emitCreateColumnInfoMethod(writer);
        this.emitGetSimpleClassNameMethod(writer);
        this.emitGetFieldNamesMethod(writer);
        this.emitCreateOrUpdateUsingJsonObject(writer);
        this.emitCreateUsingJsonStream(writer);
        this.emitCopyOrUpdateMethod(writer);
        this.emitCopyMethod(writer);
        this.emitInsertMethod(writer);
        this.emitInsertListMethod(writer);
        this.emitInsertOrUpdateMethod(writer);
        this.emitInsertOrUpdateListMethod(writer);
        this.emitCreateDetachedCopyMethod(writer);
        this.emitUpdateMethod(writer);
        this.emitToStringMethod(writer);
        this.emitRealmObjectProxyImplementation(writer);
        this.emitHashcodeMethod(writer);
        this.emitEqualsMethod(writer);
        writer.endType();
        writer.close();
    }

    private void emitColumnInfoClass(JavaWriter writer) throws IOException {
        writer.beginType(this.columnInfoClassName(), "class", EnumSet.of(Modifier.STATIC, Modifier.FINAL), "ColumnInfo", new String[0]);
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitField("long", this.columnIndexVarName(variableElement));
        }
        writer.emitEmptyLine();
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), new String[]{"OsSchemaInfo", "schemaInfo"});
        writer.emitStatement("super(%s)", new Object[]{this.metadata.getFields().size()});
        writer.emitStatement("OsObjectSchemaInfo objectSchemaInfo = schemaInfo.getObjectSchemaInfo(\"%1$s\")", new Object[]{this.simpleClassName});
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("this.%1$sIndex = addColumnDetails(\"%1$s\", objectSchemaInfo)", new Object[]{field.getSimpleName().toString()});
        }
        for (Backlink backlink : this.metadata.getBacklinkFields()) {
            writer.emitStatement("addBacklinkDetails(schemaInfo, \"%s\", \"%s\", \"%s\")", new Object[]{backlink.getTargetField(), Utils.stripPackage(backlink.getSourceClass()), backlink.getSourceField()});
        }
        writer.endConstructor().emitEmptyLine();
        writer.beginConstructor(EnumSet.noneOf(Modifier.class), new String[]{"ColumnInfo", "src", "boolean", "mutable"});
        writer.emitStatement("super(src, mutable)", new Object[0]).emitStatement("copy(src, this)", new Object[0]);
        writer.endConstructor().emitEmptyLine();
        writer.emitAnnotation("Override").beginMethod("ColumnInfo", "copy", EnumSet.of(Modifier.PROTECTED, Modifier.FINAL), new String[]{"boolean", "mutable"});
        writer.emitStatement("return new %s(this, mutable)", new Object[]{this.columnInfoClassName()});
        writer.endMethod().emitEmptyLine();
        writer.emitAnnotation("Override").beginMethod("void", "copy", EnumSet.of(Modifier.PROTECTED, Modifier.FINAL), new String[]{"ColumnInfo", "rawSrc", "ColumnInfo", "rawDst"});
        writer.emitStatement("final %1$s src = (%1$s) rawSrc", new Object[]{this.columnInfoClassName()});
        writer.emitStatement("final %1$s dst = (%1$s) rawDst", new Object[]{this.columnInfoClassName()});
        for (VariableElement variableElement : this.metadata.getFields()) {
            writer.emitStatement("dst.%1$s = src.%1$s", new Object[]{this.columnIndexVarName(variableElement)});
        }
        writer.endMethod();
        writer.endType();
    }

    private void emitClassFields(JavaWriter writer) throws IOException {
        writer.emitEmptyLine().emitField("OsObjectSchemaInfo", "expectedObjectSchemaInfo", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "createExpectedObjectSchemaInfo()");
        writer.emitField("List<String>", "FIELD_NAMES", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL));
        writer.beginInitializer(true).emitStatement("List<String> fieldNames = new ArrayList<String>(%s)", new Object[]{this.metadata.getFields().size()});
        for (VariableElement field : this.metadata.getFields()) {
            writer.emitStatement("fieldNames.add(\"%s\")", new Object[]{field.getSimpleName().toString()});
        }
        writer.emitStatement("FIELD_NAMES = Collections.unmodifiableList(fieldNames)", new Object[0]).endInitializer();
    }

    private void emitInstanceFields(JavaWriter writer) throws IOException {
        writer.emitEmptyLine().emitField(this.columnInfoClassName(), "columnInfo", EnumSet.of(Modifier.PRIVATE)).emitField("ProxyState<" + this.qualifiedClassName + ">", "proxyState", EnumSet.of(Modifier.PRIVATE));
        for (VariableElement variableElement : this.metadata.getFields()) {
            if (Utils.isMutableRealmInteger(variableElement)) {
                this.emitMutableRealmIntegerField(writer, variableElement);
                continue;
            }
            if (!Utils.isRealmList(variableElement)) continue;
            String genericType = Utils.getGenericTypeQualifiedName(variableElement);
            writer.emitField("RealmList<" + genericType + ">", variableElement.getSimpleName().toString() + "RealmList", EnumSet.of(Modifier.PRIVATE));
        }
        for (Backlink backlink : this.metadata.getBacklinkFields()) {
            writer.emitField(backlink.getTargetFieldType(), backlink.getTargetField() + BACKLINKS_FIELD_EXTENSION, EnumSet.of(Modifier.PRIVATE));
        }
    }

    private void emitMutableRealmIntegerField(JavaWriter writer, VariableElement variableElement) throws IOException {
        writer.emitField("MutableRealmInteger.Managed", this.mutableRealmIntegerFieldName(variableElement), EnumSet.of(Modifier.PRIVATE, Modifier.FINAL), String.format("new MutableRealmInteger.Managed<%1$s>() {\n    @Override protected ProxyState<%1$s> getProxyState() { return proxyState; }\n    @Override protected long getColumnIndex() { return columnInfo.%2$s; }\n}", this.qualifiedClassName, this.columnIndexVarName(variableElement)));
    }

    private void emitConstructor(JavaWriter writer) throws IOException {
        writer.emitEmptyLine().beginConstructor(EnumSet.noneOf(Modifier.class), new String[0]).emitStatement("proxyState.setConstructionFinished()", new Object[0]).endConstructor().emitEmptyLine();
    }

    private void emitPersistedFieldAccessors(JavaWriter writer) throws IOException {
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            if (Constants.JAVA_TO_REALM_TYPES.containsKey(fieldTypeCanonicalName)) {
                this.emitPrimitiveType(writer, field, fieldName, fieldTypeCanonicalName);
            } else if (Utils.isMutableRealmInteger(field)) {
                this.emitMutableRealmInteger(writer, field, fieldName, fieldTypeCanonicalName);
            } else if (Utils.isRealmModel(field)) {
                this.emitRealmModel(writer, field, fieldName, fieldTypeCanonicalName);
            } else if (Utils.isRealmList(field)) {
                TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
                this.emitRealmList(writer, field, fieldName, fieldTypeCanonicalName, elementTypeMirror);
            } else {
                throw new UnsupportedOperationException(String.format(Locale.US, "Field \"%s\" of type \"%s\" is not supported.", fieldName, fieldTypeCanonicalName));
            }
            writer.emitEmptyLine();
        }
    }

    private void emitPrimitiveType(JavaWriter writer, final VariableElement field, final String fieldName, String fieldTypeCanonicalName) throws IOException {
        String castingBackType;
        final String fieldJavaType = this.getRealmTypeChecked(field).getJavaType();
        writer.emitAnnotation("Override");
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"").beginMethod(fieldTypeCanonicalName, this.metadata.getInternalGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
        if (this.metadata.isNullable(field) && !Utils.isString(field) && !Utils.isByteArray(field)) {
            writer.beginControlFlow("if (proxyState.getRow$realm().isNull(%s))", new Object[]{this.fieldIndexVariableReference(field)}).emitStatement("return null", new Object[0]).endControlFlow();
        }
        if (Utils.isBoxedType(fieldTypeCanonicalName)) {
            Types typeUtils = this.processingEnvironment.getTypeUtils();
            castingBackType = typeUtils.unboxedType(field.asType()).toString();
        } else {
            castingBackType = fieldTypeCanonicalName;
        }
        writer.emitStatement("return (%s) proxyState.getRow$realm().get%s(%s)", new Object[]{castingBackType, fieldJavaType, this.fieldIndexVariableReference(field)});
        writer.endMethod().emitEmptyLine();
        writer.emitAnnotation("Override");
        writer.beginMethod("void", this.metadata.getInternalSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
        this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

            @Override
            public void emit(JavaWriter writer) throws IOException {
                writer.emitStatement("final Row row = proxyState.getRow$realm()", new Object[0]);
                if (RealmProxyClassGenerator.this.metadata.isNullable(field)) {
                    writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("row.getTable().setNull(%s, row.getIndex(), true)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
                } else if (!RealmProxyClassGenerator.this.metadata.isNullable(field) && !Utils.isPrimitiveType(field)) {
                    writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", new Object[]{fieldName}).endControlFlow();
                }
                writer.emitStatement("row.getTable().set%s(%s, row.getIndex(), value, true)", new Object[]{fieldJavaType, RealmProxyClassGenerator.this.fieldIndexVariableReference(field)});
                writer.emitStatement("return", new Object[0]);
            }
        });
        writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
        if (this.metadata.isPrimaryKey(field)) {
            writer.emitStatement("throw new io.realm.exceptions.RealmException(\"Primary key field '%s' cannot be changed after object was created.\")", new Object[]{fieldName});
        } else {
            if (this.metadata.isNullable(field)) {
                writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("proxyState.getRow$realm().setNull(%s)", new Object[]{this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
            } else if (!this.metadata.isNullable(field) && !Utils.isPrimitiveType(field)) {
                writer.beginControlFlow("if (value == null)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Trying to set non-nullable field '%s' to null.\")", new Object[]{fieldName}).endControlFlow();
            }
            writer.emitStatement("proxyState.getRow$realm().set%s(%s, value)", new Object[]{fieldJavaType, this.fieldIndexVariableReference(field)});
        }
        writer.endMethod();
    }

    private void emitMutableRealmInteger(JavaWriter writer, VariableElement field, String fieldName, String fieldTypeCanonicalName) throws IOException {
        writer.emitAnnotation("Override").beginMethod(fieldTypeCanonicalName, this.metadata.getInternalGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]).emitStatement("return this.%s", new Object[]{this.mutableRealmIntegerFieldName(field)}).endMethod();
    }

    private void emitRealmModel(JavaWriter writer, final VariableElement field, String fieldName, String fieldTypeCanonicalName) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod(fieldTypeCanonicalName, this.metadata.getInternalGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]).beginControlFlow("if (proxyState.getRow$realm().isNullLink(%s))", new Object[]{this.fieldIndexVariableReference(field)}).emitStatement("return null", new Object[0]).endControlFlow().emitStatement("return proxyState.getRealm$realm().get(%s.class, proxyState.getRow$realm().getLink(%s), false, Collections.<String>emptyList())", new Object[]{fieldTypeCanonicalName, this.fieldIndexVariableReference(field)}).endMethod().emitEmptyLine();
        writer.emitAnnotation("Override");
        writer.beginMethod("void", this.metadata.getInternalSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
        this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

            @Override
            public void emit(JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (proxyState.getExcludeFields$realm().contains(\"%1$s\"))", new Object[]{field.getSimpleName().toString()}).emitStatement("return", new Object[0]).endControlFlow();
                writer.beginControlFlow("if (value != null && !RealmObject.isManaged(value))", new Object[0]).emitStatement("value = ((Realm) proxyState.getRealm$realm()).copyToRealm(value)", new Object[0]).endControlFlow();
                writer.emitStatement("final Row row = proxyState.getRow$realm()", new Object[0]);
                writer.beginControlFlow("if (value == null)", new Object[0]).emitSingleLineComment("Table#nullifyLink() does not support default value. Just using Row.", new Object[0]).emitStatement("row.nullifyLink(%s)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow();
                writer.emitStatement("proxyState.checkValidObject(value)", new Object[0]);
                writer.emitStatement("row.getTable().setLink(%s, row.getIndex(), ((RealmObjectProxy) value).realmGet$proxyState().getRow$realm().getIndex(), true)", new Object[]{RealmProxyClassGenerator.this.fieldIndexVariableReference(field)});
                writer.emitStatement("return", new Object[0]);
            }
        });
        writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("proxyState.getRow$realm().nullifyLink(%s)", new Object[]{this.fieldIndexVariableReference(field)}).emitStatement("return", new Object[0]).endControlFlow().emitStatement("proxyState.checkValidObject(value)", new Object[0]).emitStatement("proxyState.getRow$realm().setLink(%s, ((RealmObjectProxy) value).realmGet$proxyState().getRow$realm().getIndex())", new Object[]{this.fieldIndexVariableReference(field)}).endMethod();
    }

    private void emitRealmList(JavaWriter writer, final VariableElement field, String fieldName, String fieldTypeCanonicalName, TypeMirror elementTypeMirror) throws IOException {
        final String genericType = Utils.getGenericTypeQualifiedName(field);
        final boolean forRealmModel = Utils.isRealmModel(elementTypeMirror);
        writer.emitAnnotation("Override");
        writer.beginMethod(fieldTypeCanonicalName, this.metadata.getInternalGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]).emitSingleLineComment("use the cached value if available", new Object[0]).beginControlFlow("if (" + fieldName + "RealmList != null)", new Object[0]).emitStatement("return " + fieldName + "RealmList", new Object[0]).nextControlFlow("else", new Object[0]);
        if (Utils.isRealmModelList(field)) {
            writer.emitStatement("OsList osList = proxyState.getRow$realm().getModelList(%s)", new Object[]{this.fieldIndexVariableReference(field)});
        } else {
            writer.emitStatement("OsList osList = proxyState.getRow$realm().getValueList(%1$s, RealmFieldType.%2$s)", new Object[]{this.fieldIndexVariableReference(field), Utils.getValueListFieldType(field).name()});
        }
        writer.emitStatement(fieldName + "RealmList = new RealmList<%s>(%s.class, osList, proxyState.getRealm$realm())", new Object[]{genericType, genericType}).emitStatement("return " + fieldName + "RealmList", new Object[0]).endControlFlow().endMethod().emitEmptyLine();
        writer.emitAnnotation("Override");
        writer.beginMethod("void", this.metadata.getInternalSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"});
        this.emitCodeForUnderConstruction(writer, this.metadata.isPrimaryKey(field), new CodeEmitter(){

            @Override
            public void emit(JavaWriter writer) throws IOException {
                writer.beginControlFlow("if (proxyState.getExcludeFields$realm().contains(\"%1$s\"))", new Object[]{field.getSimpleName().toString()}).emitStatement("return", new Object[0]).endControlFlow();
                if (!forRealmModel) {
                    return;
                }
                writer.emitSingleLineComment("if the list contains unmanaged RealmObjects, convert them to managed.", new Object[0]).beginControlFlow("if (value != null && !value.isManaged())", new Object[0]).emitStatement("final Realm realm = (Realm) proxyState.getRealm$realm()", new Object[0]).emitStatement("final RealmList<%1$s> original = value", new Object[]{genericType}).emitStatement("value = new RealmList<%1$s>()", new Object[]{genericType}).beginControlFlow("for (%1$s item : original)", new Object[]{genericType}).beginControlFlow("if (item == null || RealmObject.isManaged(item))", new Object[0]).emitStatement("value.add(item)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("value.add(realm.copyToRealm(item))", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
            }
        });
        writer.emitStatement("proxyState.getRealm$realm().checkIfValid()", new Object[0]);
        if (Utils.isRealmModelList(field)) {
            writer.emitStatement("OsList osList = proxyState.getRow$realm().getModelList(%s)", new Object[]{this.fieldIndexVariableReference(field)});
        } else {
            writer.emitStatement("OsList osList = proxyState.getRow$realm().getValueList(%1$s, RealmFieldType.%2$s)", new Object[]{this.fieldIndexVariableReference(field), Utils.getValueListFieldType(field).name()});
        }
        if (forRealmModel) {
            writer.emitSingleLineComment("For lists of equal lengths, we need to set each element directly as clearing the receiver list can be wrong if the input and target list are the same.", new Object[0]).beginControlFlow("if (value != null && value.size() == osList.size())", new Object[0]).emitStatement("int objects = value.size()", new Object[0]).beginControlFlow("for (int i = 0; i < objects; i++)", new Object[0]).emitStatement("%s linkedObject = value.get(i)", new Object[]{genericType}).emitStatement("proxyState.checkValidObject(linkedObject)", new Object[0]).emitStatement("osList.setRow(i, ((RealmObjectProxy) linkedObject).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("osList.removeAll()", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("return", new Object[0]).endControlFlow().emitStatement("int objects = value.size()", new Object[0]).beginControlFlow("for (int i = 0; i < objects; i++)", new Object[0]).emitStatement("%s linkedObject = value.get(i)", new Object[]{genericType}).emitStatement("proxyState.checkValidObject(linkedObject)", new Object[0]).emitStatement("osList.addRow(((RealmObjectProxy) linkedObject).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).endControlFlow().endControlFlow();
        } else {
            writer.emitStatement("osList.removeAll()", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("return", new Object[0]).endControlFlow().beginControlFlow("for (%1$s item : value)", new Object[]{genericType}).beginControlFlow("if (item == null)", new Object[0]).emitStatement(this.metadata.isElementNullable(field) ? "osList.addNull()" : "throw new IllegalArgumentException(\"Storing 'null' into " + fieldName + "' is not allowed by the schema.\")", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement(this.getStatementForAppendingValueToOsList("osList", "item", elementTypeMirror), new Object[0]).endControlFlow().endControlFlow();
        }
        writer.endMethod();
    }

    private String getStatementForAppendingValueToOsList(String osListVariableName, String valueVariableName, TypeMirror elementTypeMirror) {
        if (elementTypeMirror == this.typeMirrors.STRING_MIRROR) {
            return osListVariableName + ".addString(" + valueVariableName + ")";
        }
        if (elementTypeMirror == this.typeMirrors.LONG_MIRROR || elementTypeMirror == this.typeMirrors.INTEGER_MIRROR || elementTypeMirror == this.typeMirrors.SHORT_MIRROR || elementTypeMirror == this.typeMirrors.BYTE_MIRROR) {
            return osListVariableName + ".addLong(" + valueVariableName + ".longValue())";
        }
        if (elementTypeMirror.equals(this.typeMirrors.BINARY_MIRROR)) {
            return osListVariableName + ".addBinary(" + valueVariableName + ")";
        }
        if (elementTypeMirror == this.typeMirrors.DATE_MIRROR) {
            return osListVariableName + ".addDate(" + valueVariableName + ")";
        }
        if (elementTypeMirror == this.typeMirrors.BOOLEAN_MIRROR) {
            return osListVariableName + ".addBoolean(" + valueVariableName + ")";
        }
        if (elementTypeMirror == this.typeMirrors.DOUBLE_MIRROR) {
            return osListVariableName + ".addDouble(" + valueVariableName + ".doubleValue())";
        }
        if (elementTypeMirror == this.typeMirrors.FLOAT_MIRROR) {
            return osListVariableName + ".addFloat(" + valueVariableName + ".floatValue())";
        }
        throw new RuntimeException("unexpected element type: " + elementTypeMirror.toString());
    }

    private void emitCodeForUnderConstruction(JavaWriter writer, boolean isPrimaryKey, CodeEmitter defaultValueCodeEmitter) throws IOException {
        writer.beginControlFlow("if (proxyState.isUnderConstruction())", new Object[0]);
        if (isPrimaryKey) {
            writer.emitSingleLineComment("default value of the primary key is always ignored.", new Object[0]).emitStatement("return", new Object[0]);
        } else {
            writer.beginControlFlow("if (!proxyState.getAcceptDefaultValue$realm())", new Object[0]).emitStatement("return", new Object[0]).endControlFlow();
            defaultValueCodeEmitter.emit(writer);
        }
        writer.endControlFlow().emitEmptyLine();
    }

    private void emitInjectContextMethod(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override");
        writer.beginMethod("void", "realm$injectObjectContext", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.beginControlFlow("if (this.proxyState != null)", new Object[0]).emitStatement("return", new Object[0]).endControlFlow().emitStatement("final BaseRealm.RealmObjectContext context = BaseRealm.objectContext.get()", new Object[0]).emitStatement("this.columnInfo = (%1$s) context.getColumnInfo()", new Object[]{this.columnInfoClassName()}).emitStatement("this.proxyState = new ProxyState<%1$s>(this)", new Object[]{this.qualifiedClassName}).emitStatement("proxyState.setRealm$realm(context.getRealm())", new Object[0]).emitStatement("proxyState.setRow$realm(context.getRow())", new Object[0]).emitStatement("proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue())", new Object[0]).emitStatement("proxyState.setExcludeFields$realm(context.getExcludeFields())", new Object[0]).endMethod().emitEmptyLine();
    }

    private void emitBacklinkFieldAccessors(JavaWriter writer) throws IOException {
        for (Backlink backlink : this.metadata.getBacklinkFields()) {
            String cacheFieldName = backlink.getTargetField() + BACKLINKS_FIELD_EXTENSION;
            String realmResultsType = "RealmResults<" + backlink.getSourceClass() + ">";
            writer.emitAnnotation("Override");
            writer.beginMethod(realmResultsType, this.metadata.getInternalGetter(backlink.getTargetField()), EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("BaseRealm realm = proxyState.getRealm$realm()", new Object[0]).emitStatement("realm.checkIfValid()", new Object[0]).emitStatement("proxyState.getRow$realm().checkIfAttached()", new Object[0]).beginControlFlow("if (" + cacheFieldName + " == null)", new Object[0]).emitStatement(cacheFieldName + " = RealmResults.createBacklinkResults(realm, proxyState.getRow$realm(), %s.class, \"%s\")", new Object[]{backlink.getSourceClass(), backlink.getSourceField()}).endControlFlow().emitStatement("return " + cacheFieldName, new Object[0]).endMethod().emitEmptyLine();
        }
    }

    private void emitRealmObjectProxyImplementation(JavaWriter writer) throws IOException {
        writer.emitAnnotation("Override").beginMethod("ProxyState<?>", "realmGet$proxyState", EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("return proxyState", new Object[0]).endMethod().emitEmptyLine();
    }

    private void emitCreateExpectedObjectSchemaInfo(JavaWriter writer) throws IOException {
        writer.beginMethod("OsObjectSchemaInfo", "createExpectedObjectSchemaInfo", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC), new String[0]);
        int persistedFields = this.metadata.getFields().size();
        int computedFields = this.metadata.getBacklinkFields().size();
        writer.emitStatement("OsObjectSchemaInfo.Builder builder = new OsObjectSchemaInfo.Builder(\"%s\", %s, %s)", new Object[]{this.simpleClassName, persistedFields, computedFields});
        block8: for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            Constants.RealmFieldType fieldType = this.getRealmTypeChecked(field);
            switch (fieldType) {
                case NOTYPE: {
                    continue block8;
                }
                case OBJECT: {
                    String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
                    writer.emitStatement("builder.addPersistedLinkProperty(\"%s\", RealmFieldType.OBJECT, \"%s\")", new Object[]{fieldName, fieldTypeSimpleName});
                    continue block8;
                }
                case LIST: {
                    String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
                    writer.emitStatement("builder.addPersistedLinkProperty(\"%s\", RealmFieldType.LIST, \"%s\")", new Object[]{fieldName, genericTypeSimpleName});
                    continue block8;
                }
                case INTEGER_LIST: 
                case BOOLEAN_LIST: 
                case STRING_LIST: 
                case BINARY_LIST: 
                case DATE_LIST: 
                case FLOAT_LIST: 
                case DOUBLE_LIST: {
                    writer.emitStatement("builder.addPersistedValueListProperty(\"%s\", %s, %s)", new Object[]{fieldName, fieldType.getRealmType(), this.metadata.isElementNullable(field) ? "!Property.REQUIRED" : "Property.REQUIRED"});
                    continue block8;
                }
                case BACKLINK: {
                    throw new IllegalArgumentException("LinkingObject field should not be added to metadata");
                }
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case DATE: 
                case BINARY: 
                case REALM_INTEGER: {
                    String nullableFlag = (this.metadata.isNullable(field) ? "!" : "") + "Property.REQUIRED";
                    String indexedFlag = (this.metadata.isIndexed(field) ? "" : "!") + "Property.INDEXED";
                    String primaryKeyFlag = (this.metadata.isPrimaryKey(field) ? "" : "!") + "Property.PRIMARY_KEY";
                    writer.emitStatement("builder.addPersistedProperty(\"%s\", %s, %s, %s, %s)", new Object[]{fieldName, fieldType.getRealmType(), primaryKeyFlag, indexedFlag, nullableFlag});
                    continue block8;
                }
            }
            throw new IllegalArgumentException("'fieldType' " + fieldName + " is not handled");
        }
        for (Backlink backlink : this.metadata.getBacklinkFields()) {
            writer.emitStatement("builder.addComputedLinkProperty(\"%s\", \"%s\", \"%s\")", new Object[]{backlink.getTargetField(), backlink.getSimpleSourceClass(), backlink.getSourceField()});
        }
        writer.emitStatement("return builder.build()", new Object[0]);
        writer.endMethod().emitEmptyLine();
    }

    private void emitGetExpectedObjectSchemaInfo(JavaWriter writer) throws IOException {
        writer.beginMethod("OsObjectSchemaInfo", "getExpectedObjectSchemaInfo", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]);
        writer.emitStatement("return expectedObjectSchemaInfo", new Object[0]);
        writer.endMethod().emitEmptyLine();
    }

    private void emitCreateColumnInfoMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.columnInfoClassName(), "createColumnInfo", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"OsSchemaInfo", "schemaInfo"});
        writer.emitStatement("return new %1$s(schemaInfo)", new Object[]{this.columnInfoClassName()});
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitGetSimpleClassNameMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("String", "getSimpleClassName", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]).emitStatement("return \"%s\"", new Object[]{this.simpleClassName}).endMethod().emitEmptyLine();
    }

    private void emitGetFieldNamesMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("List<String>", "getFieldNames", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[0]).emitStatement("return FIELD_NAMES", new Object[0]).endMethod().emitEmptyLine();
    }

    private void emitCopyOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "copyOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "boolean", "update", "Map<RealmModel,RealmObjectProxy>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null)", new Object[0]).emitStatement("final BaseRealm otherRealm = ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm()", new Object[0]).beginControlFlow("if (otherRealm.threadId != realm.threadId)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.\")", new Object[0]).endControlFlow().beginControlFlow("if (otherRealm.getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return object", new Object[0]).endControlFlow().endControlFlow();
        writer.emitStatement("final BaseRealm.RealmObjectContext objectContext = BaseRealm.objectContext.get()", new Object[0]);
        writer.emitStatement("RealmObjectProxy cachedRealmObject = cache.get(object)", new Object[0]).beginControlFlow("if (cachedRealmObject != null)", new Object[0]).emitStatement("return (%s) cachedRealmObject", new Object[]{this.qualifiedClassName}).endControlFlow().emitEmptyLine();
        if (!this.metadata.hasPrimaryKey()) {
            writer.emitStatement("return copy(realm, object, update, cache)", new Object[0]);
        } else {
            writer.emitStatement("%s realmObject = null", new Object[]{this.qualifiedClassName}).emitStatement("boolean canUpdate = update", new Object[0]).beginControlFlow("if (canUpdate)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName}).emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName}).emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())});
            String primaryKeyGetter = this.metadata.getPrimaryKeyGetter();
            VariableElement primaryKeyElement = this.metadata.getPrimaryKey();
            if (this.metadata.isNullable(primaryKeyElement)) {
                if (Utils.isString(primaryKeyElement)) {
                    writer.emitStatement("String value = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirstString(pkColumnIndex, value)", new Object[0]).endControlFlow();
                } else {
                    writer.emitStatement("Number value = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]).beginControlFlow("if (value == null)", new Object[0]).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirstLong(pkColumnIndex, value.longValue())", new Object[0]).endControlFlow();
                }
            } else {
                String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
                writer.emitStatement("long rowIndex = table.findFirst%s(pkColumnIndex, ((%s) object).%s())", new Object[]{pkType, this.interfaceName, primaryKeyGetter});
            }
            writer.beginControlFlow("if (rowIndex == Table.NO_MATCH)", new Object[0]).emitStatement("canUpdate = false", new Object[0]).nextControlFlow("else", new Object[0]).beginControlFlow("try", new Object[0]).emitStatement("objectContext.set(realm, table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(%s.class), false, Collections.<String> emptyList())", new Object[]{this.qualifiedClassName}).emitStatement("realmObject = new %s()", new Object[]{this.qualifiedGeneratedClassName}).emitStatement("cache.put(object, (RealmObjectProxy) realmObject)", new Object[0]).nextControlFlow("finally", new Object[0]).emitStatement("objectContext.clear()", new Object[0]).endControlFlow().endControlFlow();
            writer.endControlFlow();
            writer.emitEmptyLine().emitStatement("return (canUpdate) ? update(realm, realmObject, object, cache) : copy(realm, object, update, cache)", new Object[0]);
        }
        writer.endMethod().emitEmptyLine();
    }

    private void setTableValues(JavaWriter writer, String fieldType, String fieldName, String interfaceName, String getter, boolean isUpdate) throws IOException {
        if ("long".equals(fieldType) || "int".equals(fieldType) || "short".equals(fieldType) || "byte".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetLong(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s) object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Long".equals(fieldType) || "java.lang.Integer".equals(fieldType) || "java.lang.Short".equals(fieldType) || "java.lang.Byte".equals(fieldType)) {
            writer.emitStatement("Number %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetLong(tableNativePtr, columnInfo.%sIndex, rowIndex, %s.longValue(), false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("io.realm.MutableRealmInteger".equals(fieldType)) {
            writer.emitStatement("Long %s = ((%s) object).%s().get()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetLong(tableNativePtr, columnInfo.%sIndex, rowIndex, %s.longValue(), false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("double".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetDouble(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s) object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Double".equals(fieldType)) {
            writer.emitStatement("Double %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetDouble(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("float".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetFloat(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s) object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Float".equals(fieldType)) {
            writer.emitStatement("Float %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetFloat(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("boolean".equals(fieldType)) {
            writer.emitStatement("Table.nativeSetBoolean(tableNativePtr, columnInfo.%sIndex, rowIndex, ((%s) object).%s(), false)", new Object[]{fieldName, interfaceName, getter});
        } else if ("java.lang.Boolean".equals(fieldType)) {
            writer.emitStatement("Boolean %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetBoolean(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("byte[]".equals(fieldType)) {
            writer.emitStatement("byte[] %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetByteArray(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("java.util.Date".equals(fieldType)) {
            writer.emitStatement("java.util.Date %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetTimestamp(tableNativePtr, columnInfo.%sIndex, rowIndex, %s.getTime(), false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else if ("java.lang.String".equals(fieldType)) {
            writer.emitStatement("String %s = ((%s) object).%s()", new Object[]{getter, interfaceName, getter}).beginControlFlow("if (%s != null)", new Object[]{getter}).emitStatement("Table.nativeSetString(tableNativePtr, columnInfo.%sIndex, rowIndex, %s, false)", new Object[]{fieldName, getter});
            if (isUpdate) {
                writer.nextControlFlow("else", new Object[0]).emitStatement("Table.nativeSetNull(tableNativePtr, columnInfo.%sIndex, rowIndex, false)", new Object[]{fieldName});
            }
            writer.endControlFlow();
        } else {
            throw new IllegalStateException("Unsupported type " + fieldType);
        }
    }

    private void emitInsertMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("long", "insert", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "Map<RealmModel,Long>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return ((RealmObjectProxy) object).realmGet$proxyState().getRow$realm().getIndex()", new Object[0]).endControlFlow();
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativePtr()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())});
        }
        this.addPrimaryKeyCheckIfNeeded(this.metadata, true, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String genericType;
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%s = %s.insert(realm, %sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insert(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.addRow(cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).beginControlFlow("if (%1$sItem == null)", new Object[]{fieldName}).emitStatement(fieldName + "OsList.addNull()", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement(this.getStatementForAppendingValueToOsList(fieldName + "OsList", fieldName + "Item", elementTypeMirror), new Object[0]).endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, false);
        }
        writer.emitStatement("return rowIndex", new Object[0]);
        writer.endMethod().emitEmptyLine();
    }

    private void emitInsertListMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "insert", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", "Iterator<? extends RealmModel>", "objects", "Map<RealmModel,Long>", "cache"});
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativePtr()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())});
        }
        writer.emitStatement("%s object = null", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("while (objects.hasNext())", new Object[0]).emitStatement("object = (%s) objects.next()", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("if (cache.containsKey(object))", new Object[0]).emitStatement("continue", new Object[0]).endControlFlow();
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]);
        writer.emitStatement("cache.put(object, ((RealmObjectProxy) object).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).emitStatement("continue", new Object[0]);
        writer.endControlFlow();
        this.addPrimaryKeyCheckIfNeeded(this.metadata, true, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String genericType;
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%s = %s.insert(realm, %sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().emitStatement("table.setLink(columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insert(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.addRow(cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).beginControlFlow("if (%1$sItem == null)", new Object[]{fieldName}).emitStatement("%1$sOsList.addNull()", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement(this.getStatementForAppendingValueToOsList(fieldName + "OsList", fieldName + "Item", elementTypeMirror), new Object[0]).endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, false);
        }
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitInsertOrUpdateMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("long", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "object", "Map<RealmModel,Long>", "cache"});
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]).emitStatement("return ((RealmObjectProxy) object).realmGet$proxyState().getRow$realm().getIndex()", new Object[0]).endControlFlow();
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativePtr()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())});
        }
        this.addPrimaryKeyCheckIfNeeded(this.metadata, false, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String genericType;
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%1$s = %2$s.insertOrUpdate(realm, %1$sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("Table.nativeNullifyLink(tableNativePtr, columnInfo.%sIndex, rowIndex)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%1$sList != null && %1$sList.size() == %1$sOsList.size())", new Object[]{fieldName}).emitSingleLineComment("For lists of equal lengths, we need to set each element directly as clearing the receiver list can be wrong if the input and target list are the same.", new Object[0]).emitStatement("int objects = %1$sList.size()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < objects; i++)", new Object[0]).emitStatement("%1$s %2$sItem = %2$sList.get(i)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.setRow(i, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("%1$sOsList.removeAll()", new Object[]{fieldName}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.addRow(cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
                writer.emitEmptyLine().emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).emitStatement("%1$sOsList.removeAll()", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).beginControlFlow("if (%1$sItem == null)", new Object[]{fieldName}).emitStatement("%1$sOsList.addNull()", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement(this.getStatementForAppendingValueToOsList(fieldName + "OsList", fieldName + "Item", elementTypeMirror), new Object[0]).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, true);
        }
        writer.emitStatement("return rowIndex", new Object[0]);
        writer.endMethod().emitEmptyLine();
    }

    private void emitInsertOrUpdateListMethod(JavaWriter writer) throws IOException {
        writer.beginMethod("void", "insertOrUpdate", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", "Iterator<? extends RealmModel>", "objects", "Map<RealmModel,Long>", "cache"});
        writer.emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName});
        writer.emitStatement("long tableNativePtr = table.getNativePtr()", new Object[0]);
        writer.emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName});
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())});
        }
        writer.emitStatement("%s object = null", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("while (objects.hasNext())", new Object[0]);
        writer.emitStatement("object = (%s) objects.next()", new Object[]{this.qualifiedClassName});
        writer.beginControlFlow("if (cache.containsKey(object))", new Object[0]).emitStatement("continue", new Object[0]).endControlFlow();
        writer.beginControlFlow("if (object instanceof RealmObjectProxy && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy) object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath()))", new Object[0]);
        writer.emitStatement("cache.put(object, ((RealmObjectProxy) object).realmGet$proxyState().getRow$realm().getIndex())", new Object[0]).emitStatement("continue", new Object[0]);
        writer.endControlFlow();
        this.addPrimaryKeyCheckIfNeeded(this.metadata, false, writer);
        for (VariableElement field : this.metadata.getFields()) {
            String genericType;
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = ((%s) object).%s()", new Object[]{fieldType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sObj != null)", new Object[]{fieldName}).emitStatement("Long cache%1$s = cache.get(%1$sObj)", new Object[]{fieldName}).beginControlFlow("if (cache%s == null)", new Object[]{fieldName}).emitStatement("cache%1$s = %2$s.insertOrUpdate(realm, %1$sObj, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("Table.nativeSetLink(tableNativePtr, columnInfo.%1$sIndex, rowIndex, cache%1$s, false)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("Table.nativeNullifyLink(tableNativePtr, columnInfo.%sIndex, rowIndex)", new Object[]{fieldName}).endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%1$sList != null && %1$sList.size() == %1$sOsList.size())", new Object[]{fieldName}).emitSingleLineComment("For lists of equal lengths, we need to set each element directly as clearing the receiver list can be wrong if the input and target list are the same.", new Object[0]).emitStatement("int objectCount = %1$sList.size()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < objectCount; i++)", new Object[0]).emitStatement("%1$s %2$sItem = %2$sList.get(i)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.setRow(i, cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("%1$sOsList.removeAll()", new Object[]{fieldName}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).emitStatement("Long cacheItemIndex%1$s = cache.get(%1$sItem)", new Object[]{fieldName}).beginControlFlow("if (cacheItemIndex%s == null)", new Object[]{fieldName}).emitStatement("cacheItemIndex%1$s = %2$s.insertOrUpdate(realm, %1$sItem, cache)", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().emitStatement("%1$sOsList.addRow(cacheItemIndex%1$s)", new Object[]{fieldName}).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                genericType = Utils.getGenericTypeQualifiedName(field);
                TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
                writer.emitEmptyLine().emitStatement("OsList %1$sOsList = new OsList(table.getUncheckedRow(rowIndex), columnInfo.%1$sIndex)", new Object[]{fieldName}).emitStatement("%1$sOsList.removeAll()", new Object[]{fieldName}).emitStatement("RealmList<%s> %sList = ((%s) object).%s()", new Object[]{genericType, fieldName, this.interfaceName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (%1$s %2$sItem : %2$sList)", new Object[]{genericType, fieldName}).beginControlFlow("if (%1$sItem == null)", new Object[]{fieldName}).emitStatement("%1$sOsList.addNull()", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement(this.getStatementForAppendingValueToOsList(fieldName + "OsList", fieldName + "Item", elementTypeMirror), new Object[0]).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (this.metadata.getPrimaryKey() == field) continue;
            this.setTableValues(writer, fieldType, fieldName, this.interfaceName, getter, true);
        }
        writer.endControlFlow();
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void addPrimaryKeyCheckIfNeeded(ClassMetaData metadata, boolean throwIfPrimaryKeyDuplicate, JavaWriter writer) throws IOException {
        if (metadata.hasPrimaryKey()) {
            String primaryKeyGetter = metadata.getPrimaryKeyGetter();
            VariableElement primaryKeyElement = metadata.getPrimaryKey();
            if (metadata.isNullable(primaryKeyElement)) {
                if (Utils.isString(primaryKeyElement)) {
                    writer.emitStatement("String primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]).beginControlFlow("if (primaryKeyValue == null)", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstNull(tableNativePtr, pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstString(tableNativePtr, pkColumnIndex, primaryKeyValue)", new Object[0]).endControlFlow();
                } else {
                    writer.emitStatement("Object primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter}).emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]).beginControlFlow("if (primaryKeyValue == null)", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstNull(tableNativePtr, pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = Table.nativeFindFirstInt(tableNativePtr, pkColumnIndex, ((%s) object).%s())", new Object[]{this.interfaceName, primaryKeyGetter}).endControlFlow();
                }
            } else {
                writer.emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]);
                writer.emitStatement("Object primaryKeyValue = ((%s) object).%s()", new Object[]{this.interfaceName, primaryKeyGetter});
                writer.beginControlFlow("if (primaryKeyValue != null)", new Object[0]);
                if (Utils.isString(metadata.getPrimaryKey())) {
                    writer.emitStatement("rowIndex = Table.nativeFindFirstString(tableNativePtr, pkColumnIndex, (String)primaryKeyValue)", new Object[0]);
                } else {
                    writer.emitStatement("rowIndex = Table.nativeFindFirstInt(tableNativePtr, pkColumnIndex, ((%s) object).%s())", new Object[]{this.interfaceName, primaryKeyGetter});
                }
                writer.endControlFlow();
            }
            writer.beginControlFlow("if (rowIndex == Table.NO_MATCH)", new Object[0]);
            if (Utils.isString(metadata.getPrimaryKey())) {
                writer.emitStatement("rowIndex = OsObject.createRowWithPrimaryKey(table, pkColumnIndex, primaryKeyValue)", new Object[0]);
            } else {
                writer.emitStatement("rowIndex = OsObject.createRowWithPrimaryKey(table, pkColumnIndex, ((%s) object).%s())", new Object[]{this.interfaceName, primaryKeyGetter});
            }
            if (throwIfPrimaryKeyDuplicate) {
                writer.nextControlFlow("else", new Object[0]);
                writer.emitStatement("Table.throwDuplicatePrimaryKeyException(primaryKeyValue)", new Object[0]);
            }
            writer.endControlFlow();
            writer.emitStatement("cache.put(object, rowIndex)", new Object[0]);
        } else {
            writer.emitStatement("long rowIndex = OsObject.createRow(table)", new Object[0]);
            writer.emitStatement("cache.put(object, rowIndex)", new Object[0]);
        }
    }

    private void emitCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "copy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "newObject", "boolean", "update", "Map<RealmModel,RealmObjectProxy>", "cache"});
        writer.emitStatement("RealmObjectProxy cachedRealmObject = cache.get(newObject)", new Object[0]);
        writer.beginControlFlow("if (cachedRealmObject != null)", new Object[0]).emitStatement("return (%s) cachedRealmObject", new Object[]{this.qualifiedClassName}).endControlFlow();
        writer.emitEmptyLine().emitSingleLineComment("rejecting default values to avoid creating unexpected objects from RealmModel/RealmList fields.", new Object[0]);
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("%s realmObject = realm.createObjectInternal(%s.class, ((%s) newObject).%s(), false, Collections.<String>emptyList())", new Object[]{this.qualifiedClassName, this.qualifiedClassName, this.interfaceName, this.metadata.getPrimaryKeyGetter()});
        } else {
            writer.emitStatement("%s realmObject = realm.createObjectInternal(%s.class, false, Collections.<String>emptyList())", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        }
        writer.emitStatement("cache.put(newObject, (RealmObjectProxy) realmObject)", new Object[0]);
        writer.emitEmptyLine().emitStatement("%1$s realmObjectSource = (%1$s) newObject", new Object[]{this.interfaceName}).emitStatement("%1$s realmObjectCopy = (%1$s) realmObject", new Object[]{this.interfaceName});
        writer.emitEmptyLine();
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String setter = this.metadata.getInternalSetter(fieldName);
            String getter = this.metadata.getInternalGetter(fieldName);
            if (this.metadata.isPrimaryKey(field)) continue;
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitStatement("%s %sObj = realmObjectSource.%s()", new Object[]{fieldType, fieldName, getter}).beginControlFlow("if (%sObj == null)", new Object[]{fieldName}).emitStatement("realmObjectCopy.%s(null)", new Object[]{setter}).nextControlFlow("else", new Object[0]).emitStatement("%s cache%s = (%s) cache.get(%sObj)", new Object[]{fieldType, fieldName, fieldType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("realmObjectCopy.%s(cache%s)", new Object[]{setter, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("realmObjectCopy.%s(%s.copyOrUpdate(realm, %sObj, update, cache))", new Object[]{setter, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitEmptyLine().emitStatement("RealmList<%s> %sList = realmObjectSource.%s()", new Object[]{genericType, fieldName, getter}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).emitStatement("RealmList<%s> %sRealmList = realmObjectCopy.%s()", new Object[]{genericType, fieldName, getter}).emitStatement("%sRealmList.clear()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", new Object[]{fieldName}).emitStatement("%1$s %2$sItem = %2$sList.get(i)", new Object[]{genericType, fieldName}).emitStatement("%1$s cache%2$s = (%1$s) cache.get(%2$sItem)", new Object[]{genericType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("%1$sRealmList.add(cache%1$s)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("%1$sRealmList.add(%2$s.copyOrUpdate(realm, %1$sItem, update, cache))", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().endControlFlow().endControlFlow().emitEmptyLine();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                writer.emitStatement("realmObjectCopy.%s(realmObjectSource.%s())", new Object[]{setter, getter});
                continue;
            }
            if (Utils.isMutableRealmInteger(field)) {
                writer.emitEmptyLine().emitStatement("realmObjectCopy.%1$s().set(realmObjectSource.%1$s().get())", new Object[]{getter});
                continue;
            }
            writer.emitStatement("realmObjectCopy.%s(realmObjectSource.%s())", new Object[]{setter, getter});
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitCreateDetachedCopyMethod(JavaWriter writer) throws IOException {
        writer.beginMethod(this.qualifiedClassName, "createDetachedCopy", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), new String[]{this.qualifiedClassName, "realmObject", "int", "currentDepth", "int", "maxDepth", "Map<RealmModel, CacheData<RealmModel>>", "cache"});
        writer.beginControlFlow("if (currentDepth > maxDepth || realmObject == null)", new Object[0]).emitStatement("return null", new Object[0]).endControlFlow().emitStatement("CacheData<RealmModel> cachedObject = cache.get(realmObject)", new Object[0]).emitStatement("%s unmanagedObject", new Object[]{this.qualifiedClassName}).beginControlFlow("if (cachedObject == null)", new Object[0]).emitStatement("unmanagedObject = new %s()", new Object[]{this.qualifiedClassName}).emitStatement("cache.put(realmObject, new RealmObjectProxy.CacheData<RealmModel>(currentDepth, unmanagedObject))", new Object[0]).nextControlFlow("else", new Object[0]).emitSingleLineComment("Reuse cached object or recreate it because it was encountered at a lower depth.", new Object[0]).beginControlFlow("if (currentDepth >= cachedObject.minDepth)", new Object[0]).emitStatement("return (%s) cachedObject.object", new Object[]{this.qualifiedClassName}).endControlFlow().emitStatement("unmanagedObject = (%s) cachedObject.object", new Object[]{this.qualifiedClassName}).emitStatement("cachedObject.minDepth = currentDepth", new Object[0]).endControlFlow();
        writer.emitStatement("%1$s unmanagedCopy = (%1$s) unmanagedObject", new Object[]{this.interfaceName}).emitStatement("%1$s realmSource = (%1$s) realmObject", new Object[]{this.interfaceName});
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getInternalSetter(fieldName);
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", new Object[]{fieldName}).emitStatement("unmanagedCopy.%s(%s.createDetachedCopy(realmSource.%s(), currentDepth + 1, maxDepth, cache))", new Object[]{setter, Utils.getProxyClassSimpleName(field), getter});
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                writer.emitEmptyLine().emitSingleLineComment("Deep copy of %s", new Object[]{fieldName}).beginControlFlow("if (currentDepth == maxDepth)", new Object[0]).emitStatement("unmanagedCopy.%s(null)", new Object[]{setter}).nextControlFlow("else", new Object[0]).emitStatement("RealmList<%s> managed%sList = realmSource.%s()", new Object[]{Utils.getGenericTypeQualifiedName(field), fieldName, getter}).emitStatement("RealmList<%1$s> unmanaged%2$sList = new RealmList<%1$s>()", new Object[]{Utils.getGenericTypeQualifiedName(field), fieldName}).emitStatement("unmanagedCopy.%s(unmanaged%sList)", new Object[]{setter, fieldName}).emitStatement("int nextDepth = currentDepth + 1", new Object[0]).emitStatement("int size = managed%sList.size()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < size; i++)", new Object[0]).emitStatement("%s item = %s.createDetachedCopy(managed%sList.get(i), nextDepth, maxDepth, cache)", new Object[]{Utils.getGenericTypeQualifiedName(field), Utils.getProxyClassSimpleName(field), fieldName}).emitStatement("unmanaged%sList.add(item)", new Object[]{fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                writer.emitEmptyLine().emitStatement("unmanagedCopy.%1$s(new RealmList<%2$s>())", new Object[]{setter, Utils.getGenericTypeQualifiedName(field)}).emitStatement("unmanagedCopy.%1$s().addAll(realmSource.%1$s())", new Object[]{getter});
                continue;
            }
            if (Utils.isMutableRealmInteger(field)) {
                writer.emitStatement("unmanagedCopy.%s().set(realmSource.%s().get())", new Object[]{getter, getter});
                continue;
            }
            writer.emitStatement("unmanagedCopy.%s(realmSource.%s())", new Object[]{setter, getter});
        }
        writer.emitEmptyLine();
        writer.emitStatement("return unmanagedObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitUpdateMethod(JavaWriter writer) throws IOException {
        if (!this.metadata.hasPrimaryKey()) {
            return;
        }
        writer.beginMethod(this.qualifiedClassName, "update", EnumSet.of(Modifier.STATIC), new String[]{"Realm", "realm", this.qualifiedClassName, "realmObject", this.qualifiedClassName, "newObject", "Map<RealmModel, RealmObjectProxy>", "cache"});
        writer.emitStatement("%1$s realmObjectTarget = (%1$s) realmObject", new Object[]{this.interfaceName}).emitStatement("%1$s realmObjectSource = (%1$s) newObject", new Object[]{this.interfaceName});
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String setter = this.metadata.getInternalSetter(fieldName);
            String getter = this.metadata.getInternalGetter(fieldName);
            if (Utils.isRealmModel(field)) {
                writer.emitStatement("%s %sObj = realmObjectSource.%s()", new Object[]{Utils.getFieldTypeQualifiedName(field), fieldName, getter}).beginControlFlow("if (%sObj == null)", new Object[]{fieldName}).emitStatement("realmObjectTarget.%s(null)", new Object[]{setter}).nextControlFlow("else", new Object[0]).emitStatement("%1$s cache%2$s = (%1$s) cache.get(%2$sObj)", new Object[]{Utils.getFieldTypeQualifiedName(field), fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("realmObjectTarget.%s(cache%s)", new Object[]{setter, fieldName}).nextControlFlow("else", new Object[0]).emitStatement("realmObjectTarget.%s(%s.copyOrUpdate(realm, %sObj, true, cache))", new Object[]{setter, Utils.getProxyClassSimpleName(field), fieldName}).endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                String genericType = Utils.getGenericTypeQualifiedName(field);
                writer.emitStatement("RealmList<%s> %sList = realmObjectSource.%s()", new Object[]{genericType, fieldName, getter}).emitStatement("RealmList<%s> %sRealmList = realmObjectTarget.%s()", new Object[]{genericType, fieldName, getter}).beginControlFlow("if (%1$sList != null && %1$sList.size() == %1$sRealmList.size())", new Object[]{fieldName}).emitSingleLineComment("For lists of equal lengths, we need to set each element directly as clearing the receiver list can be wrong if the input and target list are the same.", new Object[0]).emitStatement("int objects = %sList.size()", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < objects; i++)", new Object[0]).emitStatement("%1$s %2$sItem = %2$sList.get(i)", new Object[]{genericType, fieldName}).emitStatement("%1$s cache%2$s = (%1$s) cache.get(%2$sItem)", new Object[]{genericType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("%1$sRealmList.set(i, cache%1$s)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("%1$sRealmList.set(i, %2$s.copyOrUpdate(realm, %1$sItem, true, cache))", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().endControlFlow().nextControlFlow("else", new Object[0]).emitStatement("%sRealmList.clear()", new Object[]{fieldName}).beginControlFlow("if (%sList != null)", new Object[]{fieldName}).beginControlFlow("for (int i = 0; i < %sList.size(); i++)", new Object[]{fieldName}).emitStatement("%1$s %2$sItem = %2$sList.get(i)", new Object[]{genericType, fieldName}).emitStatement("%1$s cache%2$s = (%1$s) cache.get(%2$sItem)", new Object[]{genericType, fieldName}).beginControlFlow("if (cache%s != null)", new Object[]{fieldName}).emitStatement("%1$sRealmList.add(cache%1$s)", new Object[]{fieldName}).nextControlFlow("else", new Object[0]).emitStatement("%1$sRealmList.add(%2$s.copyOrUpdate(realm, %1$sItem, true, cache))", new Object[]{fieldName, Utils.getProxyClassSimpleName(field)}).endControlFlow().endControlFlow().endControlFlow().endControlFlow();
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                writer.emitStatement("realmObjectTarget.%s(realmObjectSource.%s())", new Object[]{setter, getter});
                continue;
            }
            if (Utils.isMutableRealmInteger(field)) {
                writer.emitStatement("realmObjectTarget.%s().set(realmObjectSource.%s().get())", new Object[]{getter, getter});
                continue;
            }
            if (field == this.metadata.getPrimaryKey()) continue;
            writer.emitStatement("realmObjectTarget.%s(realmObjectSource.%s())", new Object[]{setter, getter});
        }
        writer.emitStatement("return realmObject", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void emitToStringMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsToString()) {
            return;
        }
        writer.emitAnnotation("Override");
        writer.emitAnnotation("SuppressWarnings", (Object)"\"ArrayToString\"").beginMethod("String", "toString", EnumSet.of(Modifier.PUBLIC), new String[0]).beginControlFlow("if (!RealmObject.isValid(this))", new Object[0]).emitStatement("return \"Invalid object\"", new Object[0]).endControlFlow();
        writer.emitStatement("StringBuilder stringBuilder = new StringBuilder(\"%s = proxy[\")", new Object[]{this.simpleClassName});
        List<VariableElement> fields = this.metadata.getFields();
        int i = fields.size() - 1;
        for (VariableElement field : fields) {
            String fieldName = field.getSimpleName().toString();
            writer.emitStatement("stringBuilder.append(\"{%s:\")", new Object[]{fieldName});
            if (Utils.isRealmModel(field)) {
                String fieldTypeSimpleName = Utils.getFieldTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(%s() != null ? \"%s\" : \"null\")", new Object[]{this.metadata.getInternalGetter(fieldName), fieldTypeSimpleName});
            } else if (Utils.isRealmList(field)) {
                String genericTypeSimpleName = Utils.getGenericTypeSimpleName(field);
                writer.emitStatement("stringBuilder.append(\"RealmList<%s>[\").append(%s().size()).append(\"]\")", new Object[]{genericTypeSimpleName, this.metadata.getInternalGetter(fieldName)});
            } else if (Utils.isMutableRealmInteger(field)) {
                writer.emitStatement("stringBuilder.append(%s().get())", new Object[]{this.metadata.getInternalGetter(fieldName)});
            } else if (this.metadata.isNullable(field)) {
                writer.emitStatement("stringBuilder.append(%s() != null ? %s() : \"null\")", new Object[]{this.metadata.getInternalGetter(fieldName), this.metadata.getInternalGetter(fieldName)});
            } else {
                writer.emitStatement("stringBuilder.append(%s())", new Object[]{this.metadata.getInternalGetter(fieldName)});
            }
            writer.emitStatement("stringBuilder.append(\"}\")", new Object[0]);
            if (i-- <= 0) continue;
            writer.emitStatement("stringBuilder.append(\",\")", new Object[0]);
        }
        writer.emitStatement("stringBuilder.append(\"]\")", new Object[0]);
        writer.emitStatement("return stringBuilder.toString()", new Object[0]);
        writer.endMethod().emitEmptyLine();
    }

    private void emitHashcodeMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsHashCode()) {
            return;
        }
        writer.emitAnnotation("Override").beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]).emitStatement("String realmName = proxyState.getRealm$realm().getPath()", new Object[0]).emitStatement("String tableName = proxyState.getRow$realm().getTable().getName()", new Object[0]).emitStatement("long rowIndex = proxyState.getRow$realm().getIndex()", new Object[0]).emitEmptyLine().emitStatement("int result = 17", new Object[0]).emitStatement("result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0)", new Object[0]).emitStatement("result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0)", new Object[0]).emitStatement("result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32))", new Object[0]).emitStatement("return result", new Object[0]).endMethod().emitEmptyLine();
    }

    private void emitEqualsMethod(JavaWriter writer) throws IOException {
        if (this.metadata.containsEquals()) {
            return;
        }
        String proxyClassName = Utils.getProxyClassName(this.simpleClassName);
        String otherObjectVarName = "a" + this.simpleClassName;
        writer.emitAnnotation("Override").beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "o"}).emitStatement("if (this == o) return true", new Object[0]).emitStatement("if (o == null || getClass() != o.getClass()) return false", new Object[0]).emitStatement("%s %s = (%s)o", new Object[]{proxyClassName, otherObjectVarName, proxyClassName}).emitEmptyLine().emitStatement("String path = proxyState.getRealm$realm().getPath()", new Object[0]).emitStatement("String otherPath = %s.proxyState.getRealm$realm().getPath()", new Object[]{otherObjectVarName}).emitStatement("if (path != null ? !path.equals(otherPath) : otherPath != null) return false", new Object[0]).emitEmptyLine().emitStatement("String tableName = proxyState.getRow$realm().getTable().getName()", new Object[0]).emitStatement("String otherTableName = %s.proxyState.getRow$realm().getTable().getName()", new Object[]{otherObjectVarName}).emitStatement("if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false", new Object[0]).emitEmptyLine().emitStatement("if (proxyState.getRow$realm().getIndex() != %s.proxyState.getRow$realm().getIndex()) return false", new Object[]{otherObjectVarName}).emitEmptyLine().emitStatement("return true", new Object[0]).endMethod();
    }

    private void emitCreateOrUpdateUsingJsonObject(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.beginMethod(this.qualifiedClassName, "createOrUpdateUsingJsonObject", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JSONObject", "json", "boolean", "update"), Collections.singletonList("JSONException"));
        int modelOrListCount = RealmProxyClassGenerator.countModelOrListFields(this.metadata.getFields());
        if (modelOrListCount == 0) {
            writer.emitStatement("final List<String> excludeFields = Collections.<String> emptyList()", new Object[0]);
        } else {
            writer.emitStatement("final List<String> excludeFields = new ArrayList<String>(%1$d)", new Object[]{modelOrListCount});
        }
        if (!this.metadata.hasPrimaryKey()) {
            this.buildExcludeFieldsList(writer, this.metadata.getFields());
            writer.emitStatement("%s obj = realm.createObjectInternal(%s.class, true, excludeFields)", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        } else {
            String pkType = Utils.isString(this.metadata.getPrimaryKey()) ? "String" : "Long";
            writer.emitStatement("%s obj = null", new Object[]{this.qualifiedClassName}).beginControlFlow("if (update)", new Object[0]).emitStatement("Table table = realm.getTable(%s.class)", new Object[]{this.qualifiedClassName}).emitStatement("%s columnInfo = (%s) realm.getSchema().getColumnInfo(%s.class)", new Object[]{this.columnInfoClassName(), this.columnInfoClassName(), this.qualifiedClassName}).emitStatement("long pkColumnIndex = %s", new Object[]{this.fieldIndexVariableReference(this.metadata.getPrimaryKey())}).emitStatement("long rowIndex = Table.NO_MATCH", new Object[0]);
            if (this.metadata.isNullable(this.metadata.getPrimaryKey())) {
                writer.beginControlFlow("if (json.isNull(\"%s\"))", new Object[]{this.metadata.getPrimaryKey().getSimpleName()}).emitStatement("rowIndex = table.findFirstNull(pkColumnIndex)", new Object[0]).nextControlFlow("else", new Object[0]).emitStatement("rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", new Object[]{pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()}).endControlFlow();
            } else {
                writer.beginControlFlow("if (!json.isNull(\"%s\"))", new Object[]{this.metadata.getPrimaryKey().getSimpleName()}).emitStatement("rowIndex = table.findFirst%s(pkColumnIndex, json.get%s(\"%s\"))", new Object[]{pkType, pkType, this.metadata.getPrimaryKey().getSimpleName()}).endControlFlow();
            }
            writer.beginControlFlow("if (rowIndex != Table.NO_MATCH)", new Object[0]).emitStatement("final BaseRealm.RealmObjectContext objectContext = BaseRealm.objectContext.get()", new Object[0]).beginControlFlow("try", new Object[0]).emitStatement("objectContext.set(realm, table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(%s.class), false, Collections.<String> emptyList())", new Object[]{this.qualifiedClassName}).emitStatement("obj = new %s()", new Object[]{this.qualifiedGeneratedClassName}).nextControlFlow("finally", new Object[0]).emitStatement("objectContext.clear()", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
            writer.beginControlFlow("if (obj == null)", new Object[0]);
            this.buildExcludeFieldsList(writer, this.metadata.getFields());
            String primaryKeyFieldType = this.metadata.getPrimaryKey().asType().toString();
            String primaryKeyFieldName = this.metadata.getPrimaryKey().getSimpleName().toString();
            RealmJsonTypeHelper.emitCreateObjectWithPrimaryKeyValue(this.qualifiedClassName, this.qualifiedGeneratedClassName, primaryKeyFieldType, primaryKeyFieldName, writer);
            writer.endControlFlow();
        }
        writer.emitEmptyLine().emitStatement("final %1$s objProxy = (%1$s) obj", new Object[]{this.interfaceName});
        for (VariableElement field : this.metadata.getFields()) {
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            if (this.metadata.isPrimaryKey(field)) continue;
            if (Utils.isRealmModel(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectWithJsonValue("objProxy", this.metadata.getInternalSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                RealmJsonTypeHelper.emitFillRealmListWithJsonValue("objProxy", this.metadata.getInternalGetter(fieldName), this.metadata.getInternalSetter(fieldName), fieldName, ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                writer.emitStatement("ProxyUtils.setRealmListWithJsonObject(objProxy.%1$s(), json, \"%2$s\")", new Object[]{this.metadata.getInternalGetter(fieldName), fieldName});
                continue;
            }
            if (Utils.isMutableRealmInteger(field)) {
                RealmJsonTypeHelper.emitFillJavaTypeWithJsonValue("objProxy", this.metadata.getInternalGetter(fieldName), fieldName, qualifiedFieldType, writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeWithJsonValue("objProxy", this.metadata.getInternalSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        writer.emitStatement("return obj", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private void buildExcludeFieldsList(JavaWriter writer, Collection<VariableElement> fields) throws IOException {
        for (VariableElement field : fields) {
            if (!Utils.isRealmModel(field) && !Utils.isRealmList(field)) continue;
            String fieldName = field.getSimpleName().toString();
            writer.beginControlFlow("if (json.has(\"%1$s\"))", new Object[]{fieldName}).emitStatement("excludeFields.add(\"%1$s\")", new Object[]{fieldName}).endControlFlow();
        }
    }

    private void emitCreateUsingJsonStream(JavaWriter writer) throws IOException {
        writer.emitAnnotation("SuppressWarnings", (Object)"\"cast\"");
        writer.emitAnnotation("TargetApi", (Object)"Build.VERSION_CODES.HONEYCOMB");
        writer.beginMethod(this.qualifiedClassName, "createUsingJsonStream", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC), Arrays.asList("Realm", "realm", "JsonReader", "reader"), Collections.singletonList("IOException"));
        if (this.metadata.hasPrimaryKey()) {
            writer.emitStatement("boolean jsonHasPrimaryKey = false", new Object[0]);
        }
        writer.emitStatement("final %s obj = new %s()", new Object[]{this.qualifiedClassName, this.qualifiedClassName});
        writer.emitStatement("final %1$s objProxy = (%1$s) obj", new Object[]{this.interfaceName});
        writer.emitStatement("reader.beginObject()", new Object[0]);
        writer.beginControlFlow("while (reader.hasNext())", new Object[0]);
        writer.emitStatement("String name = reader.nextName()", new Object[0]);
        writer.beginControlFlow("if (false)", new Object[0]);
        List<VariableElement> fields = this.metadata.getFields();
        for (VariableElement field : fields) {
            String fieldName = field.getSimpleName().toString();
            String qualifiedFieldType = field.asType().toString();
            writer.nextControlFlow("else if (name.equals(\"%s\"))", new Object[]{fieldName});
            if (Utils.isRealmModel(field)) {
                RealmJsonTypeHelper.emitFillRealmObjectFromStream("objProxy", this.metadata.getInternalSetter(fieldName), fieldName, qualifiedFieldType, Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmModelList(field)) {
                RealmJsonTypeHelper.emitFillRealmListFromStream("objProxy", this.metadata.getInternalGetter(fieldName), this.metadata.getInternalSetter(fieldName), ((DeclaredType)field.asType()).getTypeArguments().get(0).toString(), Utils.getProxyClassSimpleName(field), writer);
                continue;
            }
            if (Utils.isRealmValueList(field)) {
                writer.emitStatement("objProxy.%1$s(ProxyUtils.createRealmListWithJsonStream(%2$s.class, reader))", new Object[]{this.metadata.getInternalSetter(fieldName), Utils.getRealmListType(field)});
                continue;
            }
            if (Utils.isMutableRealmInteger(field)) {
                RealmJsonTypeHelper.emitFillJavaTypeFromStream("objProxy", this.metadata, this.metadata.getInternalGetter(fieldName), fieldName, qualifiedFieldType, writer);
                continue;
            }
            RealmJsonTypeHelper.emitFillJavaTypeFromStream("objProxy", this.metadata, this.metadata.getInternalSetter(fieldName), fieldName, qualifiedFieldType, writer);
        }
        writer.nextControlFlow("else", new Object[0]);
        writer.emitStatement("reader.skipValue()", new Object[0]);
        writer.endControlFlow();
        writer.endControlFlow();
        writer.emitStatement("reader.endObject()", new Object[0]);
        if (this.metadata.hasPrimaryKey()) {
            writer.beginControlFlow("if (!jsonHasPrimaryKey)", new Object[0]).emitStatement("throw new IllegalArgumentException(\"JSON object doesn't have the primary key field '%s'.\")", new Object[]{this.metadata.getPrimaryKey()}).endControlFlow();
        }
        writer.emitStatement("return realm.copyToRealm(obj)", new Object[0]);
        writer.endMethod();
        writer.emitEmptyLine();
    }

    private String columnInfoClassName() {
        return this.simpleClassName + "ColumnInfo";
    }

    private String columnIndexVarName(VariableElement variableElement) {
        return variableElement.getSimpleName().toString() + "Index";
    }

    private String mutableRealmIntegerFieldName(VariableElement variableElement) {
        return variableElement.getSimpleName().toString() + "MutableRealmInteger";
    }

    private String fieldIndexVariableReference(VariableElement variableElement) {
        return "columnInfo." + this.columnIndexVarName(variableElement);
    }

    private static int countModelOrListFields(Collection<VariableElement> fields) {
        int count = 0;
        for (VariableElement f : fields) {
            if (!Utils.isRealmModel(f) && !Utils.isRealmList(f)) continue;
            ++count;
        }
        return count;
    }

    private Constants.RealmFieldType getRealmType(VariableElement field) {
        String fieldTypeCanonicalName = field.asType().toString();
        Constants.RealmFieldType type = Constants.JAVA_TO_REALM_TYPES.get(fieldTypeCanonicalName);
        if (type != null) {
            return type;
        }
        if (Utils.isMutableRealmInteger(field)) {
            return Constants.RealmFieldType.REALM_INTEGER;
        }
        if (Utils.isRealmModel(field)) {
            return Constants.RealmFieldType.OBJECT;
        }
        if (Utils.isRealmModelList(field)) {
            return Constants.RealmFieldType.LIST;
        }
        if (Utils.isRealmValueList(field)) {
            Constants.RealmFieldType fieldType = Utils.getValueListFieldType(field);
            if (fieldType == null) {
                return Constants.RealmFieldType.NOTYPE;
            }
            return fieldType;
        }
        return Constants.RealmFieldType.NOTYPE;
    }

    private Constants.RealmFieldType getRealmTypeChecked(VariableElement field) {
        Constants.RealmFieldType type = this.getRealmType(field);
        if (type == Constants.RealmFieldType.NOTYPE) {
            throw new IllegalStateException("Unsupported type " + field.asType().toString());
        }
        return type;
    }

    static {
        List<String> l = Arrays.asList("android.annotation.TargetApi", "android.os.Build", "android.util.JsonReader", "android.util.JsonToken", "io.realm.exceptions.RealmMigrationNeededException", "io.realm.internal.ColumnInfo", "io.realm.internal.OsList", "io.realm.internal.OsObject", "io.realm.internal.OsSchemaInfo", "io.realm.internal.OsObjectSchemaInfo", "io.realm.internal.Property", "io.realm.ProxyUtils", "io.realm.internal.RealmObjectProxy", "io.realm.internal.Row", "io.realm.internal.Table", "io.realm.internal.android.JsonUtils", "io.realm.log.RealmLog", "java.io.IOException", "java.util.ArrayList", "java.util.Collections", "java.util.List", "java.util.Iterator", "java.util.Date", "java.util.Map", "java.util.HashMap", "org.json.JSONObject", "org.json.JSONException", "org.json.JSONArray");
        IMPORTS = Collections.unmodifiableList(l);
    }

    private static interface CodeEmitter {
        public void emit(JavaWriter var1) throws IOException;
    }
}

