/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import com.squareup.javawriter.JavaWriter;
import io.realm.annotations.Ignore;
import io.realm.processor.Backlink;
import io.realm.processor.ClassMetaData;
import io.realm.processor.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

public class RealmProxyInterfaceGenerator {
    private ProcessingEnvironment processingEnvironment;
    private ClassMetaData metaData;
    private final String className;

    public RealmProxyInterfaceGenerator(ProcessingEnvironment processingEnvironment, ClassMetaData metaData) {
        this.processingEnvironment = processingEnvironment;
        this.metaData = metaData;
        this.className = metaData.getSimpleClassName();
    }

    public void generate() throws IOException {
        String qualifiedGeneratedInterfaceName = String.format(Locale.US, "%s.%s", "io.realm", Utils.getProxyInterfaceName(this.className));
        JavaFileObject sourceFile = this.processingEnvironment.getFiler().createSourceFile(qualifiedGeneratedInterfaceName, new Element[0]);
        JavaWriter writer = new JavaWriter((Writer)new BufferedWriter(sourceFile.openWriter()));
        writer.setIndent("    ");
        writer.emitPackage("io.realm").emitEmptyLine().beginType(qualifiedGeneratedInterfaceName, "interface", EnumSet.of(Modifier.PUBLIC));
        for (VariableElement field : this.metaData.getFields()) {
            if (field.getModifiers().contains((Object)Modifier.STATIC) || field.getAnnotation(Ignore.class) != null) continue;
            String fieldName = field.getSimpleName().toString();
            String fieldTypeCanonicalName = field.asType().toString();
            writer.beginMethod(fieldTypeCanonicalName, this.metaData.getInternalGetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[0]).endMethod();
            if (Utils.isMutableRealmInteger(field)) continue;
            writer.beginMethod("void", this.metaData.getInternalSetter(fieldName), EnumSet.of(Modifier.PUBLIC), new String[]{fieldTypeCanonicalName, "value"}).endMethod();
        }
        for (Backlink backlink : this.metaData.getBacklinkFields()) {
            writer.beginMethod(backlink.getTargetFieldType(), this.metaData.getInternalGetter(backlink.getTargetField()), EnumSet.of(Modifier.PUBLIC), new String[0]).endMethod();
        }
        writer.endType();
        writer.close();
    }
}

