/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.Utils;
import java.util.Date;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class TypeMirrors {
    final TypeMirror STRING_MIRROR;
    final TypeMirror BINARY_MIRROR;
    final TypeMirror BOOLEAN_MIRROR;
    final TypeMirror LONG_MIRROR;
    final TypeMirror INTEGER_MIRROR;
    final TypeMirror SHORT_MIRROR;
    final TypeMirror BYTE_MIRROR;
    final TypeMirror DOUBLE_MIRROR;
    final TypeMirror FLOAT_MIRROR;
    final TypeMirror DATE_MIRROR;
    final TypeMirror PRIMITIVE_LONG_MIRROR;
    final TypeMirror PRIMITIVE_INT_MIRROR;
    final TypeMirror PRIMITIVE_SHORT_MIRROR;
    final TypeMirror PRIMITIVE_BYTE_MIRROR;

    TypeMirrors(ProcessingEnvironment env) {
        Types typeUtils = env.getTypeUtils();
        Elements elementUtils = env.getElementUtils();
        this.STRING_MIRROR = elementUtils.getTypeElement("java.lang.String").asType();
        this.BINARY_MIRROR = typeUtils.getArrayType(typeUtils.getPrimitiveType(TypeKind.BYTE));
        this.BOOLEAN_MIRROR = elementUtils.getTypeElement(Boolean.class.getName()).asType();
        this.LONG_MIRROR = elementUtils.getTypeElement(Long.class.getName()).asType();
        this.INTEGER_MIRROR = elementUtils.getTypeElement(Integer.class.getName()).asType();
        this.SHORT_MIRROR = elementUtils.getTypeElement(Short.class.getName()).asType();
        this.BYTE_MIRROR = elementUtils.getTypeElement(Byte.class.getName()).asType();
        this.DOUBLE_MIRROR = elementUtils.getTypeElement(Double.class.getName()).asType();
        this.FLOAT_MIRROR = elementUtils.getTypeElement(Float.class.getName()).asType();
        this.DATE_MIRROR = elementUtils.getTypeElement(Date.class.getName()).asType();
        this.PRIMITIVE_LONG_MIRROR = typeUtils.getPrimitiveType(TypeKind.LONG);
        this.PRIMITIVE_INT_MIRROR = typeUtils.getPrimitiveType(TypeKind.INT);
        this.PRIMITIVE_SHORT_MIRROR = typeUtils.getPrimitiveType(TypeKind.SHORT);
        this.PRIMITIVE_BYTE_MIRROR = typeUtils.getPrimitiveType(TypeKind.BYTE);
    }

    public static TypeMirror getRealmListElementTypeMirror(VariableElement field) {
        if (!Utils.isRealmList(field)) {
            return null;
        }
        return ((DeclaredType)field.asType()).getTypeArguments().get(0);
    }
}

