/*
 * Decompiled with CFR 0.152.
 */
package io.realm.processor;

import io.realm.processor.Constants;
import io.realm.processor.TypeMirrors;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Utils {
    public static Types typeUtils;
    private static Messager messager;
    private static TypeMirror realmInteger;
    private static DeclaredType realmList;
    private static DeclaredType realmResults;
    private static DeclaredType markerInterface;
    private static TypeMirror realmModel;

    public static void initialize(ProcessingEnvironment env) {
        Elements elementUtils = env.getElementUtils();
        typeUtils = env.getTypeUtils();
        messager = env.getMessager();
        realmInteger = elementUtils.getTypeElement("io.realm.MutableRealmInteger").asType();
        realmList = typeUtils.getDeclaredType(elementUtils.getTypeElement("io.realm.RealmList"), typeUtils.getWildcardType(null, null));
        realmResults = typeUtils.getDeclaredType(env.getElementUtils().getTypeElement("io.realm.RealmResults"), typeUtils.getWildcardType(null, null));
        realmModel = elementUtils.getTypeElement("io.realm.RealmModel").asType();
        markerInterface = typeUtils.getDeclaredType(elementUtils.getTypeElement("io.realm.RealmModel"), new TypeMirror[0]);
    }

    public static boolean isDefaultConstructor(Element constructor) {
        if (constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return ((ExecutableElement)constructor).getParameters().isEmpty();
        }
        return false;
    }

    public static String lowerFirstChar(String input) {
        return input.substring(0, 1).toLowerCase() + input.substring(1);
    }

    public static String getProxyClassSimpleName(VariableElement field) {
        if (typeUtils.isAssignable(field.asType(), realmList)) {
            return Utils.getProxyClassName(Utils.getGenericTypeSimpleName(field));
        }
        return Utils.getProxyClassName(Utils.getFieldTypeSimpleName(field));
    }

    public static String getProxyClassName(String clazz) {
        return clazz + "RealmProxy";
    }

    public static boolean isString(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("String");
    }

    public static boolean isPrimitiveType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals("byte") || typeString.equals("short") || typeString.equals("int") || typeString.equals("long") || typeString.equals("float") || typeString.equals("double") || typeString.equals("boolean") || typeString.equals("char");
    }

    public static boolean isBoxedType(String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException("Argument 'typeString' cannot be null.");
        }
        return typeString.equals(Byte.class.getName()) || typeString.equals(Short.class.getName()) || typeString.equals(Integer.class.getName()) || typeString.equals(Long.class.getName()) || typeString.equals(Float.class.getName()) || typeString.equals(Double.class.getName()) || typeString.equals(Boolean.class.getName());
    }

    public static boolean isPrimitiveType(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return field.asType().getKind().isPrimitive();
    }

    public static boolean isByteArray(VariableElement field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 'field' cannot be null.");
        }
        return Utils.getFieldTypeSimpleName(field).equals("byte[]");
    }

    public static boolean isString(String fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Argument 'fieldType' cannot be null.");
        }
        return String.class.getName().equals(fieldType);
    }

    public static boolean isImplementingMarkerInterface(Element classElement) {
        return typeUtils.isAssignable(classElement.asType(), markerInterface);
    }

    public static boolean isMutableRealmInteger(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmInteger);
    }

    public static boolean isRealmList(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmList);
    }

    public static Constants.RealmFieldType getValueListFieldType(VariableElement field) {
        TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
        return Constants.LIST_ELEMENT_TYPE_TO_REALM_TYPES.get(elementTypeMirror.toString());
    }

    public static boolean isRealmModelList(VariableElement field) {
        TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
        if (elementTypeMirror == null) {
            return false;
        }
        return Utils.isRealmModel(elementTypeMirror);
    }

    public static boolean isRealmValueList(VariableElement field) {
        TypeMirror elementTypeMirror = TypeMirrors.getRealmListElementTypeMirror(field);
        if (elementTypeMirror == null) {
            return false;
        }
        return !Utils.isRealmModel(elementTypeMirror);
    }

    public static boolean isRealmModel(Element field) {
        return Utils.isRealmModel(field.asType());
    }

    public static boolean isRealmModel(TypeMirror type) {
        return typeUtils.isAssignable(type, realmModel);
    }

    public static boolean isRealmResults(VariableElement field) {
        return typeUtils.isAssignable(field.asType(), realmResults);
    }

    public static String getRealmResultsType(VariableElement field) {
        if (!Utils.isRealmResults(field)) {
            return null;
        }
        ReferenceType type = Utils.getGenericTypeForContainer(field);
        if (null == type) {
            return null;
        }
        return type.toString();
    }

    public static String getRealmListType(VariableElement field) {
        if (!Utils.isRealmList(field)) {
            return null;
        }
        ReferenceType type = Utils.getGenericTypeForContainer(field);
        if (null == type) {
            return null;
        }
        return type.toString();
    }

    public static ReferenceType getGenericTypeForContainer(VariableElement field) {
        TypeMirror fieldType = field.asType();
        TypeKind kind = fieldType.getKind();
        if (kind != TypeKind.DECLARED) {
            return null;
        }
        List<? extends TypeMirror> args = ((DeclaredType)fieldType).getTypeArguments();
        if (args.size() <= 0) {
            return null;
        }
        fieldType = args.get(0);
        kind = fieldType.getKind();
        if (kind != TypeKind.DECLARED && kind != TypeKind.ARRAY) {
            return null;
        }
        return (ReferenceType)fieldType;
    }

    public static String getFieldTypeQualifiedName(VariableElement field) {
        return field.asType().toString();
    }

    public static String getFieldTypeSimpleName(VariableElement field) {
        return null == field ? null : Utils.getFieldTypeSimpleName(Utils.getFieldTypeQualifiedName(field));
    }

    public static String getFieldTypeSimpleName(ReferenceType type) {
        return null == type ? null : Utils.getFieldTypeSimpleName(type.toString());
    }

    public static String getFieldTypeSimpleName(String fieldTypeQualifiedName) {
        if (null != fieldTypeQualifiedName && fieldTypeQualifiedName.contains(".")) {
            fieldTypeQualifiedName = fieldTypeQualifiedName.substring(fieldTypeQualifiedName.lastIndexOf(46) + 1);
        }
        return fieldTypeQualifiedName;
    }

    public static String getGenericTypeQualifiedName(VariableElement field) {
        TypeMirror fieldType = field.asType();
        List<? extends TypeMirror> typeArguments = ((DeclaredType)fieldType).getTypeArguments();
        if (typeArguments.size() == 0) {
            return null;
        }
        return typeArguments.get(0).toString();
    }

    public static String getGenericTypeSimpleName(VariableElement field) {
        String genericTypeName = Utils.getGenericTypeQualifiedName(field);
        if (genericTypeName == null) {
            return null;
        }
        if (!genericTypeName.contains(".")) {
            return genericTypeName;
        }
        return genericTypeName.substring(genericTypeName.lastIndexOf(46) + 1);
    }

    public static String stripPackage(String fullyQualifiedClassName) {
        String[] parts = fullyQualifiedClassName.split("\\.");
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return fullyQualifiedClassName;
    }

    public static void error(String message, Element element) {
        messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public static void error(String message) {
        messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    public static void note(String message) {
        messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public static Element getSuperClass(TypeElement classType) {
        return typeUtils.asElement(classType.getSuperclass());
    }

    public static String getProxyInterfaceName(String className) {
        return className + "RealmProxyInterface";
    }
}

