/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import io.realm.transformer.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;

public class ComputerIdentifierGenerator {
    private static final String UNKNOWN = "unknown";
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static String get() {
        try {
            if (ComputerIdentifierGenerator.isWindows()) {
                return ComputerIdentifierGenerator.getWindowsIdentifier();
            }
            if (ComputerIdentifierGenerator.isMac()) {
                return ComputerIdentifierGenerator.getMacOsIdentifier();
            }
            if (ComputerIdentifierGenerator.isLinux()) {
                return ComputerIdentifierGenerator.getLinuxMacAddress();
            }
            return UNKNOWN;
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    private static boolean isWindows() {
        return OS.contains("win");
    }

    private static boolean isMac() {
        return OS.contains("mac");
    }

    private static boolean isLinux() {
        return OS.contains("inux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLinuxMacAddress() throws FileNotFoundException, NoSuchAlgorithmException {
        File machineId = new File("/var/lib/dbus/machine-id");
        if (!machineId.exists()) {
            machineId = new File("/etc/machine-id");
        }
        if (!machineId.exists()) {
            return UNKNOWN;
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(machineId);
            String id = scanner.useDelimiter("\\A").next();
            String string = Utils.hexStringify(Utils.sha256Hash(id.getBytes()));
            return string;
        }
    }

    private static String getMacOsIdentifier() throws SocketException, NoSuchAlgorithmException {
        NetworkInterface networkInterface = NetworkInterface.getByName("en0");
        byte[] hardwareAddress = networkInterface.getHardwareAddress();
        return Utils.hexStringify(Utils.sha256Hash(hardwareAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWindowsIdentifier() throws IOException, NoSuchAlgorithmException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(new String[]{"wmic", "csproduct", "get", "UUID"});
        String result = null;
        InputStream is = process.getInputStream();
        Scanner sc = new Scanner(process.getInputStream());
        try {
            while (sc.hasNext()) {
                String next = sc.next();
                if (!next.contains("UUID")) continue;
                result = sc.next().trim();
                break;
            }
        }
        finally {
            is.close();
        }
        return result == null ? UNKNOWN : Utils.hexStringify(Utils.sha256Hash(result.getBytes()));
    }
}

