/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import io.realm.gradle.RealmPluginExtension;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.gradle.api.Project;

public class Utils {
    public static String base64Encode(String data) throws UnsupportedEncodingException {
        return DatatypeConverter.printBase64Binary((byte[])data.getBytes("UTF-8"));
    }

    public static byte[] sha256Hash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        return messageDigest.digest(data);
    }

    public static String hexStringify(byte[] data) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte singleByte : data) {
            stringBuilder.append(Integer.toString((singleByte & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }

    public static boolean isSyncEnabled(Project project) {
        RealmPluginExtension realmExtension = (RealmPluginExtension)project.getExtensions().findByName("realm");
        return realmExtension != null && realmExtension.isSyncEnabled();
    }
}

