/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Ipv4RangeAggregation
extends BucketAggregation {
    public static final String TYPE = "ip_range";
    private List<IpRange> ranges = new LinkedList<IpRange>();

    public Ipv4RangeAggregation(String name, JsonObject ipv4RangeAggregation) {
        super(name, ipv4RangeAggregation);
        if (ipv4RangeAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(ipv4RangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketv : bucketsSource) {
            JsonObject bucket;
            IpRange range = new IpRange(bucket, (bucket = bucketv.getAsJsonObject()).has(String.valueOf((Object)AggregationField.FROM)) ? bucket.get(String.valueOf((Object)AggregationField.FROM)).getAsString() : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? bucket.get(String.valueOf((Object)AggregationField.TO)).getAsString() : null, bucket.has(String.valueOf((Object)AggregationField.KEY)) ? bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsString() : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong());
            this.ranges.add(range);
        }
    }

    public List<IpRange> getBuckets() {
        return this.ranges;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Ipv4RangeAggregation rhs = (Ipv4RangeAggregation)obj;
        return super.equals(obj) && Objects.equals(this.ranges, rhs.ranges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges);
    }

    public class IpRange
    extends Bucket {
        private String from;
        private String to;
        private String key;

        public IpRange(JsonObject bucket, String from, String to, String key, Long count) {
            super(bucket, count);
            this.from = "";
            this.to = "";
            this.key = "";
            this.from = from;
            this.to = to;
            this.key = key;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpRange rhs = (IpRange)o;
            return Objects.equals(this.count, rhs.count) && Objects.equals(this.from, rhs.from) && Objects.equals(this.to, rhs.to) && Objects.equals(this.key, rhs.key);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.count, this.from, this.to, this.key);
        }
    }
}

