/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.brpc;

import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import io.seata.core.context.RootContext;
import io.seata.integration.rpc.core.ProviderRpcFilter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionPropagationServerInterceptor
extends AbstractInterceptor
implements ProviderRpcFilter<Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionPropagationServerInterceptor.class);

    public boolean handleRequest(Request request) {
        Map rpcContexts = this.getRpcContexts(request);
        String xid = RootContext.getXID();
        String rpcXid = this.getXidFromContexts(rpcContexts);
        if (null == xid && null != rpcXid) {
            this.bindRequestToContexts(rpcContexts);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SEATA-BRPC bind {} to RootContext", (Object)this.getJsonContext(rpcContexts));
            }
        }
        return super.handleRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundProcess(Request brpcRequest, Response brpcResponse, InterceptorChain chain) throws Exception {
        try {
            chain.intercept(brpcRequest, brpcResponse);
        }
        finally {
            Map rootContexts = this.cleanRootContexts();
            Map rpcContexts = this.getRpcContexts(brpcRequest);
            String rpcXid = this.getXidFromContexts(rpcContexts);
            String xid = this.getXidFromContexts(rootContexts);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SEATA-BRPC unbind {} from RootContext", (Object)this.getJsonContext(rootContexts));
            }
            if (null != rpcXid && !rpcXid.equalsIgnoreCase(xid)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("SEATA-BRPC context changed during RPC from {} to {},will be reset.", (Object)this.getJsonContext(rpcContexts), (Object)this.getJsonContext(rootContexts));
                }
                this.resetRootContexts(rootContexts);
            }
        }
    }

    @Override
    public String getRpcContext(Request rpcContext, String key) {
        if (null == rpcContext.getKvAttachment()) {
            return null;
        }
        Object value = rpcContext.getKvAttachment().get(key);
        return value == null ? null : value.toString();
    }
}

