/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.proctrl.process.impl;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.proctrl.handler.ProcessHandler;
import io.seata.saga.proctrl.handler.RouterHandler;
import io.seata.saga.proctrl.process.BusinessProcessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeBusinessProcessor
implements BusinessProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomizeBusinessProcessor.class);
    private Map<String, ProcessHandler> processHandlers;
    private Map<String, RouterHandler> routerHandlers;

    public static ProcessType matchProcessType(ProcessContext context) {
        ProcessType processType = (ProcessType)((Object)context.getVariable("_ProcessType_"));
        if (processType == null) {
            processType = ProcessType.STATE_LANG;
        }
        return processType;
    }

    @Override
    public void process(ProcessContext context) throws FrameworkException {
        ProcessType processType = CustomizeBusinessProcessor.matchProcessType(context);
        if (processType == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Process type not found, context= {}", (Object)context);
            }
            throw new FrameworkException(FrameworkErrorCode.ProcessTypeNotFound);
        }
        ProcessHandler processor = this.processHandlers.get(processType.getCode());
        if (processor == null) {
            LOGGER.error("Cannot find process handler by type {}, context= {}", (Object)processType.getCode(), (Object)context);
            throw new FrameworkException(FrameworkErrorCode.ProcessHandlerNotFound);
        }
        processor.process(context);
    }

    @Override
    public void route(ProcessContext context) throws FrameworkException {
        ProcessType processType = CustomizeBusinessProcessor.matchProcessType(context);
        if (processType == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Process type not found, the process is no longer advanced, context= {}", (Object)context);
            }
            return;
        }
        RouterHandler router = this.routerHandlers.get(processType.getCode());
        if (router == null) {
            LOGGER.error("Cannot find router handler by type {}, context= {}", (Object)processType.getCode(), (Object)context);
            return;
        }
        router.route(context);
    }

    public void setProcessHandlers(Map<String, ProcessHandler> processHandlers) {
        this.processHandlers = processHandlers;
    }

    public void setRouterHandlers(Map<String, RouterHandler> routerHandlers) {
        this.routerHandlers = routerHandlers;
    }
}

