/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.validator.impl;

import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.parser.utils.StateMachineUtils;
import io.seata.saga.statelang.validator.impl.AbstractRule;
import java.util.Set;

public class StateNameExistsRule
extends AbstractRule {
    @Override
    public boolean validate(StateMachine stateMachine) {
        for (State state : stateMachine.getStates().values()) {
            Set<String> subsequentStates = StateMachineUtils.getAllPossibleSubsequentStates(state);
            for (String subsequentState : subsequentStates) {
                if (stateMachine.getState(subsequentState) != null) continue;
                this.hint = String.format("Subsequent state [%s] of [%s] does not exist", subsequentState, state);
                return false;
            }
        }
        return true;
    }
}

