/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigType;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationProvider;
import io.seata.config.FileConfiguration;
import java.util.Objects;

public final class ConfigurationFactory {
    private static final String REGISTRY_CONF = "registry.conf";
    private static final String REGISTRY_CONF_PREFIX = "registry";
    private static final String REGISTRY_CONF_SUFFIX = ".conf";
    private static final String ENV_SYSTEM_KEY = "SEATA_CONFIG_ENV";
    private static final String ENV_PROPERTY_KEY = "env";
    private static final String DEFAULT_ENV_VALUE = "default";
    private static String ENV_VALUE;
    private static final Configuration DEFAULT_FILE_INSTANCE;
    public static final Configuration CURRENT_FILE_INSTANCE;
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";
    private static volatile Configuration CONFIG_INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (CONFIG_INSTANCE != null) return CONFIG_INSTANCE;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (CONFIG_INSTANCE != null) return CONFIG_INSTANCE;
            CONFIG_INSTANCE = ConfigurationFactory.buildConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONFIG_INSTANCE;
        }
    }

    private static Configuration buildConfiguration() {
        ConfigType configType = null;
        String configTypeName = null;
        try {
            configTypeName = CURRENT_FILE_INSTANCE.getConfig("config.type");
            configType = ConfigType.getType(configTypeName);
        }
        catch (Exception e) {
            throw new NotSupportYetException("not support register type: " + configTypeName, (Throwable)e);
        }
        if (ConfigType.File == configType) {
            String pathDataId = "config.file.name";
            String name = CURRENT_FILE_INSTANCE.getConfig(pathDataId);
            return new FileConfiguration(name);
        }
        return ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)Objects.requireNonNull(configType).name())).provide();
    }

    static {
        String env = System.getenv(ENV_SYSTEM_KEY);
        if (env != null && System.getProperty(ENV_PROPERTY_KEY) == null) {
            System.setProperty(ENV_PROPERTY_KEY, env);
        }
        ENV_VALUE = System.getProperty(ENV_PROPERTY_KEY);
        DEFAULT_FILE_INSTANCE = new FileConfiguration(REGISTRY_CONF);
        CURRENT_FILE_INSTANCE = ENV_VALUE == null || DEFAULT_ENV_VALUE.equals(ENV_VALUE) ? DEFAULT_FILE_INSTANCE : new FileConfiguration("registry-" + ENV_VALUE + REGISTRY_CONF_SUFFIX);
        CONFIG_INSTANCE = null;
    }
}

