/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.netty.util.internal.ConcurrentSet;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConfiguration.class);
    private Config fileConfig;
    private ExecutorService configOperateExecutor;
    private static final int CORE_CONFIG_OPERATE_THREAD = 1;
    private static final int MAX_CONFIG_OPERATE_THREAD = 2;
    private static final long LISTENER_CONFIG_INTERNAL = 1000L;
    private static final String REGISTRY_TYPE = "file";
    private static final String SYS_FILE_RESOURCE_PREFIX = "file:";
    private final ConcurrentMap<String, Set<ConfigurationChangeListener>> configListenersMap = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
    private final Map<String, String> listenedConfigMap = new HashMap<String, String>(8);
    private final String targetFilePath;
    private volatile long targetFileLastModified;
    private final String name;
    private final boolean allowDynamicRefresh;

    public FileConfiguration() {
        this.name = null;
        this.targetFilePath = null;
        this.allowDynamicRefresh = false;
    }

    public FileConfiguration(String name) {
        this(name, true);
    }

    public FileConfiguration(String name, boolean allowDynamicRefresh) {
        LOGGER.info("The file name of the operation is {}", (Object)name);
        if (null == name) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (name.startsWith(SYS_FILE_RESOURCE_PREFIX)) {
            File targetFile = new File(name.substring(SYS_FILE_RESOURCE_PREFIX.length()));
            if (targetFile.exists()) {
                this.targetFilePath = targetFile.getPath();
                Config appConfig = ConfigFactory.parseFileAnySyntax((File)targetFile);
                this.fileConfig = ConfigFactory.load((Config)appConfig);
            } else {
                this.targetFilePath = null;
            }
        } else {
            URL resource = this.getClass().getClassLoader().getResource(name);
            if (null != resource) {
                this.targetFilePath = resource.getPath();
                this.fileConfig = ConfigFactory.load((String)name);
            } else {
                this.targetFilePath = null;
            }
        }
        if (null == this.targetFilePath) {
            this.fileConfig = ConfigFactory.load();
            this.allowDynamicRefresh = false;
        } else {
            this.targetFileLastModified = new File(this.targetFilePath).lastModified();
            this.allowDynamicRefresh = allowDynamicRefresh;
        }
        this.name = name;
        this.configOperateExecutor = new ThreadPoolExecutor(1, 2, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("configOperate", 2));
    }

    @Override
    public String getConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (String)configFuture.get();
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.configOperateExecutor.submit(new ConfigOperateRunnable(configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (null == dataId || null == listener) {
            return;
        }
        this.configListenersMap.putIfAbsent(dataId, (Set<ConfigurationChangeListener>)new ConcurrentSet());
        ((Set)this.configListenersMap.get(dataId)).add(listener);
        this.listenedConfigMap.put(dataId, this.getConfig(dataId));
        FileListener fileListener = new FileListener(dataId, listener);
        fileListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (dataId == null || configChangeListeners == null) {
            return;
        }
        if (this.configListenersMap.containsKey(dataId)) {
            ((Set)this.configListenersMap.get(dataId)).remove(listener);
            if (((Set)this.configListenersMap.get(dataId)).isEmpty()) {
                this.configListenersMap.remove(dataId);
                this.listenedConfigMap.remove(dataId);
            }
        }
        listener.onShutDown();
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)this.configListenersMap.get(dataId);
    }

    @Override
    public String getTypeName() {
        return REGISTRY_TYPE;
    }

    class FileListener
    implements ConfigurationChangeListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fileListener", 1));

        public FileListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        @Override
        public void onChangeEvent(ConfigurationChangeEvent event) {
            while (true) {
                try {
                    while (true) {
                        String oldConfig;
                        String currentConfig;
                        if (ObjectUtils.notEqual((Object)(currentConfig = FileConfiguration.this.getConfig(this.dataId)), (Object)(oldConfig = (String)FileConfiguration.this.listenedConfigMap.get(this.dataId)))) {
                            FileConfiguration.this.listenedConfigMap.put(this.dataId, currentConfig);
                            event.setDataId(this.dataId).setNewValue(currentConfig).setOldValue(oldConfig);
                            this.listener.onChangeEvent(event);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exx) {
                    LOGGER.error("fileListener execute error:{}", (Object)exx.getMessage(), (Object)exx);
                    continue;
                }
                break;
            }
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executor;
        }
    }

    class ConfigOperateRunnable
    implements Runnable {
        private ConfigFuture configFuture;

        public ConfigOperateRunnable(ConfigFuture configFuture) {
            this.configFuture = configFuture;
        }

        @Override
        public void run() {
            if (null != this.configFuture) {
                if (this.configFuture.isTimeout()) {
                    this.setFailResult(this.configFuture);
                    return;
                }
                try {
                    long tempLastModified;
                    if (FileConfiguration.this.allowDynamicRefresh && (tempLastModified = new File(FileConfiguration.this.targetFilePath).lastModified()) > FileConfiguration.this.targetFileLastModified) {
                        Config tempConfig;
                        if (FileConfiguration.this.name.startsWith(FileConfiguration.SYS_FILE_RESOURCE_PREFIX)) {
                            Config appConfig = ConfigFactory.parseFileAnySyntax((File)new File(FileConfiguration.this.targetFilePath));
                            tempConfig = ConfigFactory.load((Config)appConfig);
                        } else {
                            tempConfig = ConfigFactory.load((String)FileConfiguration.this.name);
                        }
                        if (null != tempConfig) {
                            FileConfiguration.this.fileConfig = tempConfig;
                            FileConfiguration.this.targetFileLastModified = tempLastModified;
                        }
                    }
                    if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                        String result = FileConfiguration.this.fileConfig.getString(this.configFuture.getDataId());
                        this.configFuture.setResult(result);
                    } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUT) {
                        this.configFuture.setResult(Boolean.TRUE);
                    } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.PUTIFABSENT) {
                        this.configFuture.setResult(Boolean.TRUE);
                    } else if (this.configFuture.getOperation() == ConfigFuture.ConfigOperation.REMOVE) {
                        this.configFuture.setResult(Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    this.setFailResult(this.configFuture);
                    LOGGER.warn("Could not found property {}, try to use default value instead.", (Object)this.configFuture.getDataId());
                }
            }
        }

        private void setFailResult(ConfigFuture configFuture) {
            if (configFuture.getOperation() == ConfigFuture.ConfigOperation.GET) {
                String result = configFuture.getContent();
                configFuture.setResult(result);
            } else {
                configFuture.setResult(Boolean.FALSE);
            }
        }
    }
}

