/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.exception.NotSupportYetException;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.sql.struct.TableMetaCache;
import io.seata.rm.datasource.sql.struct.cache.MysqlTableMetaCache;
import io.seata.rm.datasource.sql.struct.cache.OracleTableMetaCache;

public class TableMetaCacheFactory {
    private TableMetaCacheFactory() {
    }

    public static TableMetaCache getTableMetaCache(DataSourceProxy dataSourceProxy) {
        return TableMetaCacheFactory.getTableMetaCache(dataSourceProxy.getDbType());
    }

    public static TableMetaCache getTableMetaCache(String dbType) {
        if (dbType.equals("mysql")) {
            return MysqlTableMetaCache.getInstance();
        }
        if (dbType.equals("oracle")) {
            return OracleTableMetaCache.getInstance();
        }
        throw new NotSupportYetException("not support dbType[" + dbType + "]");
    }
}

