/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.spring.namespace.parser;

import com.google.common.base.Strings;
import io.shardingsphere.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.shardingjdbc.orchestration.spring.datasource.OrchestrationSpringMasterSlaveDataSource;
import io.shardingsphere.shardingjdbc.orchestration.spring.datasource.OrchestrationSpringShardingDataSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public final class DataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = "sharding-data-source".equals(element.getLocalName()) ? BeanDefinitionBuilder.rootBeanDefinition(OrchestrationSpringShardingDataSource.class) : BeanDefinitionBuilder.rootBeanDefinition(OrchestrationSpringMasterSlaveDataSource.class);
        this.configureFactory(element, factory);
        return factory.getBeanDefinition();
    }

    private void configureFactory(Element element, BeanDefinitionBuilder factory) {
        String dataSourceName = element.getAttribute("data-source-ref");
        if (!Strings.isNullOrEmpty((String)dataSourceName)) {
            factory.addConstructorArgReference(dataSourceName);
        }
        factory.addConstructorArgValue((Object)this.getOrchestrationConfiguration(element));
    }

    private BeanDefinition getOrchestrationConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(OrchestrationConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        factory.addConstructorArgReference(element.getAttribute("registry-center-ref"));
        factory.addConstructorArgValue((Object)element.getAttribute("overwrite"));
        return factory.getBeanDefinition();
    }
}

