/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.shardingsphere.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.api.config.rule.TableRuleConfiguration;
import io.shardingsphere.shardingjdbc.spring.datasource.SpringShardingDataSource;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class ShardingDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringShardingDataSource.class);
        factory.addConstructorArgValue(this.parseDataSources(element));
        factory.addConstructorArgValue((Object)this.parseShardingRuleConfig(element));
        factory.addConstructorArgValue((Object)this.parseConfigMap(element, parserContext, (BeanDefinition)factory.getBeanDefinition()));
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseDataSources(Element element) {
        Element shardingRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"sharding-rule");
        List dataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)shardingRuleElement.getAttribute("data-source-names"));
        ManagedMap result = new ManagedMap(dataSources.size());
        for (String each : dataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        return result;
    }

    private BeanDefinition parseShardingRuleConfig(Element element) {
        Element shardingRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"sharding-rule");
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ShardingRuleConfiguration.class);
        this.parseDefaultDataSource(factory, shardingRuleElement);
        this.parseDefaultDatabaseShardingStrategy(factory, shardingRuleElement);
        this.parseDefaultTableShardingStrategy(factory, shardingRuleElement);
        factory.addPropertyValue("tableRuleConfigs", this.parseTableRulesConfig(shardingRuleElement));
        factory.addPropertyValue("masterSlaveRuleConfigs", this.parseMasterSlaveRulesConfig(shardingRuleElement));
        factory.addPropertyValue("bindingTableGroups", this.parseBindingTablesConfig(shardingRuleElement));
        factory.addPropertyValue("broadcastTables", this.parseBroadcastTables(shardingRuleElement));
        this.parseKeyGenerator(factory, shardingRuleElement);
        return factory.getBeanDefinition();
    }

    private void parseKeyGenerator(BeanDefinitionBuilder factory, Element element) {
        String defaultKeyGenerator = element.getAttribute("default-key-generator-ref");
        if (!Strings.isNullOrEmpty((String)defaultKeyGenerator)) {
            factory.addPropertyReference("defaultKeyGenerator", defaultKeyGenerator);
        }
    }

    private void parseDefaultDataSource(BeanDefinitionBuilder factory, Element element) {
        String defaultDataSource = element.getAttribute("default-data-source-name");
        if (!Strings.isNullOrEmpty((String)defaultDataSource)) {
            factory.addPropertyValue("defaultDataSourceName", (Object)defaultDataSource);
        }
    }

    private void parseDefaultDatabaseShardingStrategy(BeanDefinitionBuilder factory, Element element) {
        String defaultDatabaseShardingStrategy = element.getAttribute("default-database-strategy-ref");
        if (!Strings.isNullOrEmpty((String)defaultDatabaseShardingStrategy)) {
            factory.addPropertyReference("defaultDatabaseShardingStrategyConfig", defaultDatabaseShardingStrategy);
        }
    }

    private void parseDefaultTableShardingStrategy(BeanDefinitionBuilder factory, Element element) {
        String defaultTableShardingStrategy = element.getAttribute("default-table-strategy-ref");
        if (!Strings.isNullOrEmpty((String)defaultTableShardingStrategy)) {
            factory.addPropertyReference("defaultTableShardingStrategyConfig", defaultTableShardingStrategy);
        }
    }

    private List<BeanDefinition> parseMasterSlaveRulesConfig(Element element) {
        Element masterSlaveRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"master-slave-rules");
        if (null == masterSlaveRulesElement) {
            return new LinkedList<BeanDefinition>();
        }
        List masterSlaveRuleElements = DomUtils.getChildElementsByTagName((Element)masterSlaveRulesElement, (String)"master-slave-rule");
        ManagedList result = new ManagedList(masterSlaveRuleElements.size());
        for (Element each : masterSlaveRuleElements) {
            result.add(this.parseMasterSlaveRuleConfig(each));
        }
        return result;
    }

    private BeanDefinition parseMasterSlaveRuleConfig(Element masterSlaveElement) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(MasterSlaveRuleConfiguration.class);
        factory.addPropertyValue("name", (Object)masterSlaveElement.getAttribute("id"));
        factory.addPropertyValue("masterDataSourceName", (Object)masterSlaveElement.getAttribute("master-data-source-name"));
        factory.addPropertyValue("slaveDataSourceNames", this.parseSlaveDataSourcesRef(masterSlaveElement));
        String strategyRef = masterSlaveElement.getAttribute("strategy-ref");
        if (!Strings.isNullOrEmpty((String)strategyRef)) {
            factory.addPropertyReference("loadBalanceAlgorithm", strategyRef);
        } else {
            factory.addPropertyValue("loadBalanceAlgorithm", (Object)this.parseStrategyType(masterSlaveElement).getAlgorithm());
        }
        return factory.getBeanDefinition();
    }

    private MasterSlaveLoadBalanceAlgorithmType parseStrategyType(Element element) {
        String result = element.getAttribute("strategy-type");
        return Strings.isNullOrEmpty((String)result) ? MasterSlaveLoadBalanceAlgorithmType.getDefaultAlgorithmType() : MasterSlaveLoadBalanceAlgorithmType.valueOf((String)result);
    }

    private Collection<String> parseSlaveDataSourcesRef(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedList result = new ManagedList(slaveDataSources.size());
        result.addAll(slaveDataSources);
        return result;
    }

    private List<BeanDefinition> parseTableRulesConfig(Element element) {
        Element tableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"table-rules");
        List tableRuleElements = DomUtils.getChildElementsByTagName((Element)tableRulesElement, (String)"table-rule");
        ManagedList result = new ManagedList(tableRuleElements.size());
        for (Element each : tableRuleElements) {
            result.add(this.parseTableRuleConfig(each));
        }
        return result;
    }

    private BeanDefinition parseTableRuleConfig(Element tableElement) {
        String logicIndex;
        String keyGenerator;
        String keyGeneratorColumnName;
        String tableStrategy;
        String databaseStrategy;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(TableRuleConfiguration.class);
        factory.addPropertyValue("logicTable", (Object)tableElement.getAttribute("logic-table"));
        String actualDataNodes = tableElement.getAttribute("actual-data-nodes");
        if (!Strings.isNullOrEmpty((String)actualDataNodes)) {
            factory.addPropertyValue("actualDataNodes", (Object)actualDataNodes);
        }
        if (!Strings.isNullOrEmpty((String)(databaseStrategy = tableElement.getAttribute("database-strategy-ref")))) {
            factory.addPropertyReference("databaseShardingStrategyConfig", databaseStrategy);
        }
        if (!Strings.isNullOrEmpty((String)(tableStrategy = tableElement.getAttribute("table-strategy-ref")))) {
            factory.addPropertyReference("tableShardingStrategyConfig", tableStrategy);
        }
        if (!Strings.isNullOrEmpty((String)(keyGeneratorColumnName = tableElement.getAttribute("generate-key-column-name")))) {
            factory.addPropertyValue("keyGeneratorColumnName", (Object)keyGeneratorColumnName);
        }
        if (!Strings.isNullOrEmpty((String)(keyGenerator = tableElement.getAttribute("key-generator-ref")))) {
            factory.addPropertyReference("keyGenerator", keyGenerator);
        }
        if (!Strings.isNullOrEmpty((String)(logicIndex = tableElement.getAttribute("logic-index")))) {
            factory.addPropertyValue("logicIndex", (Object)logicIndex);
        }
        return factory.getBeanDefinition();
    }

    private List<String> parseBindingTablesConfig(Element element) {
        Element bindingTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"binding-table-rules");
        if (null == bindingTableRulesElement) {
            return Collections.emptyList();
        }
        List bindingTableRuleElements = DomUtils.getChildElementsByTagName((Element)bindingTableRulesElement, (String)"binding-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : bindingTableRuleElements) {
            result.add(each.getAttribute("logic-tables"));
        }
        return result;
    }

    private List<String> parseBroadcastTables(Element element) {
        Element broadcastTableRulesElement = DomUtils.getChildElementByTagName((Element)element, (String)"broadcast-table-rules");
        if (null == broadcastTableRulesElement) {
            return Collections.emptyList();
        }
        List broadcastTableRuleElements = DomUtils.getChildElementsByTagName((Element)broadcastTableRulesElement, (String)"broadcast-table-rule");
        LinkedList<String> result = new LinkedList<String>();
        for (Element each : broadcastTableRuleElements) {
            result.add(each.getAttribute("table"));
        }
        return result;
    }

    private Map parseConfigMap(Element element, ParserContext parserContext, BeanDefinition beanDefinition) {
        Element dataElement = DomUtils.getChildElementByTagName((Element)element, (String)"config-map");
        return null == dataElement ? Collections.emptyMap() : parserContext.getDelegate().parseMapElement(dataElement, beanDefinition);
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

