/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.ExpressionModel;
import java.util.List;

public class AsyncResultModel
extends ExpressionModel {
    final String name;
    final TypeInfo type;

    public AsyncResultModel(CodeBuilder builder, String name, TypeInfo type) {
        super(builder);
        this.name = name;
        this.type = type;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumenTypes) {
        switch (method.getName()) {
            case "succeeded": {
                return new Succeeded(this.builder);
            }
            case "failed": {
                return new Failed(this.builder);
            }
            case "cause": {
                return new Cause(this.builder);
            }
            case "result": {
                return new Value(this.builder).as(this.type);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void render(CodeWriter writer) {
        throw new UnsupportedOperationException("It is not be possible to render an async result directly");
    }

    public class Cause
    extends ExpressionModel {
        public Cause(CodeBuilder builder) {
            super(builder);
        }

        @Override
        public void render(CodeWriter writer) {
            writer.renderAsyncResultCause(AsyncResultModel.this.name);
        }
    }

    public class Value
    extends ExpressionModel {
        public Value(CodeBuilder builder) {
            super(builder);
        }

        @Override
        public void render(CodeWriter writer) {
            writer.renderAsyncResultValue(AsyncResultModel.this.name);
        }
    }

    public class Failed
    extends ExpressionModel {
        public Failed(CodeBuilder builder) {
            super(builder);
        }

        @Override
        public void render(CodeWriter writer) {
            writer.renderAsyncResultFailed(AsyncResultModel.this.name);
        }
    }

    public class Succeeded
    extends ExpressionModel {
        public Succeeded(CodeBuilder builder) {
            super(builder);
        }

        @Override
        public void render(CodeWriter writer) {
            writer.renderAsyncResultSucceeded(AsyncResultModel.this.name);
        }
    }
}

