/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.ruby;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.FragmentParser;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.LambdaExpressionModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.expression.ThisModel;
import io.vertx.codetrans.expression.VariableScope;
import io.vertx.codetrans.lang.ruby.RubyCodeBuilder;
import io.vertx.codetrans.statement.ConditionalBlockModel;
import io.vertx.codetrans.statement.StatementModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class RubyWriter
extends CodeWriter {
    final RubyCodeBuilder builder;

    RubyWriter(RubyCodeBuilder builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    public void renderEquals(ExpressionModel expression, ExpressionModel arg) {
        expression.render(this);
        this.append(".==(");
        arg.render(this);
        this.append(")");
    }

    public void renderStringLiteral(List parts) {
        this.append('\"');
        for (Object part : parts) {
            if (part instanceof ExpressionModel) {
                this.append("#{");
                ExpressionModel ex = (ExpressionModel)part;
                ex.render(this);
                this.append("}");
                continue;
            }
            this.renderChars(part.toString());
        }
        this.append('\"');
    }

    @Override
    public void renderFragment(String fragment) {
        FragmentParser renderer = new FragmentParser(){

            @Override
            public void onNewline() {
                RubyWriter.this.append('\n');
            }

            @Override
            public void onComment(char c) {
                RubyWriter.this.append(c);
            }

            @Override
            public void onBeginComment(boolean multiline) {
                RubyWriter.this.append(multiline ? "=begin" : "#");
            }

            @Override
            public void onEndComment(boolean multiline) {
                if (multiline) {
                    RubyWriter.this.append("=end");
                }
            }
        };
        renderer.parse(fragment);
    }

    @Override
    public void renderThis() {
        this.append("self");
    }

    @Override
    public void renderApiType(TypeInfo.Class.Api apiType) {
        this.append(Case.CAMEL.format((Iterable)Case.KEBAB.parse(apiType.getModule().getName())) + "::" + apiType.getSimpleName());
    }

    @Override
    public void renderJavaType(TypeInfo.Class javaType) {
        this.append("Java::" + Case.CAMEL.format((Iterable)Case.QUALIFIED.parse(javaType.getPackageName())) + "::" + javaType.getSimpleName());
    }

    @Override
    public void renderAsyncResultSucceeded(String name) {
        this.append(name + "_err == nil");
    }

    @Override
    public void renderAsyncResultFailed(String name) {
        this.append(name + "_err != nil");
    }

    @Override
    public void renderAsyncResultCause(String name) {
        this.append(name + "_err");
    }

    @Override
    public void renderAsyncResultValue(String name) {
        this.append(name);
    }

    @Override
    public void renderConditionals(List<ConditionalBlockModel> conditionals, StatementModel otherwise) {
        for (int i = 0; i < conditionals.size(); ++i) {
            ConditionalBlockModel conditional = conditionals.get(i);
            this.append(i == 0 ? "if " : "elsif ");
            conditional.getCondition().render(this);
            this.append("\n");
            this.indent();
            conditional.getBody().render(this);
            this.unindent();
        }
        if (otherwise != null) {
            this.append("else\n");
            this.indent();
            otherwise.render(this);
            this.unindent();
            this.append("end");
        } else {
            this.append("end");
        }
    }

    @Override
    public void renderPrefixIncrement(ExpressionModel expression, CodeWriter writer) {
        expression.render(this);
        this.append("+=1");
    }

    @Override
    public void renderPostfixIncrement(ExpressionModel expression) {
        expression.render(this);
        this.append("+=1");
    }

    @Override
    public void renderPostfixDecrement(ExpressionModel expression) {
        expression.render(this);
        this.append("-=1");
    }

    @Override
    public void renderPrefixDecrement(ExpressionModel expression) {
        expression.render(this);
        this.append("-=1");
    }

    @Override
    public void renderNullLiteral() {
        this.append("nil");
    }

    @Override
    public void renderStatement(StatementModel statement) {
        statement.render(this);
        this.append("\n");
    }

    @Override
    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("begin\n");
        this.indent();
        tryBlock.render(this);
        this.unindent();
        this.append("rescue\n");
        this.indent();
        catchBlock.render(this);
        this.unindent();
        this.append("end\n");
    }

    @Override
    public void renderMethodReference(ExpressionModel expression, String methodName) {
        if (!(expression instanceof ThisModel)) {
            expression.render(this);
            this.append(".");
        }
        this.append("method(:").append(Case.SNAKE.format((Iterable)Case.CAMEL.parse(methodName))).append(")");
    }

    @Override
    public void renderMethodInvocation(ExpressionModel expression, TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        List<TypeInfo> parameterTypes = method.getParameterTypes();
        String methodName = method.getName();
        int size = parameterTypes.size();
        int index = size - 1;
        if (receiverType.getKind() == ClassKind.STRING && methodName.equals("startsWith")) {
            methodName = "startWith";
        }
        LambdaExpressionModel lambda = null;
        for (int i = 0; i < size; ++i) {
            if (!Helper.isHandler(parameterTypes.get(index)) || i != size - 1) continue;
            ExpressionModel lastExpr = argumentModels.get(index);
            if (lastExpr instanceof LambdaExpressionModel) {
                lambda = (LambdaExpressionModel)lastExpr;
                parameterTypes = parameterTypes.subList(0, size - 1);
                argumentModels = argumentModels.subList(0, size - 1);
                argumentTypes = argumentTypes.subList(0, size - 1);
                continue;
            }
            if (Helper.isInstanceOfHandler(argumentTypes.get(i))) {
                argumentModels = new ArrayList<ExpressionModel>(argumentModels);
                argumentModels.set(index, this.builder.render(writer2 -> {
                    this.append("&");
                    lastExpr.render(this);
                    this.append(".method(:handle)");
                }));
                continue;
            }
            argumentModels = new ArrayList<ExpressionModel>(argumentModels);
            argumentModels.set(index, this.builder.render(writer2 -> {
                this.append("&");
                lastExpr.render(this);
            }));
        }
        methodName = Case.SNAKE.format((Iterable)Case.CAMEL.parse(methodName));
        if (returnType.getName().equals("boolean") || returnType.getName().equals("java.lang.Boolean")) {
            if (methodName.startsWith("is_")) {
                methodName = methodName.substring(3);
            }
            methodName = methodName + "?";
        }
        if (!(expression instanceof ThisModel)) {
            expression.render(this);
            this.append('.');
        }
        this.append(methodName);
        this.renderArguments(argumentModels, this);
        if (lambda != null) {
            this.append(" ");
            this.renderBlock(lambda.getBodyKind(), lambda.getParameterTypes(), lambda.getParameterNames(), lambda.getBody(), this);
        }
    }

    private void renderArguments(List<ExpressionModel> arguments, CodeWriter writer) {
        this.append('(');
        for (int i = 0; i < arguments.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            arguments.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render(this);
        this.append(".push(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderListSize(ExpressionModel list) {
        list.render(this);
        this.append(".length");
    }

    @Override
    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render(this);
        this.append("[");
        index.render(this);
        this.append("]");
    }

    @Override
    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("[");
        Iterator<ExpressionModel> it = arguments.iterator();
        while (it.hasNext()) {
            it.next().render(this);
            if (!it.hasNext()) continue;
            this.append(", ");
        }
        this.append("]");
    }

    @Override
    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append(']');
    }

    @Override
    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append("] = ");
        value.render(this);
    }

    @Override
    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        map.render(this);
        this.append(".each_pair ");
        this.renderBlock(bodyKind, Arrays.asList(keyType, valueType), Arrays.asList(keyName, valueName), block, this);
    }

    @Override
    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.renderJsonObject(jsonObject.getMembers(), this);
    }

    private void renderJsonObject(Iterable<Member> members, CodeWriter writer) {
        this.append("{\n");
        this.indent();
        Iterator<Member> iterator = members.iterator();
        while (iterator.hasNext()) {
            Member member = iterator.next();
            String name = member.getName();
            this.append("'").append(name).append("' => ");
            if (member instanceof Member.Single) {
                ((Member.Single)member).getValue().render(this);
            } else {
                this.renderJsonArray(((Member.Array)member).getValues(), writer);
            }
            if (iterator.hasNext()) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append("}");
    }

    private void renderJsonArray(List<ExpressionModel> values, CodeWriter writer) {
        this.append("[\n").indent();
        for (int i = 0; i < values.size(); ++i) {
            values.get(i).render(this);
            if (i < values.size() - 1) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append(']');
    }

    @Override
    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.renderJsonArray(jsonArray.getValues(), this);
    }

    @Override
    public void renderDataObject(DataObjectLiteralModel model) {
        this.renderJsonObject(model.getMembers(), this);
    }

    @Override
    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render(this);
        this.append("['");
        this.append(name);
        this.append("'] = ");
        value.render(this);
    }

    @Override
    public void renderNewMap() {
        this.append("Hash.new()");
    }

    @Override
    public void renderNewList() {
        this.append("Array.new");
    }

    @Override
    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        this.renderJsonObjectAssign(expression, name, value);
    }

    @Override
    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render(this);
        this.append(".push(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonObjectToString(ExpressionModel expression) {
        this.append("JSON.generate(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonArrayToString(ExpressionModel expression) {
        this.append("JSON.generate(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonObjectMemberSelect(ExpressionModel expression, String name) {
        expression.render(this);
        this.append("['");
        this.append(name);
        this.append("']");
    }

    @Override
    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        this.renderJsonObjectMemberSelect(expression, name);
    }

    @Override
    public void renderIdentifier(String name, VariableScope scope) {
        switch (scope) {
            case GLOBAL: {
                name = "$" + name;
                break;
            }
            case FIELD: {
                name = "@" + name;
            }
        }
        super.renderIdentifier(name, scope);
    }

    private void renderBlock(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body, CodeWriter writer) {
        this.append("{");
        if (parameterNames.size() > 0) {
            this.append(" |");
            for (int i = 0; i < parameterNames.size(); ++i) {
                if (i > 0) {
                    this.append(",");
                }
                this.append(parameterNames.get(i));
            }
            this.append("|");
        }
        this.append("\n");
        this.indent();
        body.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append("\n");
        }
        this.unindent();
        this.append("}");
    }

    @Override
    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("lambda ");
        this.renderBlock(bodyKind, parameterTypes, parameterNames, body, this);
    }

    @Override
    public void renderEnumConstant(TypeInfo.Class.Enum type, String constant) {
        this.append(':').append(constant);
    }

    @Override
    public void renderThrow(String throwableType, ExpressionModel reason) {
        if (reason == null) {
            this.append("raise ").append("\"an error occured\"");
        } else {
            this.append("raise ");
            reason.render(this);
        }
    }

    @Override
    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("puts ");
        expression.render(this);
    }

    @Override
    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("STDERR.puts ");
        expression.render(this);
    }

    @Override
    public void renderMemberSelect(ExpressionModel expression, String identifier) {
        expression.render(this);
        this.append("::").append(identifier);
    }

    @Override
    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        this.append("");
        expression.render(this);
        this.append(".new");
        this.renderArguments(argumentModels, this);
    }
}

