/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ExtendedClusterManager;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.AsyncMultiMap;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastAsyncMultiMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class HazelcastClusterManager
implements ExtendedClusterManager,
MembershipListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String LOCK_SEMAPHORE_PREFIX = "__vertx.";
    private static final String DEFAULT_CONFIG_FILE = "default-cluster.xml";
    private static final String CONFIG_FILE = "cluster.xml";
    private Vertx vertx;
    private HazelcastInstance hazelcast;
    private String nodeID;
    private String membershipListenerId;
    private NodeListener nodeListener;
    private volatile boolean active;
    private Config conf;

    public HazelcastClusterManager() {
        System.setProperty("hazelcast.shutdownhook.enabled", "false");
    }

    public HazelcastClusterManager(Config conf) {
        this.conf = conf;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public synchronized void join(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            if (!this.active) {
                this.active = true;
                if (this.conf == null) {
                    this.conf = this.loadConfigFromClasspath();
                    if (this.conf == null) {
                        log.warn((Object)"Cannot find cluster configuration on classpath and none specified programmatically. Using default hazelcast configuration");
                    }
                }
                this.hazelcast = Hazelcast.newHazelcastInstance((Config)this.conf);
                this.nodeID = this.hazelcast.getCluster().getLocalMember().getUuid();
                this.membershipListenerId = this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
                fut.complete();
            }
        }, resultHandler);
    }

    public <K, V> void getAsyncMultiMap(String name, Handler<AsyncResult<AsyncMultiMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            MultiMap multiMap = this.hazelcast.getMultiMap(name);
            fut.complete(new HazelcastAsyncMultiMap(this.vertx, multiMap));
        }, resultHandler);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public List<String> getNodes() {
        Set members = this.hazelcast.getCluster().getMembers();
        ArrayList<String> lMembers = new ArrayList<String>();
        for (Member member : members) {
            lMembers.add(member.getUuid());
        }
        return lMembers;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public <K, V> void getAsyncMap(String name, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            IMap map = this.hazelcast.getMap(name);
            fut.complete(new HazelcastAsyncMap(this.vertx, map));
        }, resultHandler);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        IMap map = this.hazelcast.getMap(name);
        return map;
    }

    public void getLockWithTimeout(String name, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            ISemaphore iSemaphore = this.hazelcast.getSemaphore(LOCK_SEMAPHORE_PREFIX + name);
            boolean locked = false;
            try {
                locked = iSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!locked) {
                throw new VertxException("Timed out waiting to get lock " + name);
            }
            fut.complete((Object)new HazelcastLock(iSemaphore));
        }, resultHandler);
    }

    public void getCounter(String name, Handler<AsyncResult<Counter>> resultHandler) {
        this.vertx.executeBlocking(fut -> fut.complete((Object)new HazelcastCounter(this.hazelcast.getAtomicLong(name))), resultHandler);
    }

    public synchronized void leave(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            if (this.active) {
                try {
                    this.active = false;
                    boolean left = this.hazelcast.getCluster().removeMembershipListener(this.membershipListenerId);
                    if (!left) {
                        log.warn((Object)"No membership listener");
                    }
                    while (this.hazelcast.getLifecycleService().isRunning()) {
                        try {
                            this.hazelcast.getLifecycleService().shutdown();
                        }
                        catch (RejectedExecutionException ignore) {
                            ignore.printStackTrace();
                        }
                        Thread.sleep(1L);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage());
                }
            }
            fut.complete();
        }, resultHandler);
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        try {
            if (this.nodeListener != null) {
                Member member = membershipEvent.getMember();
                this.nodeListener.nodeAdded(member.getUuid());
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberAdded", t);
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        try {
            if (this.nodeListener != null) {
                Member member = membershipEvent.getMember();
                this.nodeListener.nodeLeft(member.getUuid());
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberRemoved", t);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private InputStream getConfigStream() {
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (ctxClsLoader != null) {
            is = ctxClsLoader.getResourceAsStream(CONFIG_FILE);
        }
        if (is == null && (is = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        }
        return is;
    }

    public Config getConfig() {
        return this.conf;
    }

    public void setConfig(Config config) {
        this.conf = config;
    }

    public Config loadConfigFromClasspath() {
        Config cfg = null;
        try (InputStream is = this.getConfigStream();
             BufferedInputStream bis = new BufferedInputStream(is);){
            if (is != null) {
                cfg = new XmlConfigBuilder((InputStream)bis).build();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Failed to read config", (Throwable)ex);
        }
        return cfg;
    }

    public void beforeLeave() {
        if (this.isActive()) {
            ILock lock = this.hazelcast.getLock("vertx.shutdownlock");
            try {
                lock.tryLock(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcast;
    }

    private class HazelcastLock
    implements Lock {
        private ISemaphore semaphore;

        private HazelcastLock(ISemaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void release() {
            this.semaphore.release();
        }
    }

    private class HazelcastCounter
    implements Counter {
        private IAtomicLong atomicLong;

        private HazelcastCounter(IAtomicLong atomicLong) {
            this.atomicLong = atomicLong;
        }

        public void get(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.get()), resultHandler);
        }

        public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.incrementAndGet()), resultHandler);
        }

        public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.getAndIncrement()), resultHandler);
        }

        public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.decrementAndGet()), resultHandler);
        }

        public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.addAndGet(value)), resultHandler);
        }

        public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.getAndAdd(value)), resultHandler);
        }

        public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
            Objects.requireNonNull(resultHandler, "resultHandler");
            HazelcastClusterManager.this.vertx.executeBlocking(fut -> fut.complete((Object)this.atomicLong.compareAndSet(expected, value)), resultHandler);
        }
    }
}

