/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.autoconfigure.storage.elasticsearch.ZipkinElasticsearchStorageProperties;
import zipkin.storage.StorageComponent;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="elasticsearch")
@ConditionalOnMissingBean(value={StorageComponent.class})
public class ZipkinElasticsearchStorageAutoConfiguration {
    @Autowired(required=false)
    InternalElasticsearchClient.Builder clientBuilder;

    @Bean
    StorageComponent storage(ZipkinElasticsearchStorageProperties elasticsearch) {
        return elasticsearch.toBuilder(this.clientBuilder).build();
    }
}

