/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch;

import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin.internal.Nullable;
import zipkin.storage.elasticsearch.ElasticsearchStorage;
import zipkin.storage.elasticsearch.InternalElasticsearchClient;

@ConfigurationProperties(value="zipkin.storage.elasticsearch")
public class ZipkinElasticsearchStorageProperties {
    private String cluster = "elasticsearch";
    private List<String> hosts;
    private String index = "zipkin";
    private int indexShards = 5;
    private int indexReplicas = 1;

    public String getCluster() {
        return this.cluster;
    }

    public ZipkinElasticsearchStorageProperties setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public ZipkinElasticsearchStorageProperties setHosts(List<String> hosts) {
        if (hosts != null && !hosts.isEmpty()) {
            this.hosts = hosts;
        }
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public ZipkinElasticsearchStorageProperties setIndex(String index) {
        this.index = index;
        return this;
    }

    public int getIndexShards() {
        return this.indexShards;
    }

    public void setIndexShards(int indexShards) {
        this.indexShards = indexShards;
    }

    public int getIndexReplicas() {
        return this.indexReplicas;
    }

    public void setIndexReplicas(int indexReplicas) {
        this.indexReplicas = indexReplicas;
    }

    ElasticsearchStorage.Builder toBuilder(@Nullable InternalElasticsearchClient.Builder clientBuilder) {
        ElasticsearchStorage.Builder result;
        ElasticsearchStorage.Builder builder = result = clientBuilder != null ? ElasticsearchStorage.builder((InternalElasticsearchClient.Builder)clientBuilder) : ElasticsearchStorage.builder();
        if (this.hosts != null) {
            result.hosts(this.hosts);
        }
        return result.cluster(this.cluster).index(this.index).indexShards(this.indexShards).indexReplicas(this.indexReplicas);
    }
}

