/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jgroups.View;

public class ConsoleListener
implements TreeCacheListener {
    private TreeCache _cache;
    private boolean _startCache;

    public ConsoleListener(TreeCache cache) throws Exception {
        this(cache, true, true);
    }

    public ConsoleListener(TreeCache cache, boolean startCache, boolean stopCache) throws Exception {
        this._cache = cache;
        this._startCache = startCache;
        if (stopCache) {
            new ListenerShutdownHook().register();
        }
    }

    public void listen() throws Exception {
        this.listen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(boolean wait) throws Exception {
        this._cache.addTreeCacheListener(this);
        if (this._startCache) {
            this._cache.startService();
        }
        if (wait) {
            ConsoleListener consoleListener = this;
            synchronized (consoleListener) {
                this.wait();
            }
        }
    }

    public void cacheStarted(TreeCache cache) {
        this.printEvent("Cache started.");
    }

    public void cacheStopped(TreeCache cache) {
        this.printEvent("Cache stopped.");
    }

    public void nodeCreated(Fqn fqn) {
        this.printNode(fqn, "created");
    }

    public void nodeEvicted(Fqn fqn) {
        this.printEvent("Node evicted: " + fqn);
    }

    public void nodeLoaded(Fqn fqn) {
        this.printNode(fqn, "loaded");
    }

    public void nodeModified(Fqn fqn) {
        this.printNode(fqn, "modified");
    }

    public void nodeRemoved(Fqn fqn) {
        this.printEvent("Node removed: " + fqn);
    }

    public void nodeVisited(Fqn fqn) {
        this.printEvent("Node visited: " + fqn);
    }

    public void viewChange(View new_view) {
        this.printEvent("View change: " + new_view);
    }

    private void printEvent(String eventSuffix) {
        System.out.print("EVENT");
        System.out.print(' ');
        System.out.println(eventSuffix);
    }

    private void printNode(Fqn fqn, String eventDetail) {
        System.out.print("EVENT");
        System.out.print(' ');
        System.out.print("Node");
        System.out.print(' ');
        System.out.print(eventDetail);
        System.out.print(':');
        System.out.print(' ');
        System.out.print(fqn);
        System.out.println();
        this.printNodeMap(fqn);
        System.out.println();
    }

    private void printNodeMap(Fqn fqn) {
        try {
            Set keys = this._cache.getKeys(fqn);
            if (keys != null) {
                String key;
                int maxKeyLength = 0;
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    key = (String)iterator.next();
                    int keyLength = key.length();
                    if (keyLength <= maxKeyLength) continue;
                    maxKeyLength = keyLength;
                }
                iterator = keys.iterator();
                while (iterator.hasNext()) {
                    key = (String)iterator.next();
                    System.out.print('\t');
                    System.out.print('[');
                    this.pad(key, maxKeyLength);
                    System.out.print(',');
                    System.out.print(' ');
                    System.out.print(this._cache.get(fqn, (Object)key));
                    System.out.println(']');
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void pad(String key, int maxKeyLength) {
        System.out.print(key);
        int keyLength = key.length();
        if (keyLength < maxKeyLength) {
            int padCount = maxKeyLength - keyLength;
            for (int i = 0; i < padCount; ++i) {
                System.out.print(' ');
            }
        }
    }

    public static void main(String[] args) {
        String DEFAULT_CONFIG_FILE_NAME = "jboss-cache.xml";
        try {
            TreeCache cache = new TreeCache();
            PropertyConfigurator configurator = new PropertyConfigurator();
            String configFileName = "jboss-cache.xml";
            if (args.length >= 1) {
                configFileName = args[0];
            } else {
                System.out.print("No xml config file argument is supplied. Will use jboss-cache.xml from classpath");
            }
            configurator.configure((Object)cache, configFileName);
            ConsoleListener listener = new ConsoleListener(cache);
            listener.listen();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class ListenerShutdownHook
    extends Thread {
        private ListenerShutdownHook() {
        }

        public void register() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void run() {
            ConsoleListener.this._cache.stopService();
        }
    }
}

