/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.logging.Logger;
import org.jgroups.blocks.MethodCall;

public class TransactionTable {
    protected ConcurrentReaderHashMap tx_map = new ConcurrentReaderHashMap();
    protected HashMap txs = new HashMap();
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$cache$TransactionTable == null ? (class$org$jboss$cache$TransactionTable = TransactionTable.class$("org.jboss.cache.TransactionTable")) : class$org$jboss$cache$TransactionTable));
    static /* synthetic */ Class class$org$jboss$cache$TransactionTable;

    public int getNumLocalTransactions() {
        return this.tx_map.size();
    }

    public int getNumGlobalTransactions() {
        return this.txs.size();
    }

    public GlobalTransaction get(Transaction tx) {
        return tx != null ? (GlobalTransaction)this.tx_map.get((Object)tx) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getLocalTransaction(GlobalTransaction gtx) {
        Transaction local_tx = null;
        if (gtx == null) {
            return null;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this.tx_map;
        synchronized (concurrentReaderHashMap) {
            Iterator it = this.tx_map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                local_tx = (Transaction)entry.getKey();
                GlobalTransaction global_tx = (GlobalTransaction)entry.getValue();
                if (!gtx.equals(global_tx)) continue;
                return local_tx;
            }
        }
        return null;
    }

    public void put(Transaction tx, GlobalTransaction gtx) {
        if (tx == null) {
            log.error((Object)"key (Transaction) is null");
            return;
        }
        this.tx_map.put((Object)tx, (Object)gtx);
    }

    public TransactionEntry get(GlobalTransaction gtx) {
        return gtx != null ? (TransactionEntry)this.txs.get(gtx) : null;
    }

    public void put(GlobalTransaction tx, TransactionEntry entry) {
        if (tx == null) {
            log.error((Object)"key (GlobalTransaction) is null");
            return;
        }
        this.txs.put(tx, entry);
    }

    public TransactionEntry remove(GlobalTransaction tx) {
        return (TransactionEntry)this.txs.remove(tx);
    }

    public GlobalTransaction remove(Transaction tx) {
        if (tx == null) {
            return null;
        }
        return (GlobalTransaction)this.tx_map.remove((Object)tx);
    }

    public void addModification(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addModification(m);
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall m) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addUndoOperation(m);
    }

    public void addNode(GlobalTransaction gtx, Fqn node) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction not found (gtx=" + gtx + ")"));
            return;
        }
        entry.addNode(node);
    }

    public void addLock(GlobalTransaction gtx, IdentityLock l) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLock(l);
    }

    public void addLocks(GlobalTransaction gtx, Collection locks) {
        TransactionEntry entry = this.get(gtx);
        if (entry == null) {
            log.error((Object)("transaction entry not found for (gtx=" + gtx + ")"));
            return;
        }
        entry.addLocks(locks);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.tx_map.size()).append(" mappings, ");
        sb.append(this.txs.size()).append(" transactions");
        return sb.toString();
    }

    public String toString(boolean print_details) {
        Map.Entry entry;
        if (!print_details) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("LocalTransactions: ").append(this.tx_map.size()).append("\n");
        sb.append("GlobalTransactions: ").append(this.txs.size()).append("\n");
        sb.append("tx_map:\n");
        Iterator<Object> it = this.tx_map.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        sb.append("txs:\n");
        it = this.txs.entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

