/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.AbstractList;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.util.NestedRuntimeException;

public class CachedList
extends AbstractList {
    protected TreeCacheAop cache;
    protected Fqn fqn;

    CachedList(TreeCacheAop cache, Fqn fqn) {
        this.cache = cache;
        this.fqn = fqn;
    }

    protected Node getNode() {
        try {
            return this.cache.get(this.fqn);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(int index) {
        try {
            return this.cache.getObject(new Fqn(this.fqn, new Integer(index)));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public int size() {
        Map children = this.getNode().getChildren();
        return children == null ? 0 : children.size();
    }

    public Object set(int index, Object element) {
        try {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            Object oldValue = this.get(index);
            return this.cache.putObject(new Fqn(this.fqn, new Integer(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void add(int index, Object element) {
        try {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = this.size(); i > index; --i) {
                Object obj = this.cache.removeObject(new Fqn(this.fqn, new Integer(i - 1)));
                this.cache.putObject(new Fqn(this.fqn, new Integer(i)), obj);
            }
            this.cache.putObject(new Fqn(this.fqn, new Integer(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public boolean remove(Object o) {
        return super.remove(o);
    }

    public Object remove(int index) {
        try {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            Object result = this.cache.removeObject(new Fqn(this.fqn, new Integer(index)));
            int size = this.size() - 1;
            for (int i = index; i < size; ++i) {
                Object obj = this.cache.removeObject(new Fqn(this.fqn, new Integer(i + 1)));
                this.cache.putObject(new Fqn(this.fqn, new Integer(i)), obj);
            }
            return result;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }
}

