/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.AopOperationNotSupportedException;
import org.jboss.cache.aop.CachedCollectionInterceptor;
import org.jboss.cache.aop.CollectionInterceptorUtil;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;

public class CachedListInterceptor
implements List,
CachedCollectionInterceptor {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$cache$aop$CachedListInterceptor == null ? (class$org$jboss$cache$aop$CachedListInterceptor = CachedListInterceptor.class$("org.jboss.cache.aop.CachedListInterceptor")) : class$org$jboss$cache$aop$CachedListInterceptor));
    protected static final Map managedMethods = CollectionInterceptorUtil.getManagedMethods(class$java$util$List == null ? (class$java$util$List = CachedListInterceptor.class$("java.util.List")) : class$java$util$List);
    protected TreeCacheAop cache;
    protected Fqn fqn;
    protected Map methodMap;
    static /* synthetic */ Class class$org$jboss$cache$aop$CachedListInterceptor;
    static /* synthetic */ Class class$java$util$List;

    public CachedListInterceptor(TreeCacheAop cache, Fqn fqn, Class clazz) {
        this.cache = cache;
        this.fqn = fqn;
        this.methodMap = CollectionInterceptorUtil.getMethodMap(clazz);
    }

    public String getName() {
        return "CachedListInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        return CollectionInterceptorUtil.invoke(invocation, this, this.methodMap, managedMethods);
    }

    protected Node getNode() {
        try {
            return this.cache.get(this.fqn);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object get(int index) {
        this.checkIndex(index);
        try {
            return this.cache.getObject(new Fqn(this.fqn, new Integer(index)));
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private void checkIndex(int i) {
        if (this.size() == 0) {
            return;
        }
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bound at CachedListInterceptor(). Index is " + i + " but size is " + this.size());
        }
    }

    private void checkArgument(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    public int size() {
        Node node = this.getNode();
        if (node == null) {
            return 0;
        }
        Map children = node.getChildren();
        return children == null ? 0 : children.size();
    }

    public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objs[i] = this.get(i);
        }
        return objs;
    }

    public Object set(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            Object oldValue = this.get(index);
            return this.cache.putObject(new Fqn(this.fqn, new Integer(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public Object[] toArray(Object[] a) {
        throw new AopOperationNotSupportedException("CachedListInterceptor: List.toArray(a) operation not supported");
    }

    public void add(int index, Object element) {
        try {
            if (index != 0) {
                this.checkIndex(index - 1);
            }
            for (int i = this.size(); i > index; --i) {
                Object obj = this.cache.removeObject(new Fqn(this.fqn, new Integer(i - 1)));
                this.cache.putObject(new Fqn(this.fqn, new Integer(i)), obj);
            }
            this.cache.putObject(new Fqn(this.fqn, new Integer(index)), element);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public int indexOf(Object o) {
        this.checkArgument(o);
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        this.checkArgument(o);
        int index = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!o.equals(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public Object remove(int index) {
        try {
            this.checkIndex(index);
            Object result = this.cache.removeObject(new Fqn(this.fqn, new Integer(index)));
            int size = this.size();
            for (int i = index; i < size; ++i) {
                Object obj = this.cache.removeObject(new Fqn(this.fqn, new Integer(i + 1)));
                this.cache.putObject(new Fqn(this.fqn, new Integer(i)), obj);
            }
            return result;
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        throw new AopOperationNotSupportedException("CachedListInterceptor: List.addAll() operation not supported");
    }

    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.add(o);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedListInterceptor: List.containsAll() operation not supported");
    }

    public boolean removeAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.remove(o);
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value != null) {
                if (this.contains(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object key = this.get(i);
            buf.append("[" + key).append("]");
            if (i > size) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean retainAll(Collection c) {
        throw new AopOperationNotSupportedException("CachedListInterceptor: List.retainAll() operation not supported");
    }

    public Iterator iterator() {
        return new Iterator(){
            protected int current = 0;

            public boolean hasNext() {
                return this.current < CachedListInterceptor.this.size();
            }

            public Object next() {
                try {
                    return CachedListInterceptor.this.cache.getObject(new Fqn(CachedListInterceptor.this.fqn, new Integer(this.current++)));
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }

            public void remove() {
                try {
                    int size = CachedListInterceptor.this.size();
                    if (this.current < size) {
                        Object last = CachedListInterceptor.this.cache.removeObject(new Fqn(CachedListInterceptor.this.fqn, new Integer(size - 1)));
                        CachedListInterceptor.this.cache.putObject(new Fqn(CachedListInterceptor.this.fqn, new Integer(--this.current)), last);
                    } else {
                        CachedListInterceptor.this.cache.removeObject(new Fqn(CachedListInterceptor.this.fqn, new Integer(--this.current)));
                    }
                }
                catch (Exception e) {
                    throw new NestedRuntimeException((Throwable)e);
                }
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        throw new AopOperationNotSupportedException("CachedListInterceptor: List.subList() operation not supported");
    }

    public ListIterator listIterator() {
        return new MyListIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new MyListIterator(index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MyListIterator
    implements ListIterator {
        protected int index = 0;

        public MyListIterator(int index) {
            if (index < 0 || index >= CachedListInterceptor.this.size()) {
                throw new AopOperationNotSupportedException("CachedListInterceptor: MyListIterator construction.  Index is out of bound : " + index);
            }
            this.index = index;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            throw new AopOperationNotSupportedException("CachedListInterceptor: ListIterator.remove() optional operation not supported");
        }

        public boolean hasNext() {
            return this.index != CachedListInterceptor.this.size() - 1;
        }

        public boolean hasPrevious() {
            return this.index != 0;
        }

        public Object next() {
            if (this.index == CachedListInterceptor.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return CachedListInterceptor.this.get(this.index - 1);
        }

        public Object previous() {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return CachedListInterceptor.this.get(this.index);
        }

        public void add(Object o) {
            throw new AopOperationNotSupportedException("CachedListInterceptor: ListIterator.add() optional operation not supported");
        }

        public void set(Object o) {
            throw new AopOperationNotSupportedException("CachedListInterceptor: ListIterator.set() optional operation not supported");
        }
    }
}

