/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jgroups.blocks.MethodCall;

public class CallInterceptor
extends Interceptor {
    TransactionManager tx_mgr = null;
    TransactionTable tx_table = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
    }

    public Object invoke(MethodCall m) throws Throwable {
        Object retval;
        try {
            retval = m.invoke((Object)this.cache);
        }
        catch (Throwable t) {
            retval = t;
        }
        Transaction tx = null;
        if (this.tx_mgr != null) {
            tx = this.tx_mgr.getTransaction();
        }
        if (tx != null && (this.isActive(tx) || this.isPreparing(tx))) {
            if (retval != null && retval instanceof Throwable) {
                tx.setRollbackOnly();
            } else if (TreeCache.isCrudMethod(m.getMethod())) {
                GlobalTransaction gtx = this.tx_table.get(tx);
                if (gtx == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("didn't find GlobalTransaction for " + tx + "; won't add modification to transaction list"));
                    }
                } else {
                    this.tx_table.addModification(gtx, m);
                }
            }
        }
        if (retval != null && retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }
}

