/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import javax.transaction.NotSupportedException;
import javax.transaction.Transaction;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jgroups.View;

public class CallbackTest
extends TestCase {
    TreeCache cache = null;
    TreeCache cache2;
    Transaction tx = null;
    final Fqn FQN = Fqn.fromString("/myNode");
    final String KEY = "key";
    final String VALUE = "value";
    Listener exListener = new Listener(){

        public void nodeCreated(Fqn fqn) {
            throw new RuntimeException("this will cause the TX to rollback");
        }
    };
    static /* synthetic */ Class class$org$jboss$cache$tests$CallbackTest;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.cache != null) {
            this.cache.stopService();
            this.cache.destroyService();
            this.cache = null;
        }
        if (this.tx != null) {
            this.tx.commit();
            this.tx = null;
        }
    }

    public void testLocalCallbackWithoutTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(1, IsolationLevel.SERIALIZABLE);
        this.cache.addTreeCacheListener(new MyListener(this.cache));
        this.cache.put("/a", null);
        CallbackTest.assertTrue((boolean)this.cache.exists(this.FQN));
    }

    public void testLocalCallbackWithTransaction() throws Exception, NotSupportedException {
        this.cache = this.createCache(1, IsolationLevel.SERIALIZABLE);
        this.cache.addTreeCacheListener(new MyListener(this.cache));
        this.tx = this.startTransaction();
        this.cache.put("/a", null);
        this.tx.commit();
        CallbackTest.assertTrue((boolean)this.cache.exists(this.FQN));
    }

    public void testLocalCallbackWithException() throws Exception, NotSupportedException {
        this.cache = this.createCache(1, IsolationLevel.SERIALIZABLE);
        this.cache.addTreeCacheListener(this.exListener);
        this.tx = this.startTransaction();
        try {
            this.cache.put("/a", null);
            this.tx.rollback();
        }
        catch (RuntimeException ex) {
            this.tx.rollback();
        }
        CallbackTest.assertFalse((boolean)this.cache.exists(this.FQN));
    }

    TreeCache createCache(int mode, IsolationLevel level) throws Exception {
        TreeCache c = new TreeCache();
        c.setCacheMode(mode);
        c.setIsolationLevel(level);
        c.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        c.createService();
        c.startService();
        return c;
    }

    Transaction startTransaction() {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        try {
            mgr.begin();
            return mgr.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$CallbackTest == null ? (class$org$jboss$cache$tests$CallbackTest = CallbackTest.class$("org.jboss.cache.tests.CallbackTest")) : class$org$jboss$cache$tests$CallbackTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyListener
    extends Listener {
        TreeCache c;

        public MyListener(TreeCache c) {
            this.c = c;
        }

        public void nodeCreated(Fqn fqn) {
            try {
                if (!this.c.exists(CallbackTest.this.FQN)) {
                    System.out.println("MyListener: creating node " + CallbackTest.this.FQN);
                    this.c.put(CallbackTest.this.FQN, (Object)"key", (Object)"value");
                    System.out.println("MyListener: created node " + CallbackTest.this.FQN);
                }
            }
            catch (CacheException e) {
                Assert.fail((String)("listener was unable to update cache during callback: " + (Object)((Object)e)));
            }
        }
    }

    class Listener
    implements TreeCacheListener {
        Listener() {
        }

        public void nodeCreated(Fqn fqn) {
        }

        public void nodeRemoved(Fqn fqn) {
        }

        public void nodeLoaded(Fqn fqn) {
        }

        public void nodeEvicted(Fqn fqn) {
        }

        public void nodeModified(Fqn fqn) {
        }

        public void nodeVisited(Fqn fqn) {
        }

        public void cacheStarted(TreeCache cache) {
        }

        public void cacheStopped(TreeCache cache) {
        }

        public void viewChange(View new_view) {
        }
    }
}

