/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.stack.Utilities;

public class GossipClientTest
extends TestCase {
    GossipClient client;
    private int port = -1;
    private long expiryTime = 1000L;

    public GossipClientTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.port = Utilities.startGossipRouter(this.expiryTime, "127.0.0.1");
        this.client = new GossipClient(new IpAddress("127.0.0.1", this.port), this.expiryTime);
        this.client.setRefresherEnabled(false);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.client.stop();
        Utilities.stopGossipRouter();
    }

    public void testEmptyGET() throws Exception {
        String groupName = "nosuchgroup";
        List mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertNotNull((Object)mbrs);
        GossipClientTest.assertEquals((int)0, (int)mbrs.size());
    }

    public void test_REGISTER_GET() throws Exception {
        String groupName = "TESTGROUP";
        int mbrPort = 7777;
        IpAddress mbr = new IpAddress("127.0.0.1", mbrPort);
        this.client.register(groupName, mbr);
        List mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertEquals((int)1, (int)mbrs.size());
        GossipClientTest.assertEquals((Object)new IpAddress("127.0.0.1", mbrPort), mbrs.get(0));
    }

    public void test_REGISTER_UNREGISTER_GET() throws Exception {
        String groupName = "TESTGROUP";
        int mbrPort = 7777;
        IpAddress mbr = new IpAddress("127.0.0.1", mbrPort);
        this.client.register(groupName, mbr);
        List mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertEquals((int)1, (int)mbrs.size());
        GossipClientTest.assertEquals((Object)new IpAddress("127.0.0.1", mbrPort), mbrs.get(0));
        this.client.unregister(groupName, mbr);
        mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertNotNull((Object)mbrs);
        GossipClientTest.assertEquals((int)0, (int)mbrs.size());
    }

    public void testSweep() throws Exception {
        String groupName = "TESTGROUP";
        int mbrPort = 7777;
        IpAddress mbr = new IpAddress("127.0.0.1", mbrPort);
        this.client.register(groupName, mbr);
        List mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertEquals((int)1, (int)mbrs.size());
        GossipClientTest.assertEquals((Object)new IpAddress("127.0.0.1", mbrPort), mbrs.get(0));
        Thread.sleep(2L * this.expiryTime);
        mbrs = this.client.getMembers(groupName);
        GossipClientTest.assertTrue((mbrs == null || mbrs.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(GossipClientTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GossipClientTest.suite());
        System.exit(0);
    }
}

