/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.skypencil.findbugs.slf4j.CodepointIterator;
import jp.skypencil.findbugs.slf4j.parameter.AbstractDetectorForParameterArray;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;
import jp.skypencil.findbugs.slf4j.parameter.ArrayDataHandler;
import jp.skypencil.findbugs.slf4j.parameter.ThrowableHandler;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class WrongPlaceholderDetector
extends AbstractDetectorForParameterArray {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.?)(\\\\\\\\)*\\{\\}");
    private Table<Method, Integer, List<PotentialPlaceHolderMismatch>> potentialPlaceHolderMismatch;
    private Table<Method, Integer, List<PotentialSignOnlyFormat>> potentialSignOnlyFormat;
    @StaticConstant
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\((.*)\\).*$");

    public WrongPlaceholderDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.potentialPlaceHolderMismatch = HashBasedTable.create();
        this.potentialSignOnlyFormat = HashBasedTable.create();
        super.visitClassContext(classContext);
        this.validatePrivateMethodCall();
    }

    private void validatePrivateMethodCall() {
        List<Object> constants;
        Integer argumentIndex;
        Method method;
        for (Table.Cell<Method, Integer, List<PotentialPlaceHolderMismatch>> cell : this.potentialPlaceHolderMismatch.cellSet()) {
            method = cell.getRowKey();
            constants = this.getConstantsToCall(method, argumentIndex = cell.getColumnKey());
            if (constants == null) continue;
            for (Object bug : cell.getValue()) {
                for (Object constant : constants) {
                    int placeholders = this.countPlaceholder(constant.toString());
                    if (placeholders == ((PotentialPlaceHolderMismatch)bug).getParameterCount()) continue;
                    this.getBugReporter().reportBug(((PotentialPlaceHolderMismatch)bug).getRawBug(placeholders));
                }
            }
        }
        for (Table.Cell<Method, Integer, List<Object>> cell : this.potentialSignOnlyFormat.cellSet()) {
            method = cell.getRowKey();
            constants = this.getConstantsToCall(method, argumentIndex = cell.getColumnKey());
            if (constants == null) continue;
            for (Object bug : cell.getValue()) {
                for (Object constant : constants) {
                    String format = constant.toString();
                    if (this.verifyFormat(format)) continue;
                    this.getBugReporter().reportBug(((PotentialSignOnlyFormat)bug).getRawBug(format));
                }
            }
        }
    }

    @Override
    protected void onLog(@Nullable String format, @Nullable ArrayData arrayData) {
        int parameterCount;
        String signature = this.getSigConstantOperand();
        try {
            parameterCount = this.countParameter(this.stack, signature, this.getThrowableHandler());
        }
        catch (IllegalStateException e) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_UNKNOWN_ARRAY", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.getBugReporter().reportBug(bug);
            return;
        }
        if (format == null) {
            int argumentIndexOfLogFormat = this.getArgumentIndexOfLogFormat();
            this.get(this.potentialPlaceHolderMismatch, this.getMethod(), argumentIndexOfLogFormat).add(new PotentialPlaceHolderMismatch(this.createPlaceHolderMismatchBugInstance(-1, parameterCount), parameterCount));
            this.get(this.potentialSignOnlyFormat, this.getMethod(), argumentIndexOfLogFormat).add(new PotentialSignOnlyFormat(this.createSignOnlyFormatBugInstance(format)));
            return;
        }
        int placeholderCount = this.countPlaceholder(format);
        if (!this.verifyFormat(format)) {
            this.getBugReporter().reportBug(this.createSignOnlyFormatBugInstance(format));
        }
        if (placeholderCount != parameterCount) {
            BugInstance bug = this.createPlaceHolderMismatchBugInstance(placeholderCount, parameterCount);
            this.getBugReporter().reportBug(bug);
        }
    }

    private BugInstance createSignOnlyFormatBugInstance(@Nullable String formatString) {
        BugInstance bug = new BugInstance((Detector)this, "SLF4J_SIGN_ONLY_FORMAT", 2).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
        if (formatString != null) {
            bug.addString(formatString);
        }
        return bug;
    }

    private BugInstance createPlaceHolderMismatchBugInstance(int placeholderCount, int parameterCount) {
        BugInstance bug = new BugInstance((Detector)this, "SLF4J_PLACE_HOLDER_MISMATCH", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addInt(parameterCount);
        if (placeholderCount != -1) {
            bug.addInt(placeholderCount);
        }
        return bug;
    }

    private boolean verifyFormat(@Nonnull String formatString) {
        CodepointIterator iterator = new CodepointIterator(formatString);
        while (iterator.hasNext()) {
            if (!Character.isLetter(iterator.next())) continue;
            return true;
        }
        return false;
    }

    int countParameter(OpcodeStack stack, String methodSignature, ThrowableHandler throwableHandler) {
        OpcodeStack.Item lastItem;
        String[] signatures = this.splitSignature(methodSignature);
        if (Objects.equal(signatures[signatures.length - 1], "[Ljava/lang/Object;")) {
            ArrayData arrayData = (ArrayData)stack.getStackItem(0).getUserValue();
            if (arrayData == null || arrayData.getSize() < 0) {
                throw new IllegalStateException("no array initializer found");
            }
            int parameterCount = arrayData.getSize();
            if (arrayData.isMarked()) {
                --parameterCount;
            }
            return parameterCount;
        }
        int parameterCount = signatures.length - 1;
        if (Objects.equal(signatures[0], "Lorg/slf4j/Marker;")) {
            --parameterCount;
        }
        if (throwableHandler.checkThrowable(lastItem = stack.getStackItem(0))) {
            --parameterCount;
        }
        return parameterCount;
    }

    int countPlaceholder(String format) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(format);
        int count = 0;
        while (matcher.find()) {
            if (Objects.equal("\\", matcher.group(1))) continue;
            ++count;
        }
        return count;
    }

    private String[] splitSignature(String methodSignature) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(methodSignature);
        if (matcher.find()) {
            String[] arguments = matcher.group(1).split(";");
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = arguments[i] + ';';
            }
            return arguments;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected ArrayDataHandler.Strategy createArrayCheckStrategy() {
        return new ArrayDataHandler.Strategy(){

            @Override
            public void store(OpcodeStack.Item storedItem, ArrayData data, int index) {
                if (data != null && data.getSize() - 1 == index) {
                    data.mark(WrongPlaceholderDetector.this.getThrowableHandler().checkThrowable(storedItem));
                }
            }
        };
    }

    private <R, C, E> List<E> get(Table<R, C, List<E>> table, R row, C column) {
        List<E> list = table.get(row, column);
        if (list == null) {
            list = Lists.newArrayList();
            table.put(row, column, list);
        }
        return list;
    }

    private static final class PotentialPlaceHolderMismatch {
        private final BugInstance bug;
        private final int parameterCount;

        private PotentialPlaceHolderMismatch(BugInstance bug, int parameterCount) {
            this.bug = bug;
            this.parameterCount = parameterCount;
        }

        private BugInstance getRawBug(int placeholders) {
            return this.bug.addInt(placeholders);
        }

        private final int getParameterCount() {
            return this.parameterCount;
        }
    }

    private static final class PotentialSignOnlyFormat {
        private final BugInstance bug;

        private PotentialSignOnlyFormat(BugInstance bug) {
            this.bug = bug;
        }

        private BugInstance getRawBug(String format) {
            return this.bug.addString(format);
        }
    }
}

