/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.el;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.marmalade.el.ExpressionEvaluationException;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.monitor.log.DefaultLog;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.marmalade.util.RegexSupport;

public abstract class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    public static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{.*\\}");
    public static final String PRIMITIVE_PATTERNS = "[0-9]+[idfblhIDFBLH]?|true|false|0x[0-9]+[bB]?";
    private MarmaladeLog log;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractExpressionEvaluator() {
    }

    public void setLog(MarmaladeLog log) {
        this.log = log;
    }

    protected MarmaladeLog getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String expression, Map context, Class expectedReturnType) throws ExpressionEvaluationException {
        AbstractExpressionEvaluator abstractExpressionEvaluator = this;
        synchronized (abstractExpressionEvaluator) {
            if (this.log == null) {
                this.log = new DefaultLog();
            }
        }
        Object result = null;
        Matcher matcher = this.getExpressionPattern().matcher(expression);
        if (matcher.matches() || expression.matches(PRIMITIVE_PATTERNS)) {
            result = this.doEval(expression, context, expectedReturnType);
        } else {
            matcher.reset();
            StringBuffer resultBuffer = new StringBuffer();
            while (matcher.find()) {
                String expr = matcher.group();
                Object exprResult = this.doEval(expr, context, class$java$lang$String == null ? AbstractExpressionEvaluator.class$("java.lang.String") : class$java$lang$String);
                matcher.appendReplacement(resultBuffer, RegexSupport.escapedValueOf(exprResult));
            }
            matcher.appendTail(resultBuffer);
            result = resultBuffer.toString();
        }
        if (result != null && !expectedReturnType.isAssignableFrom(result.getClass())) {
            throw new ExpressionEvaluationException("Result: '" + result + "' of expression: " + expression + " is of type: " + result.getClass().getName() + " not of type: " + expectedReturnType);
        }
        return result;
    }

    protected Pattern getExpressionPattern() {
        return EXPRESSION_PATTERN;
    }

    protected abstract Object doEval(String var1, Map var2, Class var3) throws ExpressionEvaluationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Object assign(Object var1, String var2, Object var3) throws ExpressionEvaluationException;
}

