/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.el;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.marmalade.el.AbstractExpressionEvaluator;
import org.codehaus.marmalade.el.ExpressionEvaluationException;

public class BareBonesExpressionEvaluator
extends AbstractExpressionEvaluator {
    public static final String LEGAL_OBJECT_PROPERTY_NAME_PATTERN = "[_a-zA-Z0-9]+";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public Object assign(Object target, String property, Object value) throws ExpressionEvaluationException {
        if (property.matches(LEGAL_OBJECT_PROPERTY_NAME_PATTERN)) {
            Object result = null;
            PropertyDescriptor descriptor = this.findPropertyDescriptor(target, property, value);
            this.executePropertySet(descriptor, target, value);
            return result;
        }
        throw new ExpressionEvaluationException("advanced assignment not supported by bare-bones evaluator");
    }

    public Pattern getExpressionPattern() {
        return AbstractExpressionEvaluator.EXPRESSION_PATTERN;
    }

    protected Object doEval(String expression, Map context, Class expectedType) throws ExpressionEvaluationException {
        Object result = expression;
        result = expression.matches("[0-9]+[idfblhIDFBLH]?|true|false|0x[0-9]+[bB]?") ? this.evalAsLiteral(expression, context, expectedType) : this.evalAsObject(expression, context, expectedType);
        return result;
    }

    private Object evalAsObject(String expression, Map context, Class expectedType) throws ExpressionEvaluationException {
        Object result = null;
        String lookupKey = expression.substring(2, expression.length() - 1);
        Object value = context.get(lookupKey);
        if (value != null) {
            if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BareBonesExpressionEvaluator.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(expectedType)) {
                result = Boolean.valueOf(String.valueOf(value));
            } else if ((class$java$lang$String == null ? (class$java$lang$String = BareBonesExpressionEvaluator.class$("java.lang.String")) : class$java$lang$String).equals(expectedType)) {
                result = String.valueOf(value);
            } else if (expectedType.isAssignableFrom(value.getClass())) {
                result = value;
            } else {
                throw new ExpressionEvaluationException("coercion not available in bare-bones expression evaluator");
            }
        }
        return result;
    }

    private Object evalAsLiteral(String expression, Map context, Class expectedType) throws ExpressionEvaluationException {
        Object result = null;
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BareBonesExpressionEvaluator.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(expectedType)) {
            result = Boolean.valueOf(expression);
        } else if ((class$java$lang$String == null ? (class$java$lang$String = BareBonesExpressionEvaluator.class$("java.lang.String")) : class$java$lang$String).equals(expectedType) || (class$java$lang$Object == null ? (class$java$lang$Object = BareBonesExpressionEvaluator.class$("java.lang.Object")) : class$java$lang$Object).equals(expectedType)) {
            result = expression.substring(2, expression.length() - 1);
        } else {
            throw new ExpressionEvaluationException("coercion not available in bare-bones expression evaluator");
        }
        return result;
    }

    private PropertyDescriptor findPropertyDescriptor(Object target, String property, Object value) throws ExpressionEvaluationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(target.getClass());
        }
        catch (IntrospectionException e) {
            throw new ExpressionEvaluationException("cannot discover target properties", e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        PropertyDescriptor descriptor = null;
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptorCandidate = descriptors[i];
            if (!descriptorCandidate.getName().equals(property) || !descriptorCandidate.getPropertyType().isAssignableFrom(value.getClass())) continue;
            descriptor = descriptorCandidate;
            break;
        }
        return descriptor;
    }

    private Object executePropertySet(PropertyDescriptor descriptor, Object target, Object value) throws ExpressionEvaluationException {
        if (descriptor == null) {
            throw new ExpressionEvaluationException("target property not found");
        }
        try {
            return descriptor.getWriteMethod().invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ExpressionEvaluationException("error setting target property", e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionEvaluationException("error setting target property", e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionEvaluationException("error setting target property", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

