/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.metamodel;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.metamodel.TagInstantiationException;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.parsing.ParserHint;

public abstract class AbstractMarmaladeTagLibrary
implements MarmaladeTagLibrary {
    private Map registeredTags = new TreeMap();

    protected AbstractMarmaladeTagLibrary() {
    }

    public MarmaladeTag createTag(MarmaladeTagInfo tagInfo) throws TagInstantiationException {
        MarmaladeTag tag = null;
        try {
            Class tagClass = (Class)this.registeredTags.get(tagInfo.getElement());
            Object[] params = new Object[]{};
            Class[] paramTypes = new Class[]{};
            Constructor constructor = tagClass.getConstructor(paramTypes);
            tag = (MarmaladeTag)constructor.newInstance(params);
        }
        catch (SecurityException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TagInstantiationException(tagInfo, (Throwable)e);
        }
        return tag;
    }

    public void registerTag(String name, Class tagClass) {
        this.registeredTags.put(name, tagClass);
    }

    public ParserHint getParserHint(String name) {
        return new ParserHint().parseChildren(true);
    }
}

