/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.metamodel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.marmalade.el.ExpressionEvaluator;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.metamodel.MarmaladeTagLibrary;
import org.codehaus.marmalade.metamodel.MetaAttributes;
import org.codehaus.marmalade.metamodel.ModelBuilderException;
import org.codehaus.marmalade.model.DefaultAttributes;
import org.codehaus.marmalade.model.MarmaladeControlProcessor;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.parsing.MarmaladeParsingContext;

public class MarmaladeTagBuilder {
    private MarmaladeTagBuilder parent;
    private List childComponents = new LinkedList();
    private MarmaladeTagInfo tagInfo;
    private MarmaladeTagLibrary tagLibrary;
    private ExpressionEvaluator expressionEvaluator;
    private MetaAttributes attributes;

    public void startParsing(MarmaladeParsingContext context) {
        this.expressionEvaluator = context.getDefaultExpressionEvaluator();
    }

    public void setParent(MarmaladeTagBuilder parent) {
        this.parent = parent;
    }

    public MarmaladeTagBuilder getParent() {
        return this.parent;
    }

    public void addChild(MarmaladeTagBuilder child) {
        this.childComponents.add(child);
    }

    public void addText(String text) {
        this.childComponents.add(text);
    }

    public void setTagLibrary(MarmaladeTagLibrary tagLibrary) {
        this.tagLibrary = tagLibrary;
    }

    public MarmaladeTag build() throws ModelBuilderException {
        MarmaladeTag tag = this.tagLibrary.createTag(this.tagInfo);
        tag.setTagInfo(this.tagInfo);
        tag.setExpressionEvaluator(this.expressionEvaluator);
        DefaultAttributes tagAttributes = new DefaultAttributes(this.attributes);
        tagAttributes.setExpressionEvaluator(this.expressionEvaluator);
        tag.setAttributes(tagAttributes);
        Iterator it = this.childComponents.iterator();
        while (it.hasNext()) {
            Object childComponent = it.next();
            if (childComponent instanceof MarmaladeTagBuilder) {
                MarmaladeTag child = ((MarmaladeTagBuilder)childComponent).build();
                child.setParent(tag);
                tag.addChild(child);
                continue;
            }
            tag.appendBodyText(String.valueOf(childComponent));
        }
        return MarmaladeControlProcessor.activateTagControls(this.attributes, tag);
    }

    public void setTagInfo(MarmaladeTagInfo tagInfo) {
        this.tagInfo = tagInfo;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public void setAttributes(MetaAttributes attributes) {
        this.attributes = attributes;
    }

    public MarmaladeTagLibrary getTagLibrary() {
        return this.tagLibrary;
    }

    public MarmaladeTagInfo getTagInfo() {
        return this.tagInfo;
    }
}

