/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.parsing;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.marmalade.metamodel.ScriptBuilder;
import org.codehaus.marmalade.parsing.MarmaladeParsetimeException;
import org.codehaus.marmalade.parsing.MarmaladeParsingContext;
import org.codehaus.marmalade.parsing.ScriptParser;
import org.codehaus.marmalade.reader.ScriptReader;

public class CachingScriptParser
extends ScriptParser {
    private final Map cache = new WeakHashMap();

    public CachingScriptParser() {
    }

    public CachingScriptParser(ScriptReader scriptReader) {
        super(scriptReader);
    }

    public void purge(String location) {
        this.cache.remove(location);
    }

    public ScriptBuilder parse(MarmaladeParsingContext context) throws MarmaladeParsetimeException {
        String location = context.getInputLocation();
        ScriptBuilder builder = this.checkCache(location);
        if (builder == null) {
            builder = super.parse(context);
            this.cache(location, builder);
        }
        return builder;
    }

    private void cache(String location, ScriptBuilder builder) {
        this.cache.put(location, builder);
    }

    private ScriptBuilder checkCache(String location) {
        return (ScriptBuilder)this.cache.get(location);
    }
}

