/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.parsing;

import java.io.IOException;
import org.codehaus.marmalade.metamodel.MarmaladeTaglibResolver;
import org.codehaus.marmalade.metamodel.ScriptBuilder;
import org.codehaus.marmalade.monitor.log.MarmaladeLog;
import org.codehaus.marmalade.parsing.EmptyScriptException;
import org.codehaus.marmalade.parsing.MarmaladeParsetimeException;
import org.codehaus.marmalade.parsing.MarmaladeParsingContext;
import org.codehaus.marmalade.reader.ScriptReadException;
import org.codehaus.marmalade.reader.ScriptReader;
import org.codehaus.marmalade.reader.xml.Xpp3ScriptReader;

public class ScriptParser {
    private final ScriptReader scriptReader;
    private MarmaladeLog log;

    public ScriptParser() {
        this.scriptReader = new Xpp3ScriptReader();
    }

    public ScriptParser(ScriptReader scriptReader) {
        this.scriptReader = scriptReader;
    }

    public ScriptBuilder parse(MarmaladeParsingContext context) throws MarmaladeParsetimeException {
        ScriptBuilder result = null;
        String location = context.getInputLocation();
        try {
            MarmaladeTaglibResolver resolver = context.getTaglibResolver();
            Xpp3ScriptReader scriptReader = new Xpp3ScriptReader();
            result = scriptReader.readScript(context);
        }
        catch (ScriptReadException e) {
            throw new MarmaladeParsetimeException(e);
        }
        catch (IOException e) {
            throw new MarmaladeParsetimeException(e);
        }
        if (result == null) {
            throw new EmptyScriptException("Error parsing script at: " + location + ". Reason: resulting root tag was null.");
        }
        return result;
    }

    public void setLog(MarmaladeLog log) {
        if (log != null) {
            this.log = log;
        }
    }
}

