/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.tags;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.marmalade.model.AbstractMarmaladeTag;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.tags.LoopStatus;
import org.codehaus.marmalade.tags.LoopingTag;

public abstract class AbstractLoopingTag
extends AbstractMarmaladeTag
implements LoopingTag {
    private boolean shouldBreak = false;
    private boolean shouldContinue = false;

    protected AbstractLoopingTag() {
    }

    public final void breakLoop() {
        this.shouldBreak = true;
    }

    public final void continueLoop() {
        this.shouldContinue = true;
    }

    protected final boolean alwaysProcessChildren() {
        return false;
    }

    protected void doReset() {
        this.shouldBreak = false;
        this.shouldContinue = false;
    }

    protected final void executeLoop(LoopStep[] steps, String itemBinding, String statusBinding, MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        context.newScope();
        block0: for (int i = 0; i < steps.length; ++i) {
            LoopStep step = steps[i];
            Object item = step.getItem();
            context.setVariable(itemBinding, item);
            if (statusBinding != null && statusBinding.length() > 0) {
                context.setVariable(statusBinding, step);
            }
            List children = this.children();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                MarmaladeTag child = (MarmaladeTag)it.next();
                child.execute(context);
                if (this.shouldBreak) break block0;
                if (!this.shouldContinue) continue;
                this.shouldContinue = false;
                continue block0;
            }
        }
        context.lastScope();
    }

    protected void getItemsFromCollection(Collection items, List itemList, int begin, int end, int step) {
        int i = 0;
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (i >= begin && (i <= end || end <= -1) && i % step == 0) {
                itemList.add(new LoopStep(item, begin, end, step, i));
            }
            ++i;
        }
    }

    protected void getItemsFromString(String items, String delims, List itemList, int begin, int end, int step) {
        StringTokenizer st = new StringTokenizer(items, delims);
        int i = 0;
        while (st.hasMoreTokens()) {
            String item = st.nextToken().trim();
            if (i >= begin && (i <= end || end <= -1) && i % step == 0) {
                itemList.add(new LoopStep(item, begin, end, step, i));
            }
            ++i;
        }
    }

    protected void getItemsFromArray(Object[] itemArray, List itemList, int begin, int end, int step) {
        for (int i = 0; i < itemArray.length; ++i) {
            Object item = itemArray[i];
            if (i < begin || i > end && end > -1 || i % step != 0) continue;
            itemList.add(new LoopStep(item, begin, end, step, i));
        }
    }

    public static final class LoopStep
    implements LoopStatus {
        private Object item;
        private int index;
        private int begin;
        private int end;
        private int step;

        public LoopStep(Object item, int begin, int end, int step, int index) {
            this.item = item;
            this.index = index;
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        protected Object getItem() {
            return this.item;
        }

        public int getIndex() {
            return this.index;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStep() {
            return this.step;
        }
    }
}

