/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.tags;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.marmalade.metamodel.MarmaladeTagInfo;
import org.codehaus.marmalade.model.AbstractMarmaladeTag;
import org.codehaus.marmalade.model.MarmaladeAttribute;
import org.codehaus.marmalade.model.MarmaladeAttributes;
import org.codehaus.marmalade.model.MarmaladeTag;
import org.codehaus.marmalade.runtime.MarmaladeExecutionContext;
import org.codehaus.marmalade.runtime.MarmaladeExecutionException;
import org.codehaus.marmalade.runtime.TagExecutionException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public abstract class AbstractPassThroughTag
extends AbstractMarmaladeTag {
    private List childComponents = new LinkedList();

    protected AbstractPassThroughTag() {
    }

    protected List getChildComponents() {
        return this.childComponents;
    }

    protected void doExecute(MarmaladeExecutionContext context) throws MarmaladeExecutionException {
        XmlSerializer serializer = null;
        try {
            serializer = context.getXmlSerializer();
        }
        catch (XmlPullParserException e) {
            throw new TagExecutionException(this.getTagInfo(), "Error creating XML formatter.", e);
        }
        catch (IOException e) {
            throw new TagExecutionException(this.getTagInfo(), "Error creating XML formatter.", e);
        }
        try {
            MarmaladeTagInfo tagInfo = this.getTagInfo();
            String scheme = tagInfo.getScheme();
            String taglib = tagInfo.getTaglib();
            String prefix = tagInfo.getPrefix();
            String oldPrefix = null;
            String ns = null;
            if (scheme != null && taglib != null) {
                ns = scheme + ":" + taglib;
                if (prefix != null) {
                    oldPrefix = serializer.getPrefix(ns, false);
                    serializer.setPrefix(prefix, ns);
                } else {
                    oldPrefix = serializer.getPrefix(ns, false);
                    serializer.setPrefix("", ns);
                }
            }
            serializer.startTag(ns, tagInfo.getElement());
            MarmaladeAttributes attributes = this.getAttributes();
            Iterator it = attributes.iterator();
            while (it.hasNext()) {
                MarmaladeAttribute attribute = (MarmaladeAttribute)it.next();
                serializer.attribute(attribute.getNamespace(), attribute.getName(), attribute.getRawValue());
            }
            MarmaladeTagInfo ti = this.getTagInfo();
            List children = this.getChildComponents();
            if (!children.isEmpty()) {
                Iterator it2 = children.iterator();
                while (it2.hasNext()) {
                    Object childElement = it2.next();
                    if (childElement instanceof MarmaladeTag) {
                        MarmaladeTag child = (MarmaladeTag)childElement;
                        child.execute(context);
                        continue;
                    }
                    String text = this.formatWhitespace(String.valueOf(childElement), context);
                    serializer.text(text);
                }
            }
            serializer.endTag(ns, tagInfo.getElement());
        }
        catch (IOException e) {
            throw new TagExecutionException(this.getTagInfo(), "Error writing formatted XML.", e);
        }
    }

    protected boolean alwaysProcessChildren() {
        return false;
    }

    public void addChild(MarmaladeTag child) {
        super.addChild(child);
        this.childComponents.add(child);
    }

    public void appendBodyText(String text) {
        super.appendBodyText(text);
        this.childComponents.add(text);
    }

    protected boolean alwaysProcessBody() {
        return false;
    }
}

