/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.marmalade.util;

import java.io.IOException;
import java.io.Reader;

public final class RecordingReader
extends Reader {
    private final Reader reader;
    private StringBuffer recordedInput;

    public RecordingReader(Reader reader) {
        this.reader = reader;
    }

    public RecordingReader(Object lock, Reader reader) {
        super(lock);
        this.reader = reader;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = this.reader.read(cbuf, off, len);
        if (this.recordedInput != null && result > 0) {
            this.recordedInput.append(cbuf, off, result);
        }
        return result;
    }

    public void startRecording() {
        this.recordedInput = new StringBuffer();
    }

    public String getRecordedInput() {
        return this.recordedInput == null ? null : this.recordedInput.toString();
    }
}

